/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.service;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.AxisUtils;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskPurgeConstraint;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.service.ITaskPurgeConstraintCheck;
import com.ibm.cognos.internal.hts.service.TaskPurgeContext;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.dao.MessageUtils;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis.client.Stub;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class TaskPurgeCMConstraint
implements ITaskPurgeConstraintCheck {
    private JobBiBusHeaders m_headers;
    private HTSTask m_task;
    private static HashMap<String, Templates> m_templateMap = new HashMap();

    @Override
    public boolean canPurge(TaskPurgeContext context) throws HumanTaskServiceException {
        boolean canDelete = false;
        this.m_headers = context.getHeaders();
        this.m_task = context.getHTSTask();
        String inputMessage = MessageUtils.getInputMessage(this.m_task, null).getMessage();
        HTSTaskPurgeConstraint purgeConstraintCheck = context.getHTSTaskPurgeConstraint();
        try {
            String cmStoreIds = this.transformInputMessage(purgeConstraintCheck, inputMessage);
            if (cmStoreIds != null && !"".equals(cmStoreIds)) {
                SAXReader reader = new SAXReader();
                Element cmStoreIdsEl = reader.read((Reader)new StringReader(cmStoreIds)).getRootElement();
                canDelete = !this.checkExistsInCm(cmStoreIdsEl);
            }
        }
        catch (DocumentException cmStoreIds) {
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e, UsI18NCode.MSG_USV_EXPORT_DEPLOYMENT_FIXUP_FAILED, new Object[]{e.getMessage()});
        }
        return canDelete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkExistsInCm(Element cmStoreIdsEl) throws HumanTaskServiceException {
        boolean searchPathExistsInCM = false;
        ContentManagerServiceClientPort cmPort = null;
        try {
            List cmReferenceNodes = cmStoreIdsEl.selectNodes("./cmReference");
            ArrayList<QueryRequest> requests = new ArrayList<QueryRequest>();
            boolean hasIds = false;
            for (Node cmReferenceNode : cmReferenceNodes) {
                hasIds = true;
                QueryRequest request = new QueryRequest();
                String id = cmReferenceNode.selectSingleNode("./id").getText();
                if (id == null || "".equals(id)) continue;
                hasIds = true;
                request.setSearch(ObjectModelUtil.getSearchPathFromGuid((String)id).get_value());
                request.setProperties(new PropEnum[]{PropEnum.storeID});
                requests.add(request);
            }
            if (hasIds) {
                cmPort = Client.instance().getContentManagerServiceClient(this.m_headers);
                cmPort.signNextRequest("SDS");
                AxisUtils.setHeader((Stub)cmPort.getBinding(), (BiBusHeader)this.m_headers.getBiBusHeader());
                QueryReply[] replies = cmPort.queryMultiple(requests.toArray(new QueryRequest[0]));
                searchPathExistsInCM = this.checkExists(replies);
            }
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e, UsI18NCode.MSG_USV_EXPORT_DEPLOYMENT_FIXUP_FAILED);
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        return searchPathExistsInCM;
    }

    private boolean checkExists(QueryReply[] replies) {
        boolean existsInCM = false;
        for (int i = 0; i < replies.length; ++i) {
            String id;
            BaseClass base = ObjectModelUtil.getBaseClass((BaseClass[])replies[i].getQueryResult(), (int)0);
            String string = id = base != null ? base.getStoreID().getValue().get_value() : null;
            if (id == null) continue;
            existsInCM = true;
            break;
        }
        return existsInCM;
    }

    private String transformInputMessage(HTSTaskPurgeConstraint taskPurgeConstraint, String inputMessage) throws HumanTaskServiceException {
        StringWriter writer = new StringWriter();
        try {
            Transformer transformer = this.getTransformer(taskPurgeConstraint);
            StringReader reader = new StringReader(inputMessage);
            transformer.transform(new StreamSource(reader), new StreamResult(writer));
        }
        catch (Throwable t) {
            Utils.throwHumanTaskServiceException(t, UsI18NCode.MSG_USV_DEPLOYMENT_FAILED, new Object[]{t.getMessage()});
        }
        return writer.getBuffer().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transformer getTransformer(HTSTaskPurgeConstraint taskPurgeConstraint) throws TransformerConfigurationException {
        String taskPurgeConstraintId = taskPurgeConstraint.getId();
        StringReader taskPurgeConstraintValueReader = new StringReader(taskPurgeConstraint.getPurgeConstraintValue());
        if (!m_templateMap.containsKey(taskPurgeConstraintId)) {
            HashMap<String, Templates> hashMap = m_templateMap;
            synchronized (hashMap) {
                if (!m_templateMap.containsKey(taskPurgeConstraintId)) {
                    TransformerFactory tFactory = TransformerFactory.newInstance();
                    Templates template = tFactory.newTemplates(new StreamSource(taskPurgeConstraintValueReader));
                    m_templateMap.put(taskPurgeConstraintId, template);
                }
            }
        }
        Templates template = m_templateMap.get(taskPurgeConstraintId);
        return template.newTransformer();
    }
}

