/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.service;

import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskPurgeConstraint;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskclass;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.service.ITaskPurgeConstraintCheck;
import com.ibm.cognos.internal.hts.service.TaskPurgeContext;
import com.ibm.cognos.internal.hts.util.Utils;
import java.util.List;

public class TaskPurgeCheck {
    public boolean canPurge(TaskPurgeContext context) throws HumanTaskServiceException {
        boolean canDelete;
        block3: {
            canDelete = true;
            HTSTaskclass taskClass = context.getHTSTask().getHtsTaskclass();
            List<HTSTaskPurgeConstraint> taskPurgeConstraint = taskClass.getHtsTaskPurgeConstraints();
            try {
                if (taskPurgeConstraint == null) break block3;
                for (HTSTaskPurgeConstraint constraint : taskPurgeConstraint) {
                    String className = constraint.getPurgeConstraintClass();
                    Class<?> cls = Class.forName(className);
                    Object instance = cls.newInstance();
                    if (!(instance instanceof ITaskPurgeConstraintCheck)) continue;
                    ITaskPurgeConstraintCheck purgeConstraintCheck = (ITaskPurgeConstraintCheck)instance;
                    context.setHTSTaskPurgeConstraint(constraint);
                    canDelete = purgeConstraintCheck.canPurge(context);
                    if (canDelete) continue;
                    break;
                }
            }
            catch (Exception e) {
                Utils.throwHumanTaskServiceException(e, UsI18NCode.MSG_USV_EXPORT_DEPLOYMENT_FIXUP_FAILED, new Object[]{e.getMessage()});
            }
        }
        return canDelete;
    }
}

