/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.service;

import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logging.USCategory;
import com.ibm.cognos.internal.hts.persist.dao.ITransactionHandler;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.OpenJPAUtil;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.PersistenceUnit;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.service.ServiceHandler;
import com.ibm.cognos.internal.hts.service.ServiceResponse;
import com.ibm.cognos.internal.hts.service.ws_ht.HandlerChain;
import com.ibm.cognos.internal.hts.util.Utils;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class TransactionSessionHandler
extends HandlerChain
implements ServiceHandler {
    protected static final Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(TransactionSessionHandler.class.getName());

    public TransactionSessionHandler(ServiceHandler handler) {
        super(handler);
    }

    @Override
    public ServiceResponse execute(BIBusEnvelope requestEnvelope) throws HumanTaskServiceException {
        ServiceResponse result = new ServiceResponse();
        String name = requestEnvelope.getBody().selectSingleNode("./*").getName();
        ITransactionHandler handler = null;
        try {
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("about to handle User service call " + name);
            handler = new OpenJPAUtil(PersistenceUnit.HUMANTASK_SERVICE);
            handler.openSession();
            AbstractContext.setCurrentTransactionHandler(handler);
            result = super.execute(requestEnvelope);
        }
        catch (HumanTaskServiceException t) {
            Utils.logException((Throwable)((Object)t), UsI18NCode.MSG_US_SERVICE_HANDLER_ERROR, new Object[]{name, t.getLocalizedMessage()});
            try {
                if (handler != null) {
                    handler.rollbackTransaction();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw t;
        }
        finally {
            if (handler != null) {
                handler.closeSession();
            }
            AbstractContext.setCurrentTransactionHandler(null);
        }
        return result;
    }
}

