/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.service.callback;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.jsmcommon.http.HTTPRequest;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPException;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logging.USCategory;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSCallback;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskclass;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.service.callback.ClientCallback;
import com.ibm.cognos.internal.hts.util.dao.CallbackUtilities;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.InputSource;

public class HTTPCallback
implements ClientCallback {
    @Override
    public Object callServerMethod(IAbstractContext context, HTSCallback callback, HTSTaskclass taskClass, Object[] args) throws Exception {
        HTTPRequest request = null;
        request = callback.getAddress() != null && !"".equals(callback.getAddress()) ? new HTTPRequest(callback.getAction(), callback.getAddress()) : new HTTPRequest(callback.getAction());
        BiBusHeader biBusHeader = context.getHeader().getBiBusHeader();
        BIBusEnvelope envelope = BiBusUtilities.getHeadedEnvelope((BiBusHeader)biBusHeader);
        CallbackUtilities.addCallbackHeaders(envelope, callback);
        String operation = null;
        operation = callback.getOperation() != null && !"".equals(callback.getOperation()) ? callback.getOperation() : taskClass.getResponseOperation();
        Document bodyDoc = DocumentHelper.createDocument();
        Element op = bodyDoc.addElement(operation);
        SAXReader reader = new SAXReader();
        Element taskData = DocumentHelper.createElement((String)"taskData");
        op.add(taskData);
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i] == null) continue;
            StringReader argReader = new StringReader(args[i].toString());
            InputSource argSrc = new InputSource(argReader);
            Element arg = reader.read(argSrc).getRootElement();
            taskData.add(arg);
        }
        envelope.getBody().add(bodyDoc.getRootElement().detach());
        String response = null;
        try {
            StringWriter aWriter = new StringWriter();
            OutputFormat format = new OutputFormat();
            format.setNewLineAfterDeclaration(false);
            XMLWriter xmlWriter = new XMLWriter((Writer)aWriter, format);
            xmlWriter.write(envelope.getAsDocument());
            xmlWriter.flush();
            request.setRequestBody(aWriter.toString());
            response = request.retrieveContent();
        }
        catch (IOException e) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_CANNOT_COMPLETE, e);
        }
        BIBusEnvelope responseEnvelope = null;
        try {
            responseEnvelope = new BIBusEnvelope((Reader)new StringReader(response));
            if (responseEnvelope.getFaultString() != null) {
                SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug(responseEnvelope.toString());
                throw new HumanTaskServiceException(UsI18NCode.MSG_US_CANNOT_COMPLETE);
            }
        }
        catch (SOAPException e) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_CANNOT_COMPLETE, e);
        }
        return response;
    }
}

