/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.service.ws_ht;

import com.ibm.cognos.internal.hts.apiHandlers.APIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.ActivateHandler;
import com.ibm.cognos.internal.hts.apiHandlers.AddAttachmentHandler;
import com.ibm.cognos.internal.hts.apiHandlers.AddCommentHandler;
import com.ibm.cognos.internal.hts.apiHandlers.AddCommentReplyHandler;
import com.ibm.cognos.internal.hts.apiHandlers.AssignFolderToTasksHandler;
import com.ibm.cognos.internal.hts.apiHandlers.ChangeSubscriptionHandler;
import com.ibm.cognos.internal.hts.apiHandlers.ClaimHandler;
import com.ibm.cognos.internal.hts.apiHandlers.CompleteAgentUserTaskHandler;
import com.ibm.cognos.internal.hts.apiHandlers.CompleteApproveManualTaskHandler;
import com.ibm.cognos.internal.hts.apiHandlers.CompleteHandler;
import com.ibm.cognos.internal.hts.apiHandlers.CompleteNotificationHandler;
import com.ibm.cognos.internal.hts.apiHandlers.CreateChildTaskHandler;
import com.ibm.cognos.internal.hts.apiHandlers.CreateEmailNotificationTaskHandler;
import com.ibm.cognos.internal.hts.apiHandlers.CreateManualTaskHandler;
import com.ibm.cognos.internal.hts.apiHandlers.CreateNotificationManualTaskHandler;
import com.ibm.cognos.internal.hts.apiHandlers.CreatePushNotificationMessageTaskHandler;
import com.ibm.cognos.internal.hts.apiHandlers.DefineHumanInteractionHandler;
import com.ibm.cognos.internal.hts.apiHandlers.DelegateHandler;
import com.ibm.cognos.internal.hts.apiHandlers.DeleteAttachmentsHandler;
import com.ibm.cognos.internal.hts.apiHandlers.DeleteFaultHandler;
import com.ibm.cognos.internal.hts.apiHandlers.DeleteOutputHandler;
import com.ibm.cognos.internal.hts.apiHandlers.DeleteTaskHandler;
import com.ibm.cognos.internal.hts.apiHandlers.ExitHandler;
import com.ibm.cognos.internal.hts.apiHandlers.FailHandler;
import com.ibm.cognos.internal.hts.apiHandlers.ForwardHandler;
import com.ibm.cognos.internal.hts.apiHandlers.GetAttachmentInfosHandler;
import com.ibm.cognos.internal.hts.apiHandlers.GetAttachmentsHandler;
import com.ibm.cognos.internal.hts.apiHandlers.GetCommentInfoHandler;
import com.ibm.cognos.internal.hts.apiHandlers.GetCommentsByTypeHandler;
import com.ibm.cognos.internal.hts.apiHandlers.GetCommentsHandler;
import com.ibm.cognos.internal.hts.apiHandlers.GetFaultHandler;
import com.ibm.cognos.internal.hts.apiHandlers.GetFoldersListHandler;
import com.ibm.cognos.internal.hts.apiHandlers.GetInputHandler;
import com.ibm.cognos.internal.hts.apiHandlers.GetMyTaskAbstractsHandler;
import com.ibm.cognos.internal.hts.apiHandlers.GetMyTasksHandler;
import com.ibm.cognos.internal.hts.apiHandlers.GetOutputHandler;
import com.ibm.cognos.internal.hts.apiHandlers.GetRenderingHandler;
import com.ibm.cognos.internal.hts.apiHandlers.GetRenderingTypesHandler;
import com.ibm.cognos.internal.hts.apiHandlers.GetTaskDescriptionHandler;
import com.ibm.cognos.internal.hts.apiHandlers.GetTaskInfoHandler;
import com.ibm.cognos.internal.hts.apiHandlers.GetUnsubscriptionsHandler;
import com.ibm.cognos.internal.hts.apiHandlers.IAPIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.NominateHandler;
import com.ibm.cognos.internal.hts.apiHandlers.PerfDataHandler;
import com.ibm.cognos.internal.hts.apiHandlers.QueryHandler;
import com.ibm.cognos.internal.hts.apiHandlers.ReassignHandler;
import com.ibm.cognos.internal.hts.apiHandlers.ReleaseHandler;
import com.ibm.cognos.internal.hts.apiHandlers.RemoveHandler;
import com.ibm.cognos.internal.hts.apiHandlers.ReopenHandler;
import com.ibm.cognos.internal.hts.apiHandlers.ResumeHandler;
import com.ibm.cognos.internal.hts.apiHandlers.SetFaultHandler;
import com.ibm.cognos.internal.hts.apiHandlers.SetGenericHumanRoleHandler;
import com.ibm.cognos.internal.hts.apiHandlers.SetOutputHandler;
import com.ibm.cognos.internal.hts.apiHandlers.SetPriorityHandler;
import com.ibm.cognos.internal.hts.apiHandlers.SkipHandler;
import com.ibm.cognos.internal.hts.apiHandlers.StartHandler;
import com.ibm.cognos.internal.hts.apiHandlers.StopHandler;
import com.ibm.cognos.internal.hts.apiHandlers.SuspendHandler;
import com.ibm.cognos.internal.hts.apiHandlers.SuspendUntilHandler;
import com.ibm.cognos.internal.hts.apiHandlers.UpdateManualTaskHandler;
import com.ibm.cognos.internal.hts.apiHandlers.genHandlers.RetryHandler;
import com.ibm.cognos.internal.hts.apiHandlers.genHandlers.TransactionHandler;
import com.ibm.cognos.internal.hts.apiHandlers.logging.AuditLogHandler;
import com.ibm.cognos.internal.hts.apiHandlers.logging.IPFLogHandler;
import com.ibm.cognos.internal.hts.apiHandlers.notification.EscalationNotificationHandler;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskclass;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceOperations;
import com.ibm.cognos.internal.hts.service.ws_ht.IHandlerMap;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.dao.TaskclassUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HandlerMap
implements HumanTaskServiceOperations,
IHandlerMap {
    private Map<String, IAPIHandler> m_handler_map = new HashMap<String, IAPIHandler>();

    @Override
    public IAPIHandler getHandler(String opName) throws HumanTaskServiceException {
        IAPIHandler handler = this.m_handler_map.get(opName);
        if (handler == null) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_SERVICE_NO_HANDLER, new Object[]{opName});
        }
        return handler;
    }

    @Override
    public void setHandler(String method, APIHandler handler) {
        this.m_handler_map.put(method, this.buildHandlerChain(handler, false));
    }

    public void setHandler(String method, APIHandler handler, boolean escalation, boolean transaction) {
        if (escalation) {
            this.m_handler_map.put(method, this.buildHandlerChain(handler, transaction));
        } else {
            this.m_handler_map.put(method, this.buildHandlerChainWithoutEscalation(handler, transaction));
        }
    }

    @Override
    public void registerTaskClass(HTSTaskclass taskClass) throws HumanTaskServiceException {
        this.checkOperation(taskClass);
        String portType = taskClass.getPortType();
        String oprnName = taskClass.getOperation();
        if (portType.equals("{http://www.ibm.com/xmlns/prod/cognos/internal/hts/emailnotification/_1}emailNotificationTaskPortType")) {
            this.setHandler(oprnName, new CreateEmailNotificationTaskHandler(), false, false);
        } else if (portType.equals("{http://www.ibm.com/xmlns/prod/cognos/internal/hts/pushnotificationmessage/_1}pushNotificationMessageTaskPortType")) {
            this.setHandler(oprnName, new CreatePushNotificationMessageTaskHandler(), false, false);
        } else if (HTSTask.TYPE.NOTIFICATION.getType().equals(taskClass.getTaskType())) {
            this.setHandler(oprnName, new CreateNotificationManualTaskHandler(), true, false);
        } else {
            this.setHandler(oprnName, new CreateManualTaskHandler(), true, false);
        }
    }

    @Override
    public List<String> getOperationsForHandler(Class handler_class) {
        ArrayList<String> ops = new ArrayList<String>();
        for (Map.Entry<String, IAPIHandler> entry : this.m_handler_map.entrySet()) {
            if (!handler_class.equals(entry.getValue().getClass())) continue;
            ops.add(entry.getKey());
        }
        return ops;
    }

    private void checkOperation(HTSTaskclass taskClass) throws HumanTaskServiceException {
        boolean throwEx;
        String op = "";
        boolean bl = throwEx = taskClass == null || taskClass != null && taskClass.getOperation() == null;
        if (taskClass != null) {
            String string = op = taskClass.getOperation() == null ? "null" : taskClass.getOperation();
        }
        if (throwEx) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_OPERATION_NAME, new Object[]{op});
        }
    }

    HandlerMap() {
        this.reset();
    }

    @Override
    public void reset() {
        this.m_handler_map.clear();
        this.setHandler("completeApproveManualTask", new CompleteApproveManualTaskHandler(), true, false);
        this.setHandler("completeAgentUserTask", new CompleteAgentUserTaskHandler(), true, false);
        this.setHandler("humanInteractions", new DefineHumanInteractionHandler(), false, true);
        this.setHandler("updateTaskDetails", new UpdateManualTaskHandler(), true, false);
        this.setHandler("assignFolderToTasks", new AssignFolderToTasksHandler(), false, true);
        this.setHandler("exit", new ExitHandler(), true, true);
        this.setHandler("claim", new ClaimHandler(), true, false);
        this.setHandler("start", new StartHandler(), true, false);
        this.setHandler("release", new ReleaseHandler(), true, true);
        this.setHandler("suspend", new SuspendHandler(), true, true);
        this.setHandler("suspendUntil", new SuspendUntilHandler(), true, true);
        this.setHandler("resume", new ResumeHandler(), true, true);
        this.setHandler("complete", new CompleteHandler(), true, true);
        this.setHandler("remove", new RemoveHandler(), true, true);
        this.setHandler("fail", new FailHandler(), true, true);
        this.setHandler("stop", new StopHandler(), true, false);
        this.setHandler("setPriority", new SetPriorityHandler(), true, true);
        this.setHandler("addAttachment", new AddAttachmentHandler(), false, true);
        this.setHandler("getAttachmentInfos", new GetAttachmentInfosHandler(), false, false);
        this.setHandler("getAttachments", new GetAttachmentsHandler(), false, false);
        this.setHandler("deleteAttachments", new DeleteAttachmentsHandler(), false, true);
        this.setHandler("addComment", new AddCommentHandler(), true, true);
        this.setHandler("getComments", new GetCommentsHandler(), false, false);
        this.setHandler("skip", new SkipHandler(), true, true);
        this.setHandler("forward", new ForwardHandler(), true, false);
        this.setHandler("delegate", new DelegateHandler(), true, false);
        this.setHandler("getRendering", new GetRenderingHandler(), false, false);
        this.setHandler("getRenderingTypes", new GetRenderingTypesHandler(), false, false);
        this.setHandler("getTaskInfo", new GetTaskInfoHandler(), false, false);
        this.setHandler("getTaskDescription", new GetTaskDescriptionHandler(), false, false);
        this.setHandler("setOutput", new SetOutputHandler(), false, true);
        this.setHandler("deleteOutput", new DeleteOutputHandler(), false, true);
        this.setHandler("setFault", new SetFaultHandler(), false, true);
        this.setHandler("deleteFault", new DeleteFaultHandler(), false, true);
        this.setHandler("getInput", new GetInputHandler(), false, true);
        this.setHandler("getOutput", new GetOutputHandler(), false, false);
        this.setHandler("getFault", new GetFaultHandler(), false, false);
        this.setHandler("getMyTaskAbstracts", new GetMyTaskAbstractsHandler(), false, false);
        this.setHandler("getMyTasks", new GetMyTasksHandler(), false, false);
        this.setHandler("query", new QueryHandler(), false, false);
        this.setHandler("activate", new ActivateHandler(), true, true);
        this.setHandler("nominate", new NominateHandler(), true, true);
        this.setHandler("setGenericHumanRole", new SetGenericHumanRoleHandler(), true, true);
        this.setHandler("createChildTasks", new CreateChildTaskHandler(), false, true);
        this.setHandler("reopen", new ReopenHandler(), true, true);
        this.setHandler("deleteTask", new DeleteTaskHandler(), true, true);
        this.setHandler("addCommentReply", new AddCommentReplyHandler(), true, true);
        this.setHandler("reassign", new ReassignHandler(), true, true);
        this.setHandler("getCommentsByType", new GetCommentsByTypeHandler(), false, false);
        this.setHandler("getCommentInfo", new GetCommentInfoHandler(), false, false);
        this.setHandler("changeSubscription", new ChangeSubscriptionHandler(), false, true);
        this.setHandler("getUnsubscriptions", new GetUnsubscriptionsHandler(), false, false);
        this.setHandler("completeNotification", new CompleteNotificationHandler(), false, true);
        this.setHandler("getFoldersList", new GetFoldersListHandler(), false, true);
        this.setHandler("startPerfDataCollection", new PerfDataHandler(true), false, false);
        this.setHandler("getPerfData", new PerfDataHandler(false), false, false);
        this.addDynamicMappings();
    }

    private void addDynamicMappings() {
        List<HTSTaskclass> TaskClasses = TaskclassUtil.getTaskClasses();
        try {
            for (HTSTaskclass taskclass : TaskClasses) {
                this.registerTaskClass(taskclass);
            }
        }
        catch (Throwable e) {
            Utils.logException(e);
        }
    }

    private IAPIHandler buildHandlerChainWithoutEscalation(IAPIHandler handler, boolean transaction) {
        if (transaction) {
            handler = new RetryHandler(new TransactionHandler(handler));
        }
        handler.setSuccessor(new AuditLogHandler()).setSuccessor(new IPFLogHandler());
        return handler;
    }

    private IAPIHandler buildHandlerChain(IAPIHandler handler, boolean transaction) {
        if (transaction) {
            handler = new RetryHandler(new TransactionHandler(handler));
        }
        handler.setSuccessor(new AuditLogHandler()).setSuccessor(new IPFLogHandler()).setSuccessor(new EscalationNotificationHandler());
        return handler;
    }
}

