/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.service.ws_ht;

import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.Headers;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.hts.apiHandlers.IAPIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.genHandlers.AuthenticationHandler;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logging.USCategory;
import com.ibm.cognos.internal.hts.persist.dao.pojo.types.FaultType;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.service.ServiceHandler;
import com.ibm.cognos.internal.hts.service.ServiceResponse;
import com.ibm.cognos.internal.hts.service.ws_ht.HandlerChain;
import com.ibm.cognos.internal.hts.service.ws_ht.HandlerMapFactory;
import com.ibm.cognos.internal.hts.service.ws_ht.deployment.DeployManualTasks;
import com.ibm.cognos.internal.hts.util.BiBusHeaderUtilities;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.HumanTaskServiceExceptionDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.IllegalAccessDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.IllegalArgumentDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.IllegalOperationDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.IllegalStateDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.RecipientNotAllowedDocument;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class HumanTaskServiceHandler
extends HandlerChain {
    private static final Namespace NS_SOAP_ENV = Namespace.get((String)"SOAP-ENV", (String)"http://schemas.xmlsoap.org/soap/envelope/");
    private static final QName SOAP_ENV_FAULT = new QName("Fault", NS_SOAP_ENV);
    private static final String SOAP_ENV_FAULT_CODE = "faultcode";
    private static final String SOAP_ENV_FAULT_STRING = "faultstring";
    private static final String SOAP_ENV_FAULT_DETAIL = "detail";

    public HumanTaskServiceHandler(ServiceHandler chain) {
        super(chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceResponse execute(BIBusEnvelope requestEnvelope) throws HumanTaskServiceException {
        ServiceResponse result = new ServiceResponse();
        String name = requestEnvelope.getBody().selectSingleNode("./*").getName();
        IAbstractContext context = null;
        try {
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug("about to handle User service call " + name);
            IAPIHandler handler = HandlerMapFactory.getHandlerMap().getHandler(name);
            AbstractContext.setThreadProperties(new HashMap<String, Object>());
            context = handler.makeContext(requestEnvelope);
            AuthenticationHandler authhandler = new AuthenticationHandler(handler);
            authhandler.handleRequest(context);
            Object response = context.getAPIResponseObject();
            result.setResponse(HTSSDKUtils.marshallAPIObjectToElement(response));
            result.setHeader(context.getResponseHeader());
        }
        catch (Throwable t) {
            Utils.logException(t, UsI18NCode.MSG_US_SERVICE_HANDLER_ERROR, new Object[]{name, t.getLocalizedMessage()});
            try {
                if (context != null) {
                    context.getTransactionHandler().rollbackTransaction();
                }
            }
            catch (Throwable authhandler) {
                // empty catch block
            }
            Headers responseHeader = BiBusHeaderUtilities.retrieveHeader(requestEnvelope);
            if (context != null && context.getResponseHeader() != null) {
                responseHeader = context.getResponseHeader();
            }
            result = this.buildFault(t, responseHeader);
        }
        finally {
            AbstractContext.setThreadProperties(null);
        }
        super.execute(result);
        return result;
    }

    private ServiceResponse buildFault(Throwable t, Headers header) {
        ServiceResponse response = new ServiceResponse();
        response.setResponse(HumanTaskServiceHandler.buildFaultElement(t));
        response.setHeader(header);
        return response;
    }

    public static Element buildFaultElement(Throwable t) {
        Element xfaultEle = null;
        try {
            String fString;
            xfaultEle = DocumentHelper.createElement((QName)SOAP_ENV_FAULT);
            Element faultCode = xfaultEle.addElement(SOAP_ENV_FAULT_CODE);
            Element faultString = xfaultEle.addElement(SOAP_ENV_FAULT_STRING);
            Element faultDetail = xfaultEle.addElement(SOAP_ENV_FAULT_DETAIL);
            HumanTaskServiceHandler.fillFaultDetailElement(faultDetail, t);
            String fCode = HumanTaskServiceHandler.getFaultCode(t);
            if (fCode != null && !"".equals(fCode)) {
                faultCode.setText(fCode);
            }
            if ((fString = HumanTaskServiceHandler.getFaultString(t)) != null && !"".equals(fString)) {
                faultString.setText(fString);
            }
        }
        catch (Exception e) {
            Utils.logException(e, UsI18NCode.MSG_US_SERVICE_HANDLER_ERROR, new Object[]{e.getMessage(), e.getLocalizedMessage()});
        }
        return xfaultEle;
    }

    private static Element fillFaultDetailElement(Element faultDetail, Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        String stack = sw.toString();
        IllegalAccessDocument xFaultObject = null;
        try {
            if (t instanceof HumanTaskServiceException) {
                HumanTaskServiceException use = (HumanTaskServiceException)((Object)t);
                FaultType faultType = use.getFaultType();
                if (FaultType.ILLEGAL_ACCESS.equals((Object)faultType)) {
                    IllegalAccessDocument xfault = IllegalAccessDocument.Factory.newInstance();
                    xfault.setIllegalAccess(stack);
                    xFaultObject = xfault;
                } else if (FaultType.ILLEGAL_ARG.equals((Object)faultType)) {
                    IllegalArgumentDocument xfault = IllegalArgumentDocument.Factory.newInstance();
                    xfault.setIllegalArgument(stack);
                    xFaultObject = xfault;
                } else if (FaultType.ILLEGAL_OP.equals((Object)faultType)) {
                    IllegalOperationDocument xfault = IllegalOperationDocument.Factory.newInstance();
                    xfault.setIllegalOperation(stack);
                    xFaultObject = xfault;
                } else if (FaultType.ILLEGAL_STATE.equals((Object)faultType)) {
                    IllegalStateDocument xfault = IllegalStateDocument.Factory.newInstance();
                    xfault.addNewIllegalState();
                    xfault.getIllegalState().setMessage(stack);
                    xFaultObject = xfault;
                    TStatus.Enum tsEnum = HumanTaskServiceHandler.getStatus(use, xfault);
                    xfault.getIllegalState().setStatus(tsEnum);
                } else if (FaultType.RECIP_NOT_ALLOWED.equals((Object)use.getFaultType())) {
                    RecipientNotAllowedDocument xfault = RecipientNotAllowedDocument.Factory.newInstance();
                    xfault.setRecipientNotAllowed(stack);
                    xFaultObject = xfault;
                } else if (FaultType.HUMAN_TASK_SERVICE.equals((Object)use.getFaultType())) {
                    HumanTaskServiceExceptionDocument xfault = HumanTaskServiceExceptionDocument.Factory.newInstance();
                    xfault.setHumanTaskServiceException(stack);
                    xFaultObject = xfault;
                }
            }
            if (xFaultObject == null) {
                faultDetail.setText(stack);
            } else {
                faultDetail.add(HTSSDKUtils.marshallAPIObjectToElement(xFaultObject));
            }
        }
        catch (Exception e) {
            Utils.logException(e);
            faultDetail.setText(stack);
        }
        return faultDetail;
    }

    private static TStatus.Enum getStatus(HumanTaskServiceException use, IllegalStateDocument xfault) {
        String statusString = use.getParams() != null && use.getParams().length > 0 ? use.getParams()[0].toString() : null;
        TStatus.Enum tsEnum = null;
        if (statusString != null) {
            tsEnum = TStatus.Enum.forString(statusString);
        }
        if (tsEnum == null) {
            tsEnum = TStatus.ERROR;
        }
        xfault.getIllegalState().setStatus(tsEnum);
        return tsEnum;
    }

    private static String getFaultCode(Throwable t) {
        String code = "Server Fault Code";
        if (t instanceof LocalizableException) {
            LocalizableException le = (LocalizableException)t;
            code = le.getI18NCode().getCode();
        }
        return code;
    }

    private static String getFaultString(Throwable t) {
        String code = "Server Fault String";
        code = t.getLocalizedMessage();
        return code;
    }

    @Override
    public void initialize() {
        try {
            new DeployManualTasks().initialize();
        }
        catch (Exception e) {
            Utils.logException(e);
        }
    }
}

