/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.service.ws_ht.deployment;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.hts.apiHandlers.IAPIHandler;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.DefineHumanInteractionContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.OpenJPAUtil;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.PersistenceUnit;
import com.ibm.cognos.internal.hts.properties.HTSServerProperties;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.service.ws_ht.HandlerMapFactory;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.ws_ht.HumanInteractionsDocument;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class DeployManualTasks {
    public static final String DEPLOYMENT_TEMPLATES = "deployment.templates";
    public static final String TEST_TEMPLATES = "test.templates";
    private static Set<String> localOperations = new HashSet<String>();

    public static boolean isLocalOperation(String operation) {
        return localOperations.contains(operation);
    }

    public void initialize() throws HumanTaskServiceException {
        this.initialize(DEPLOYMENT_TEMPLATES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(String templateProperty) throws HumanTaskServiceException {
        StringTokenizer tolkeinizer = this.getTemplateResources(templateProperty);
        if (AbstractContext.getCurrentTransactionHandler() == null) {
            OpenJPAUtil tHandler = new OpenJPAUtil(PersistenceUnit.HUMANTASK_SERVICE);
            try {
                tHandler.openSession();
                AbstractContext.setCurrentTransactionHandler(tHandler);
                this.init(tolkeinizer);
            }
            finally {
                tHandler.closeSession();
                AbstractContext.setCurrentTransactionHandler(null);
            }
        } else {
            this.init(tolkeinizer);
        }
    }

    private void init(StringTokenizer tolkeinizer) throws HumanTaskServiceException {
        while (tolkeinizer.hasMoreElements()) {
            try {
                String taskClassTemplatePath = tolkeinizer.nextToken().trim();
                this.initializeTaskClass(taskClassTemplatePath);
            }
            catch (Exception ex) {
                Utils.logException(ex, UsI18NCode.MSG_US_SERVICE_TASK_LOAD_ERROR, new Object[0]);
            }
        }
    }

    public void initializeTaskClass(String template) throws HumanTaskServiceException {
        try {
            BIBusEnvelope biBusEnvelope = new BIBusEnvelope();
            Element root = this.getTemplate(template);
            this.doReplacements(root);
            this.saveLocalOperations(root);
            biBusEnvelope.getBody().add(root);
            this.callHumanTaskrService(biBusEnvelope);
        }
        catch (Exception ex) {
            Utils.logException(ex, UsI18NCode.MSG_US_SERVICE_TASK_LOAD_ERROR, new Object[]{template});
            Utils.throwHumanTaskServiceException(ex);
        }
    }

    public StringTokenizer getTemplateResources(String templateProperty) {
        String deployments = HTSServerProperties.getInstance().getProperty(templateProperty);
        return new StringTokenizer(deployments, ",");
    }

    public List<HumanInteractionsDocument> list() {
        return this.list(DEPLOYMENT_TEMPLATES);
    }

    public List<HumanInteractionsDocument> list(String templateProperty) {
        StringTokenizer tolkeinizer = this.getTemplateResources(templateProperty);
        ArrayList<HumanInteractionsDocument> createList = new ArrayList<HumanInteractionsDocument>();
        while (tolkeinizer.hasMoreElements()) {
            String elem = tolkeinizer.nextToken();
            try {
                HumanInteractionsDocument cmtcd = HumanInteractionsDocument.Factory.parse((InputStream)this.getClass().getResourceAsStream(elem));
                createList.add(cmtcd);
            }
            catch (Exception ex) {
                Utils.logException(ex, UsI18NCode.MSG_US_SERVICE_TASK_LOAD_ERROR, new Object[]{elem});
            }
        }
        return createList;
    }

    private Element getTemplate(String resource) throws Exception {
        Element root = null;
        SAXReader reader = new SAXReader();
        root = reader.read(this.getClass().getResourceAsStream(resource)).getRootElement();
        return root;
    }

    private void saveLocalOperations(Element root) {
        Node node = root.selectSingleNode("//*[local-name()='interface']/@operation");
        if (node != null && node.getText() != null) {
            localOperations.add(node.getText());
        }
    }

    private void doReplacements(Element root) {
        String replacement;
        Node node = root.selectSingleNode("//*[local-name()='import']/@location");
        if (node != null && node.getText() != null && (replacement = HTSServerProperties.getInstance().getProperty("internalDispatcher")) != null) {
            String replaced = node.getText().replace("@@SERVER@@", replacement);
            node.setText(replaced);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callHumanTaskrService(BIBusEnvelope envelope) throws Exception {
        try {
            AbstractContext.setThreadProperties(new HashMap<String, Object>());
            DefineHumanInteractionContext context = new DefineHumanInteractionContext(envelope);
            IAPIHandler handler = HandlerMapFactory.getHandlerMap().getHandler("humanInteractions");
            handler.handleRequest(context);
        }
        finally {
            AbstractContext.setThreadProperties(null);
        }
    }
}

