/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.status;

import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskReadBy;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.status.Operation;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractState {
    private TStatus.Enum m_status;
    private HTSTask.TYPE m_task_type;
    private HTSRole.Roles[] m_user_roles;

    public AbstractState() throws HumanTaskServiceException {
    }

    public AbstractState(TStatus.Enum status, HTSRole.Roles[] roles, HTSTask.TYPE type) throws HumanTaskServiceException {
        this.m_status = status;
        this.m_user_roles = roles;
        this.m_task_type = type;
    }

    protected List<Operation> filterListByType(List<Operation> operationList, HTSTask.TYPE type) {
        Iterator<Operation> it = operationList.iterator();
        while (it.hasNext()) {
            Operation operation = it.next();
            if (operation.validateTaskType(type)) continue;
            it.remove();
        }
        return operationList;
    }

    protected List<Operation> filterListByStatus(List<Operation> operationList, TStatus.Enum status, HTSRole.Roles[] roles) {
        Iterator<Operation> it = operationList.iterator();
        while (it.hasNext()) {
            Operation operation = it.next();
            if (operation.validateStatus(status, roles)) continue;
            it.remove();
        }
        return operationList;
    }

    protected List<Operation> filterListByReadLevel(List<Operation> operationList, HTSTaskReadBy.READ_LEVEL level) {
        Iterator<Operation> it = operationList.iterator();
        while (it.hasNext()) {
            Operation operation = it.next();
            if (operation.validateTaskReadLevel(level)) continue;
            it.remove();
        }
        return operationList;
    }

    protected List<Operation> filterListByRoles(List<Operation> operationList, HTSRole.Roles[] roles) {
        Iterator<Operation> it = operationList.iterator();
        while (it.hasNext()) {
            Operation operation = it.next();
            if (operation.validateUserRole(roles)) continue;
            it.remove();
        }
        return operationList;
    }

    public TStatus.Enum getInitialStatus() {
        return this.m_status;
    }

    public HTSTask.TYPE getTaskType() {
        return this.m_task_type;
    }

    public HTSRole.Roles[] getUserRoles() {
        return this.m_user_roles;
    }
}

