/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.status;

import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.status.AbstractState;
import com.ibm.cognos.internal.hts.status.Operation;
import com.ibm.cognos.internal.hts.status.ServiceMetadata;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MenuManagement
extends AbstractState {
    private List<Operation> m_operations = new ArrayList<Operation>();

    public MenuManagement(HTSRole.Roles[] roles, TStatus.Enum status, HTSTask.TYPE type) throws HumanTaskServiceException {
        super(status, roles, type);
        this.process();
    }

    public Map<String, Operation> getOperationList() {
        List<Operation> operations = this.getValidOperations();
        HashMap<String, Operation> finalStates = new HashMap<String, Operation>();
        for (Operation op : operations) {
            TStatus.Enum status;
            if (!US_MENUS.UI_OPERATIONS.contains(op.getOperationName()) || (status = op.getTargetStatus(this.getInitialStatus(), this.getUserRoles(), null)) == null) continue;
            finalStates.put(status.toString(), op);
        }
        return finalStates;
    }

    public List<Operation> getValidOperations() {
        return this.m_operations;
    }

    private void process() throws HumanTaskServiceException {
        List<String> operations = ServiceMetadata.getInstance().getSupportedOperations();
        for (String operationName : operations) {
            Operation validOperation = this.doOperation(operationName);
            if (validOperation == null) continue;
            this.m_operations.add(validOperation);
        }
    }

    private Operation doOperation(String operationName) throws HumanTaskServiceException {
        List<Operation> matchingList = new ArrayList<Operation>(ServiceMetadata.getInstance().getOperations(operationName));
        matchingList = this.filterListByType(matchingList, this.getTaskType());
        HTSRole.Roles[] roles = this.getUserRoles();
        matchingList = this.filterListByStatus(matchingList, this.getInitialStatus(), roles);
        if (roles != null) {
            matchingList = this.filterListByRoles(matchingList, roles);
        }
        if (matchingList.size() > 0) {
            return matchingList.get(0);
        }
        return null;
    }

    public static class US_MENUS {
        public static final String XML_MENUS = "menus";
        public static final String XML_MENU = "menu";
        public static final String XML_STAUS = "targetStatus";
        public static final String XML_OPERATION = "operation";
        public static Set<String> UI_OPERATIONS = new HashSet<String>();

        static {
            UI_OPERATIONS.add("start");
            UI_OPERATIONS.add("stop");
        }
    }
}

