/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.status;

import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskReadBy;
import com.ibm.cognos.internal.hts.status.StateMapping;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;

public final class Operation {
    private final String m_operationName;
    private final HTSRole.Roles[] m_roles;
    private final StateMapping[] m_state_mappings;
    private final HTSTask.TYPE[] m_task_types;
    private final HTSTaskReadBy.READ_LEVEL[] m_task_readLevels;

    Operation(String operationName, HTSRole.Roles[] roles, StateMapping state_mapping, HTSTask.TYPE task_type) {
        this.m_operationName = operationName;
        this.m_roles = roles;
        this.m_state_mappings = new StateMapping[]{state_mapping};
        this.m_task_types = new HTSTask.TYPE[]{task_type};
        this.m_task_readLevels = new HTSTaskReadBy.READ_LEVEL[0];
    }

    Operation(String operationName, HTSRole.Roles[] roles, StateMapping[] state_mappings, HTSTask.TYPE task_type) {
        this.m_operationName = operationName;
        this.m_roles = roles;
        this.m_state_mappings = state_mappings;
        this.m_task_types = new HTSTask.TYPE[]{task_type};
        this.m_task_readLevels = new HTSTaskReadBy.READ_LEVEL[0];
    }

    Operation(String operationName, HTSRole.Roles[] roles, StateMapping[] state_mappings, HTSTask.TYPE[] task_types, HTSTaskReadBy.READ_LEVEL[] readLevels) {
        this.m_operationName = operationName;
        this.m_roles = roles;
        this.m_state_mappings = state_mappings;
        this.m_task_types = task_types;
        this.m_task_readLevels = readLevels == null ? new HTSTaskReadBy.READ_LEVEL[]{} : readLevels;
    }

    public boolean validateOperation(HTSRole.Roles[] userRoles, TStatus.Enum status, HTSTask.TYPE type) {
        boolean isValid = true;
        isValid = isValid && this.validateTaskType(type);
        isValid = isValid && this.validateStatus(status, userRoles);
        isValid = isValid && this.validateUserRole(userRoles);
        return isValid;
    }

    public TStatus.Enum getTargetStatus(TStatus.Enum initialStatus, HTSRole.Roles[] roles, HTSTask task) {
        TStatus.Enum target = null;
        int i = 0;
        if (i < this.m_state_mappings.length && target == null) {
            target = this.m_state_mappings[i].getFinalStatus(initialStatus, roles, task);
        }
        return target;
    }

    public String getOperationName() {
        return this.m_operationName;
    }

    public boolean validateTaskReadLevel(HTSTaskReadBy.READ_LEVEL read_level) {
        boolean matchedLevel = read_level == null || this.m_task_readLevels.length == 0;
        for (int i = 0; i < this.m_task_readLevels.length && !matchedLevel; ++i) {
            if (this.m_task_readLevels[i] == null || !this.m_task_readLevels[i].equals((Object)read_level)) continue;
            matchedLevel = true;
        }
        return matchedLevel;
    }

    public boolean validateTaskType(HTSTask.TYPE type) {
        boolean matchedType = false;
        for (int i = 0; i < this.m_task_types.length && !matchedType; ++i) {
            if (this.m_task_types[i] == null || !this.m_task_types[i].equals((Object)type)) continue;
            matchedType = true;
        }
        return matchedType;
    }

    public boolean validateUserRole(HTSRole.Roles[] userRoles) {
        boolean matched = false;
        for (int i = 0; i < userRoles.length && !matched; ++i) {
            if (userRoles[i] == HTSRole.Roles.EXLUDED_OWNERS) {
                return false;
            }
            for (int j = 0; j < this.m_roles.length && !matched; ++j) {
                if (!this.m_roles[j].equals((Object)userRoles[i]) && !this.m_roles[j].equals((Object)HTSRole.Roles.ANY)) continue;
                matched = true;
            }
        }
        StringBuffer rolesString = new StringBuffer();
        for (int i = 0; i < userRoles.length; ++i) {
            if (i != 0) {
                rolesString.append(", ");
            }
            rolesString.append(userRoles[i].getRole());
        }
        return matched;
    }

    public boolean validateStatus(TStatus.Enum status, HTSRole.Roles[] userRoles) {
        boolean matchedStatus = false;
        for (int i = 0; i < this.m_state_mappings.length; ++i) {
            if (!this.m_state_mappings[i].checkInitialStatus(status, userRoles)) continue;
            matchedStatus = true;
            break;
        }
        return matchedStatus;
    }
}

