/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.status;

import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskReadBy;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceOperations;
import com.ibm.cognos.internal.hts.status.AnyReservedStateMapping;
import com.ibm.cognos.internal.hts.status.AnyStateMapping;
import com.ibm.cognos.internal.hts.status.InitialStateMapping;
import com.ibm.cognos.internal.hts.status.Operation;
import com.ibm.cognos.internal.hts.status.ReadyReservedStateMapping;
import com.ibm.cognos.internal.hts.status.StateMapping;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceMetadata
implements HumanTaskServiceOperations {
    private static ServiceMetadata m_instance = new ServiceMetadata();
    private Map<String, List<Operation>> m_operationMap = new HashMap<String, List<Operation>>();

    public static ServiceMetadata getInstance() {
        return m_instance;
    }

    public List<Operation> getOperations(String operationName) throws HumanTaskServiceException {
        List<Operation> opList = this.m_operationMap.get(operationName);
        if (opList == null || opList.size() == 0) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_SERVICE_NO_HANDLER, new Object[]{operationName});
        }
        return opList;
    }

    public List<String> getSupportedOperations() throws HumanTaskServiceException {
        return new ArrayList<String>(this.m_operationMap.keySet());
    }

    private ServiceMetadata() {
        this.add("activate", new HTSRole.Roles[]{HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.BUSINESS_ADMINISTRATORS}, (StateMapping)new ReadyReservedStateMapping(TStatus.CREATED), HTSTask.TYPE.TASK);
        this.add("release", new HTSRole.Roles[]{HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.BUSINESS_ADMINISTRATORS, HTSRole.Roles.ACTUAL_OWNER}, new StateMapping(TStatus.RESERVED, TStatus.READY), HTSTask.TYPE.TASK);
        this.add("updateTaskDetails", new HTSRole.Roles[]{HTSRole.Roles.POTENTIAL_OWNERS, HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.BUSINESS_ADMINISTRATORS, HTSRole.Roles.ACTUAL_OWNER}, (StateMapping)new AnyReservedStateMapping(new TStatus.Enum[]{TStatus.CREATED, TStatus.READY, TStatus.RESERVED, TStatus.IN_PROGRESS}), HTSTask.TYPE.TASK);
        this.add("claim", new HTSRole.Roles[]{HTSRole.Roles.POTENTIAL_OWNERS}, new StateMapping(TStatus.READY, TStatus.RESERVED), HTSTask.TYPE.TASK);
        StateMapping reopenStateMapping = new StateMapping(TStatus.COMPLETED, TStatus.IN_PROGRESS);
        reopenStateMapping.addMapping(TStatus.OBSOLETE, TStatus.IN_PROGRESS);
        this.add("reopen", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER}, reopenStateMapping, HTSTask.TYPE.TASK);
        this.add("createChildTasks", new HTSRole.Roles[]{HTSRole.Roles.POTENTIAL_OWNERS, HTSRole.Roles.TASK_STAKEHOLDERS}, (StateMapping)new AnyStateMapping(), HTSTask.TYPE.TASK);
        StateMapping startStateMapping = new StateMapping(TStatus.READY, TStatus.IN_PROGRESS);
        startStateMapping.addMapping(TStatus.RESERVED, HTSRole.Roles.ACTUAL_OWNER, TStatus.IN_PROGRESS);
        this.add("start", new HTSRole.Roles[]{HTSRole.Roles.POTENTIAL_OWNERS, HTSRole.Roles.ACTUAL_OWNER}, startStateMapping, HTSTask.TYPE.TASK);
        this.add("stop", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER}, new StateMapping(TStatus.IN_PROGRESS, TStatus.RESERVED), HTSTask.TYPE.TASK);
        this.add("complete", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER}, new StateMapping(new TStatus.Enum[]{TStatus.IN_PROGRESS, TStatus.RESERVED}, TStatus.COMPLETED), HTSTask.TYPE.TASK);
        StateMapping failMapping = new StateMapping(TStatus.IN_PROGRESS, TStatus.FAILED);
        failMapping.addMapping(TStatus.RESERVED, TStatus.FAILED);
        this.add("fail", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER}, failMapping, HTSTask.TYPE.TASK);
        StateMapping skipMapping = new StateMapping(TStatus.CREATED, TStatus.OBSOLETE);
        skipMapping.addMapping(TStatus.READY, TStatus.OBSOLETE);
        skipMapping.addMapping(TStatus.RESERVED, TStatus.OBSOLETE);
        skipMapping.addMapping(TStatus.IN_PROGRESS, TStatus.OBSOLETE);
        this.add("skip", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER, HTSRole.Roles.NOTIFICATION_RECIPIENTS, HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.BUSINESS_ADMINISTRATORS}, skipMapping, new HTSTask.TYPE[]{HTSTask.TYPE.TASK, HTSTask.TYPE.NOTIFICATION});
        this.add("setPriority", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER, HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.BUSINESS_ADMINISTRATORS}, (StateMapping)new AnyStateMapping(), new HTSTask.TYPE[]{HTSTask.TYPE.TASK, HTSTask.TYPE.NOTIFICATION});
        this.add("addAttachment", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER, HTSRole.Roles.NOTIFICATION_RECIPIENTS, HTSRole.Roles.POTENTIAL_OWNERS, HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.BUSINESS_ADMINISTRATORS}, (StateMapping)new AnyStateMapping(), new HTSTask.TYPE[]{HTSTask.TYPE.TASK, HTSTask.TYPE.NOTIFICATION});
        this.add("getAttachmentInfos", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER, HTSRole.Roles.NOTIFICATION_RECIPIENTS, HTSRole.Roles.POTENTIAL_OWNERS, HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.BUSINESS_ADMINISTRATORS}, (StateMapping)new AnyStateMapping(), new HTSTask.TYPE[]{HTSTask.TYPE.TASK, HTSTask.TYPE.NOTIFICATION});
        this.add("getAttachments", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER, HTSRole.Roles.NOTIFICATION_RECIPIENTS, HTSRole.Roles.POTENTIAL_OWNERS, HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.BUSINESS_ADMINISTRATORS}, (StateMapping)new AnyStateMapping(), new HTSTask.TYPE[]{HTSTask.TYPE.TASK, HTSTask.TYPE.NOTIFICATION});
        this.add("deleteAttachments", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER, HTSRole.Roles.NOTIFICATION_RECIPIENTS, HTSRole.Roles.POTENTIAL_OWNERS, HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.BUSINESS_ADMINISTRATORS}, (StateMapping)new AnyStateMapping(), new HTSTask.TYPE[]{HTSTask.TYPE.TASK, HTSTask.TYPE.NOTIFICATION});
        this.add("remove", new HTSRole.Roles[]{HTSRole.Roles.NOTIFICATION_RECIPIENTS}, new StateMapping(), HTSTask.TYPE.NOTIFICATION);
        this.add("addComment", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER, HTSRole.Roles.POTENTIAL_OWNERS, HTSRole.Roles.NOTIFICATION_RECIPIENTS, HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.BUSINESS_ADMINISTRATORS}, (StateMapping)new AnyStateMapping(), new HTSTask.TYPE[]{HTSTask.TYPE.TASK, HTSTask.TYPE.NOTIFICATION});
        this.add("addCommentReply", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER, HTSRole.Roles.POTENTIAL_OWNERS, HTSRole.Roles.NOTIFICATION_RECIPIENTS, HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.BUSINESS_ADMINISTRATORS}, (StateMapping)new AnyStateMapping(), new HTSTask.TYPE[]{HTSTask.TYPE.TASK, HTSTask.TYPE.NOTIFICATION});
        this.add("getComments", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER, HTSRole.Roles.POTENTIAL_OWNERS, HTSRole.Roles.NOTIFICATION_RECIPIENTS, HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.BUSINESS_ADMINISTRATORS}, (StateMapping)new AnyStateMapping(), new HTSTask.TYPE[]{HTSTask.TYPE.TASK, HTSTask.TYPE.NOTIFICATION});
        this.add("getCommentInfo", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER, HTSRole.Roles.POTENTIAL_OWNERS, HTSRole.Roles.NOTIFICATION_RECIPIENTS, HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.BUSINESS_ADMINISTRATORS}, (StateMapping)new AnyStateMapping(), new HTSTask.TYPE[]{HTSTask.TYPE.TASK, HTSTask.TYPE.NOTIFICATION});
        this.add("getCommentsByType", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER, HTSRole.Roles.POTENTIAL_OWNERS, HTSRole.Roles.NOTIFICATION_RECIPIENTS, HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.BUSINESS_ADMINISTRATORS}, (StateMapping)new AnyStateMapping(), new HTSTask.TYPE[]{HTSTask.TYPE.TASK, HTSTask.TYPE.NOTIFICATION});
        StateMapping forwardStateMapping = new StateMapping(TStatus.RESERVED, TStatus.READY);
        forwardStateMapping.addMapping(TStatus.READY, TStatus.READY);
        this.add("forward", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER, HTSRole.Roles.POTENTIAL_OWNERS, HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.BUSINESS_ADMINISTRATORS}, forwardStateMapping, HTSTask.TYPE.TASK);
        StateMapping delegateStateMapping = new StateMapping(TStatus.RESERVED, TStatus.RESERVED);
        delegateStateMapping.addMapping(TStatus.READY, TStatus.RESERVED);
        delegateStateMapping.addMapping(TStatus.IN_PROGRESS, TStatus.RESERVED);
        this.add("delegate", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER, HTSRole.Roles.POTENTIAL_OWNERS, HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.BUSINESS_ADMINISTRATORS}, delegateStateMapping, HTSTask.TYPE.TASK);
        ReadyReservedStateMapping reassignStateMapping = new ReadyReservedStateMapping(TStatus.READY);
        reassignStateMapping.addMapping(TStatus.RESERVED);
        reassignStateMapping.addMapping(TStatus.IN_PROGRESS);
        this.add("reassign", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER, HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.BUSINESS_ADMINISTRATORS}, (StateMapping)reassignStateMapping, HTSTask.TYPE.TASK);
        ReadyReservedStateMapping potentialOwnerReassignStateMapping = new ReadyReservedStateMapping(TStatus.READY);
        this.add("reassign", new HTSRole.Roles[]{HTSRole.Roles.POTENTIAL_OWNERS}, (StateMapping)potentialOwnerReassignStateMapping, HTSTask.TYPE.TASK);
        this.add("getRendering", new HTSRole.Roles[]{HTSRole.Roles.ANY}, (StateMapping)new AnyStateMapping(), new HTSTask.TYPE[]{HTSTask.TYPE.TASK, HTSTask.TYPE.NOTIFICATION});
        this.add("getRenderingTypes", new HTSRole.Roles[]{HTSRole.Roles.ANY}, (StateMapping)new AnyStateMapping(), new HTSTask.TYPE[]{HTSTask.TYPE.TASK, HTSTask.TYPE.NOTIFICATION});
        this.add("getTaskInfo", new HTSRole.Roles[]{HTSRole.Roles.ANY}, (StateMapping)new AnyStateMapping(), new HTSTask.TYPE[]{HTSTask.TYPE.TASK, HTSTask.TYPE.NOTIFICATION});
        this.add("getUnsubscriptions", new HTSRole.Roles[]{HTSRole.Roles.ANY}, (StateMapping)new AnyStateMapping(), new HTSTask.TYPE[]{HTSTask.TYPE.TASK, HTSTask.TYPE.NOTIFICATION});
        this.add("getTaskDescription", new HTSRole.Roles[]{HTSRole.Roles.ANY}, (StateMapping)new AnyStateMapping(), new HTSTask.TYPE[]{HTSTask.TYPE.TASK, HTSTask.TYPE.NOTIFICATION});
        this.add("setOutput", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER}, (StateMapping)new InitialStateMapping(new TStatus.Enum[]{TStatus.IN_PROGRESS, TStatus.RESERVED}), HTSTask.TYPE.TASK);
        this.add("deleteOutput", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER}, (StateMapping)new InitialStateMapping(new TStatus.Enum[]{TStatus.IN_PROGRESS, TStatus.RESERVED}), HTSTask.TYPE.TASK);
        this.add("deleteTask", new HTSRole.Roles[]{HTSRole.Roles.BUSINESS_ADMINISTRATORS, HTSRole.Roles.ACTUAL_OWNER, HTSRole.Roles.TASK_INITIATORS}, (StateMapping)new AnyStateMapping(), new HTSTask.TYPE[]{HTSTask.TYPE.TASK, HTSTask.TYPE.NOTIFICATION});
        StateMapping setFaultStateMapping = new StateMapping(TStatus.RESERVED, TStatus.ERROR);
        setFaultStateMapping.addMapping(TStatus.ERROR, TStatus.ERROR);
        setFaultStateMapping.addMapping(TStatus.COMPLETED, TStatus.ERROR);
        setFaultStateMapping.addMapping(TStatus.IN_PROGRESS, TStatus.ERROR);
        this.add("setFault", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER}, setFaultStateMapping, HTSTask.TYPE.TASK);
        this.add("deleteFault", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER}, (StateMapping)new InitialStateMapping(new TStatus.Enum[]{TStatus.ERROR, TStatus.COMPLETED, TStatus.FAILED}), HTSTask.TYPE.TASK);
        this.add("getInput", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER, HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.BUSINESS_ADMINISTRATORS, HTSRole.Roles.POTENTIAL_OWNERS}, (StateMapping)new AnyStateMapping(), new HTSTask.TYPE[]{HTSTask.TYPE.TASK, HTSTask.TYPE.NOTIFICATION});
        this.add("getOutput", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER, HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.BUSINESS_ADMINISTRATORS}, (StateMapping)new AnyStateMapping(), HTSTask.TYPE.TASK);
        this.add("getFault", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER, HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.BUSINESS_ADMINISTRATORS}, (StateMapping)new InitialStateMapping(new TStatus.Enum[]{TStatus.ERROR, TStatus.COMPLETED, TStatus.FAILED}), new HTSTask.TYPE[]{HTSTask.TYPE.TASK});
        this.add("getMyTaskAbstracts", new HTSRole.Roles[]{HTSRole.Roles.ANY}, (StateMapping)new AnyStateMapping(), new HTSTask.TYPE[]{HTSTask.TYPE.TASK, HTSTask.TYPE.NOTIFICATION});
        this.add("getMyTasks", new HTSRole.Roles[]{HTSRole.Roles.ANY}, (StateMapping)new AnyStateMapping(), new HTSTask.TYPE[]{HTSTask.TYPE.TASK, HTSTask.TYPE.NOTIFICATION});
        this.add("query", new HTSRole.Roles[]{HTSRole.Roles.ANY}, (StateMapping)new AnyStateMapping(), new HTSTask.TYPE[]{HTSTask.TYPE.TASK, HTSTask.TYPE.NOTIFICATION});
        this.add("changeSubscription", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER, HTSRole.Roles.NOTIFICATION_RECIPIENTS, HTSRole.Roles.POTENTIAL_OWNERS, HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.TASK_INITIATORS, HTSRole.Roles.BUSINESS_ADMINISTRATORS}, (StateMapping)new AnyStateMapping(), new HTSTask.TYPE[]{HTSTask.TYPE.TASK, HTSTask.TYPE.NOTIFICATION});
        StateMapping archiveMapping = new StateMapping(TStatus.RESERVED, TStatus.READY);
        archiveMapping.addMapping(TStatus.CREATED, TStatus.CREATED);
        archiveMapping.addMapping(TStatus.ERROR, TStatus.ERROR);
        archiveMapping.addMapping(TStatus.EXITED, TStatus.EXITED);
        archiveMapping.addMapping(TStatus.FAILED, TStatus.FAILED);
        archiveMapping.addMapping(TStatus.OBSOLETE, TStatus.OBSOLETE);
        archiveMapping.addMapping(TStatus.SUSPENDED, TStatus.SUSPENDED);
        archiveMapping.addMapping(TStatus.IN_PROGRESS, TStatus.READY);
        archiveMapping.addMapping(TStatus.READY, TStatus.READY);
        archiveMapping.addMapping(TStatus.COMPLETED, TStatus.COMPLETED);
        this.add("assignFolderToTasks", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER}, archiveMapping, new HTSTask.TYPE[]{HTSTask.TYPE.TASK});
        this.add("assignFolderToTasks", new HTSRole.Roles[]{HTSRole.Roles.ACTUAL_OWNER}, (StateMapping)new AnyStateMapping(), new HTSTask.TYPE[]{HTSTask.TYPE.NOTIFICATION});
        this.add("assignFolderToTasks", new HTSRole.Roles[]{HTSRole.Roles.NOTIFICATION_RECIPIENTS, HTSRole.Roles.POTENTIAL_OWNERS, HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.BUSINESS_ADMINISTRATORS}, (StateMapping)new AnyStateMapping(), new HTSTask.TYPE[]{HTSTask.TYPE.TASK, HTSTask.TYPE.NOTIFICATION});
        this.add("humanInteractions", new HTSRole.Roles[]{HTSRole.Roles.ANY}, (StateMapping)new AnyStateMapping(), (HTSTask.TYPE)null);
        this.add("completeApproveManualTask", new HTSRole.Roles[]{HTSRole.Roles.ANY}, (StateMapping)new AnyStateMapping(), HTSTask.TYPE.TASK);
        this.add("completeAgentUserTask", new HTSRole.Roles[]{HTSRole.Roles.ANY}, (StateMapping)new AnyStateMapping(), HTSTask.TYPE.TASK);
        ReadyReservedStateMapping createTaskStateMapping = new ReadyReservedStateMapping(TStatus.CREATED);
        this.add("createAnyUserTask", new HTSRole.Roles[]{HTSRole.Roles.ANY}, (StateMapping)createTaskStateMapping, HTSTask.TYPE.TASK);
        this.add("completeNotification", new HTSRole.Roles[]{HTSRole.Roles.NOTIFICATION_RECIPIENTS}, new StateMapping(TStatus.READY, TStatus.COMPLETED), new HTSTask.TYPE[]{HTSTask.TYPE.NOTIFICATION}, new HTSTaskReadBy.READ_LEVEL[]{HTSTaskReadBy.READ_LEVEL.LOOKED_AT});
    }

    private void add(String operation, HTSRole.Roles[] roles, StateMapping mappings, HTSTask.TYPE taskType) {
        List<Operation> operationList = this.getOperationList(operation);
        operationList.add(new Operation(operation, roles, mappings, taskType));
        this.m_operationMap.put(operation, operationList);
    }

    private void add(String operation, HTSRole.Roles[] roles, StateMapping mapping, HTSTask.TYPE[] taskTypes, HTSTaskReadBy.READ_LEVEL[] readLevels) {
        List<Operation> operationList = this.getOperationList(operation);
        operationList.add(new Operation(operation, roles, new StateMapping[]{mapping}, taskTypes, readLevels));
        this.m_operationMap.put(operation, operationList);
    }

    private void add(String operation, HTSRole.Roles[] roles, StateMapping mapping, HTSTask.TYPE[] taskTypes) {
        List<Operation> operationList = this.getOperationList(operation);
        operationList.add(new Operation(operation, roles, new StateMapping[]{mapping}, taskTypes, null));
        this.m_operationMap.put(operation, operationList);
    }

    private List<Operation> getOperationList(String operation) {
        List<Operation> operationList = null;
        operationList = this.m_operationMap.containsKey(operation) ? this.m_operationMap.get(operation) : new ArrayList<Operation>();
        return operationList;
    }
}

