/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.status;

import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskReadBy;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.status.AbstractState;
import com.ibm.cognos.internal.hts.status.Operation;
import com.ibm.cognos.internal.hts.status.ServiceMetadata;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import java.util.ArrayList;
import java.util.List;

public class StateManagement
extends AbstractState {
    private Operation m_operation = null;
    private String m_operationName;

    public StateManagement(String operationName) throws HumanTaskServiceException {
        this.m_operation = ServiceMetadata.getInstance().getOperations(operationName).get(0);
        this.m_operationName = operationName;
    }

    public StateManagement(String operationName, HTSRole.Roles[] roles, TStatus.Enum status, HTSTask.TYPE type, HTSTaskReadBy.READ_LEVEL read_level) throws HumanTaskServiceException {
        super(status, roles, type);
        this.m_operation = null;
        this.m_operationName = operationName;
        List<Operation> matchingList = new ArrayList<Operation>(ServiceMetadata.getInstance().getOperations(operationName));
        matchingList = this.filterListByType(matchingList, type);
        if (matchingList.isEmpty()) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_BAD_TASK_TYPE_FOR_OP, new Object[]{type});
        }
        if ((matchingList = this.filterListByStatus(matchingList, status, roles)).isEmpty()) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_STATUS, new Object[]{status, this.m_operationName});
        }
        if ((matchingList = this.filterListByRoles(matchingList, roles)).isEmpty()) {
            StringBuffer rolesString = new StringBuffer();
            for (int i = 0; i < roles.length; ++i) {
                if (i != 0) {
                    rolesString.append(", ");
                }
                rolesString.append(roles[i].getRole());
            }
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_ROLE, new Object[]{rolesString, this.m_operationName});
        }
        if ((matchingList = this.filterListByReadLevel(matchingList, read_level)).isEmpty()) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_STATUS, new Object[]{status, this.m_operationName});
        }
        if (matchingList.size() <= 0) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_GENERAL_ERROR);
        }
        this.m_operation = matchingList.get(0);
    }

    public TStatus.Enum getFinalStatus(HTSTask task) {
        TStatus.Enum status = this.getInitialStatus();
        if (status == null) {
            status = TStatus.Enum.forString((String)task.getStatus());
        }
        return this.m_operation.getTargetStatus(status, this.getUserRoles(), task);
    }

    public void checkInitialStatus(TStatus.Enum status, HTSRole.Roles[] roles) throws HumanTaskServiceException {
        boolean validStatus = this.m_operation.validateStatus(status, roles);
        if (!validStatus) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_STATUS, new Object[]{status, this.m_operationName});
        }
    }

    public void checkTaskType(HTSTask.TYPE taskType) throws HumanTaskServiceException {
        boolean validTaskType = this.m_operation.validateTaskType(taskType);
        if (!validTaskType) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_BAD_TASK_TYPE_FOR_OP, new Object[]{taskType});
        }
    }

    public void checkUserRoles(HTSRole.Roles[] userRoles) throws HumanTaskServiceException {
        boolean validUserRoles = this.m_operation.validateUserRole(userRoles);
        if (!validUserRoles) {
            StringBuffer rolesString = new StringBuffer();
            for (int i = 0; i < userRoles.length; ++i) {
                if (i != 0) {
                    rolesString.append(", ");
                }
                rolesString.append(userRoles[i].getRole());
            }
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_ROLE, new Object[]{rolesString, this.m_operationName});
        }
    }
}

