/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.status;

import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StateMapping {
    private RoleStatusMap statusMap = new RoleStatusMap();

    StateMapping() {
    }

    StateMapping(TStatus.Enum initialStatus, TStatus.Enum finalStatus) {
        this.addMapping(new TStatus.Enum[]{initialStatus}, HTSRole.Roles.ANY, finalStatus);
    }

    StateMapping(TStatus.Enum[] initialStatus, TStatus.Enum finalStatus) {
        this.addMapping(initialStatus, HTSRole.Roles.ANY, finalStatus);
    }

    StateMapping(TStatus.Enum[] initialStatus, HTSRole.Roles role, TStatus.Enum finalStatus) {
        this.addMapping(initialStatus, role, finalStatus);
    }

    public void addMapping(TStatus.Enum initialStatus, TStatus.Enum finalStatus) {
        this.addMapping(initialStatus, HTSRole.Roles.ANY, finalStatus);
    }

    public void addMapping(TStatus.Enum initialStatus, HTSRole.Roles role, TStatus.Enum finalStatus) {
        this.statusMap.addEntry(role, initialStatus, finalStatus);
    }

    public void addMapping(TStatus.Enum[] initialStatus, TStatus.Enum finalStatus) {
        this.addMapping(initialStatus, HTSRole.Roles.ANY, finalStatus);
    }

    public void addMapping(TStatus.Enum[] initialStatus, HTSRole.Roles role, TStatus.Enum finalStatus) {
        for (int i = 0; i < initialStatus.length; ++i) {
            this.addMapping(initialStatus[i], role, finalStatus);
        }
    }

    public TStatus.Enum getFinalStatus(TStatus.Enum initialStatus, HTSRole.Roles[] roles, HTSTask task) {
        TStatus.Enum finalStatus = null;
        finalStatus = this.statusMap.getEntry(roles, initialStatus);
        return finalStatus;
    }

    public boolean checkInitialStatus(TStatus.Enum initialStatus, HTSRole.Roles[] userRoles) {
        boolean goodStatus = false;
        goodStatus = this.statusMap.hasEntry(userRoles, initialStatus);
        return goodStatus;
    }

    private class RoleStatusMap {
        private Map<HTSRole.Roles, Map<TStatus.Enum, TStatus.Enum>> state_mappings = new HashMap<HTSRole.Roles, Map<TStatus.Enum, TStatus.Enum>>();

        private RoleStatusMap() {
        }

        public void addEntry(HTSRole.Roles role, TStatus.Enum status, TStatus.Enum finalstatus) {
            this.getRoleMap(role, true).put(status, finalstatus);
        }

        public boolean hasEntry(HTSRole.Roles[] roles, TStatus.Enum status) {
            boolean has = false;
            for (int i = 0; i < roles.length && !has; ++i) {
                has = has || this.hasEntry(roles[i], status);
            }
            return has;
        }

        public boolean hasEntry(HTSRole.Roles role, TStatus.Enum status) {
            return this.getRoleMap(role, false).containsKey(status);
        }

        public TStatus.Enum getEntry(HTSRole.Roles[] roles, TStatus.Enum status) {
            TStatus.Enum returnStatus = null;
            for (int i = 0; i < roles.length && returnStatus == null; ++i) {
                returnStatus = this.getRoleMap(roles[i], false).get(status);
            }
            return returnStatus;
        }

        public TStatus.Enum getEntry(HTSRole.Roles role, TStatus.Enum status) {
            TStatus.Enum returnStatus = null;
            returnStatus = this.getRoleMap(role, false).get(status);
            return returnStatus;
        }

        private Map<TStatus.Enum, TStatus.Enum> getRoleMap(HTSRole.Roles role, boolean add) {
            Map<TStatus.Enum, TStatus.Enum> map = this.state_mappings.get((Object)role);
            if (!add && map == null) {
                map = this.state_mappings.get((Object)HTSRole.Roles.ANY);
            }
            if (add && map == null) {
                map = new HashMap<TStatus.Enum, TStatus.Enum>();
                this.state_mappings.put(role, map);
            }
            if (map == null) {
                map = Collections.EMPTY_MAP;
            }
            return map;
        }
    }
}

