/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util;

import com.cognos.developer.schemas.bibus._3.BaseHistoryDetail;
import com.cognos.developer.schemas.bibus._3.DateTimeProp;
import com.cognos.developer.schemas.bibus._3.HistoryDetail;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.SeverityEnumProp;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.jms.client.BiBusMonitorUtil;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayer;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.util.TimeUtils;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.BiBusNotifier;
import com.ibm.cognos.internal.hts.util.Utils;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class BiBusNotifierFactory {
    private static BiBusNotifier notifier = new BiBusNotifierImpl();

    public static void setInstance(BiBusNotifier aNotifier) {
        notifier = aNotifier;
    }

    public static BiBusNotifier getInstance() {
        return notifier;
    }

    private static class BiBusNotifierImpl
    implements BiBusNotifier {
        private BiBusNotifierImpl() {
        }

        @Override
        public void callMonitorServiceNotify(String passport, String credentialPath, String eventID, int eventID_index, String status) throws HumanTaskServiceException {
            try {
                BiBusMonitorUtil.callMonitorServiceNotify((String)passport, (String)credentialPath, (String)eventID, (int)eventID_index, (String)status);
            }
            catch (SDKClientException e) {
                Utils.throwHumanTaskServiceException(e, UsI18NCode.MSG_US_CANNOT_COMPLETE, new Object[]{eventID, e.getMessage()});
            }
            catch (EMFSecurityException e) {
                Utils.throwHumanTaskServiceException(e, UsI18NCode.MSG_US_CANNOT_COMPLETE, new Object[]{eventID, e.getMessage()});
            }
        }

        @Override
        public void callMonitorServiceAddErrorMsg(String message, String eventID) throws HumanTaskServiceException {
            try {
                BiBusMonitorUtil.callMonitorServiceAddErrorMsg((String)message, (String)eventID);
            }
            catch (TaskPersistLayerException e) {
                Utils.throwHumanTaskServiceException(e, UsI18NCode.MSG_US_CANNOT_COMPLETE, new Object[]{eventID, e.getMessage()});
            }
        }

        @Override
        public void callMonitorServiceAddMsg(String credentialPath, String locale, I18NCode msg, String eventID, SeverityEnum code) throws HumanTaskServiceException {
            try {
                BiBusMonitorUtil.callMonitorServiceAddMsg((String)credentialPath, (String)locale, (I18NCode)msg, (String)eventID, (SeverityEnum)code);
            }
            catch (TaskPersistLayerException e) {
                Utils.throwHumanTaskServiceException(e, UsI18NCode.MSG_US_CANNOT_COMPLETE, new Object[]{eventID, e.getMessage()});
            }
        }

        @Override
        public void addHistoryDetail(String eventID, I18NCode msg, Locale locale, SeverityEnum code, Object[] params) throws HumanTaskServiceException {
            try {
                TaskID taskID = TaskID.fromEventId((String)eventID);
                String theMsg = I18NUtil.getMessage((I18NCode)msg, (Object[])params, (Locale)locale);
                HistoryDetail historyDetail = BiBusNotifierImpl.createHistoryDetails(theMsg, code);
                TaskPersistLayer.getInstance().addTaskDetails(taskID, new BaseHistoryDetail[]{historyDetail});
            }
            catch (TaskPersistLayerException e) {
                Utils.throwHumanTaskServiceException(e);
            }
        }

        private static HistoryDetail createHistoryDetails(String msg, SeverityEnum code) {
            HistoryDetail historyDetail = new HistoryDetail();
            DateTimeProp detailTimeProp = new DateTimeProp();
            Calendar now = TimeUtils.dateToUTCJavaCalendar((Date)new Date());
            detailTimeProp.setValue(now);
            historyDetail.setDetailTime(detailTimeProp);
            StringProp stringProp = new StringProp();
            stringProp.setValue(msg);
            historyDetail.setDetail(stringProp);
            SeverityEnumProp sevProp = new SeverityEnumProp();
            sevProp.setValue(code);
            historyDetail.setSeverity(sevProp);
            return historyDetail;
        }
    }
}

