/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util;

import com.cognos.jsmcommon.util.XMLUtils;
import com.ibm.cognos.internal.hts.properties.HTSServerProperties;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HTMLContentValidator {
    private static final String HTML_ALLOWED_TAGS_PROP = "html.description.allowedTags";
    private static final Pattern HTML_PATTERN = Pattern.compile("</?(\\w+)(((\\s+|/)\\w+(\\s*=\\s*(?:\".*?\"|'.*?'|[^'\">\\s]+))?)+\\s*|\\s*)/?>", 2);
    private static final Pattern ONX_PATTERN = Pattern.compile("<[^>]+\\b(on\\w+\\s*=).*>", 2);
    private static final Set<String> allowedTags = new HashSet<String>();

    private String checkTags(String html) {
        String validationMessage = null;
        Matcher tagMatcher = HTML_PATTERN.matcher(html);
        HashSet<String> tags = new HashSet<String>();
        int gcount = tagMatcher.groupCount();
        while (tagMatcher.find() && gcount > 0) {
            String tag = tagMatcher.group(1);
            if (tag == null) continue;
            tags.add(tag.toLowerCase());
        }
        tags.removeAll(allowedTags);
        if (tags.size() > 0) {
            validationMessage = this.stringify(tags);
        }
        return validationMessage;
    }

    private String checkEvents(String html) {
        Matcher onXMatcher = ONX_PATTERN.matcher(html);
        StringBuffer badBits = new StringBuffer();
        while (onXMatcher.find()) {
            badBits.append(onXMatcher.group(1));
        }
        return badBits.length() > 0 ? badBits.toString() : null;
    }

    private String stringify(Set<String> tags) {
        StringBuffer tagString = null;
        for (String tag : tags) {
            if (tag == null || tag.equals("null")) continue;
            if (tagString == null) {
                tagString = new StringBuffer();
            } else {
                tagString.append(",");
            }
            tagString.append(tag);
        }
        return tagString.toString();
    }

    public String getValidationError(String html) {
        String validationMessage = this.checkTags(XMLUtils.unEscape((String)html));
        if (validationMessage == null) {
            validationMessage = this.checkEvents(html);
        }
        return validationMessage;
    }

    static {
        String allowedTagsProperty = HTSServerProperties.getInstance().getProperty(HTML_ALLOWED_TAGS_PROP);
        StringTokenizer tagTokenizer = new StringTokenizer(allowedTagsProperty, ",");
        while (tagTokenizer.hasMoreTokens()) {
            allowedTags.add(tagTokenizer.nextToken().trim());
        }
    }
}

