/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.serverinst.InstanceUtil;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.ITransactionHandler;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.OpenJPAUtil;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.PersistenceUnit;
import com.ibm.cognos.internal.hts.properties.HTSServerProperties;
import com.ibm.cognos.internal.hts.schema.PluginPropertySchemaVersionUpdateFactory;
import com.ibm.cognos.internal.hts.schema.SchemaUtil;
import com.ibm.cognos.internal.hts.schema.VersionUpdate;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;

public class HTSDBUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOrUpgradeHTSSchema() {
        JDBCConfigurationImpl conf = null;
        ITransactionHandler trx = null;
        try {
            OpenJPAUtil.initialise();
            String versionStr = HTSServerProperties.getInstance().getProperty("humanTaskService.version");
            int version = 1;
            if (versionStr != null) {
                version = Integer.valueOf(versionStr);
            }
            VersionUpdate versionUpdater = new VersionUpdate();
            conf = null;
            trx = new OpenJPAUtil(PersistenceUnit.HUMANTASK_SERVICE);
            trx.openSession();
            AbstractContext.setCurrentTransactionHandler(trx);
            conf = OpenJPAUtil.createConfig();
            PluginPropertySchemaVersionUpdateFactory updateFactory = new PluginPropertySchemaVersionUpdateFactory(OpenJPAUtil.getNamedEntityManagerFactory(PersistenceUnit.HUMANTASK_SERVICE), PersistenceUnit.HUMANTASK_SERVICE);
            SchemaUtil util = new SchemaUtil(versionUpdater, updateFactory, conf);
            util.update(version, PersistenceUnit.HUMANTASK_SERVICE);
        }
        catch (HumanTaskServiceException ex) {
            Utils.logException((Throwable)((Object)ex));
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug("HTSDBUtils : There was a problem during HTS schema create / upgrade on dispatcher with id: " + InstanceUtil.getLocalDispatcherNodeIDGuid());
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, (I18NCode)UsI18NCode.MSG_US_SCHEMA_UPDATE_FAILED, new Object[]{ex.getMessage()});
        }
        catch (Exception ex) {
            Utils.logException(ex);
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).debug("HTSDBUtils : There was a problem during HTS schema create / upgrade on dispatcher with id: " + InstanceUtil.getLocalDispatcherNodeIDGuid());
            SDSLogger.getLogger((SDSCategory)JSMCommonCategory.TRACE).log(SDSLevel.ERROR, (I18NCode)UsI18NCode.MSG_US_SCHEMA_UPDATE_FAILED, new Object[]{ex.getMessage()});
        }
        finally {
            if (conf != null) {
                conf.close();
            }
            if (trx != null) {
                trx.closeSession();
            }
            AbstractContext.setCurrentTransactionHandler(null);
        }
    }
}

