/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util;

import com.ibm.cognos.internal.hts._1.BeplNotificationDocument;
import com.ibm.cognos.internal.hts._1.BeplTaskDocument;
import com.ibm.cognos.internal.hts._1.ManualTaskDocument;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskClassProperty;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.service.ws_ht.HumanTaskServiceHandler;
import com.ibm.cognos.internal.hts.status.Operation;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.dao.TaskClassPropertyUtil;
import com.ibm.cognos.internal.hts.ws_ht.OrganizationalEntityDocument;
import com.ibm.cognos.internal.hts.ws_ht.TDeadlines;
import com.ibm.cognos.internal.hts.ws_ht.TLiteral;
import com.ibm.cognos.internal.hts.ws_ht.TTask;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.DeadlineInstanceList;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.DeadlinesDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.NotificationDeadlinesDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.NotificationDeadlinesImpl;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.ParentTaskDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.PropertiesDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.PurgeConstraintsDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.PurgeConstraintsImpl;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.StateChangesDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.StateChangesImpl;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.TProperties;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class HTSSDKUtils {
    private static final String CAPABILITIES = "capabilities";

    public static XmlObject unMarshallElement(Element opElement) throws Exception {
        StringReader reader = new StringReader(opElement.asXML());
        XmlObject xobj = XmlObject.Factory.parse((Reader)reader);
        return xobj;
    }

    public static String marshallAPIObjectToString(Object apiObject) throws Exception {
        return apiObject.toString();
    }

    public static Element marshallAPIObjectToElement(Object apiRequest) throws Exception {
        Element result = null;
        String element = HTSSDKUtils.marshallAPIObjectToString(apiRequest);
        if (element != null && element.length() > 0) {
            try {
                Document document = DocumentHelper.parseText((String)element);
                result = document.getRootElement();
            }
            catch (DocumentException e) {
                throw new Exception("Error parsing result.", e);
            }
        }
        return result;
    }

    public static XmlAnySimpleType createTask(String taskType, BeplTaskDocument beplTask, ManualTaskDocument manualTask) throws HumanTaskServiceException {
        XmlCursor beplTaskCursor = beplTask.newCursor();
        XmlCursor manualTaskCursor = manualTask.newCursor();
        beplTaskCursor.toFirstChild();
        manualTaskCursor.toFirstChild();
        XmlAnySimpleType task = HTSSDKUtils.createNode(taskType, beplTaskCursor.xmlText() + manualTaskCursor.xmlText());
        beplTaskCursor.dispose();
        manualTaskCursor.dispose();
        return task;
    }

    public static XmlAnySimpleType createNotificationTask(BeplNotificationDocument beplNotification, ManualTaskDocument manualTask) throws HumanTaskServiceException {
        XmlCursor beplNotificationCursor = beplNotification.newCursor();
        XmlCursor manualTaskCursor = manualTask.newCursor();
        beplNotificationCursor.toFirstChild();
        manualTaskCursor.toFirstChild();
        XmlAnySimpleType notificationTask = HTSSDKUtils.createNode("createNotificationManualTask", beplNotificationCursor.xmlText() + manualTaskCursor.xmlText());
        beplNotificationCursor.dispose();
        manualTaskCursor.dispose();
        return notificationTask;
    }

    public static OrganizationalEntityDocument getOrganizationalEntity(TLiteral literal) throws HumanTaskServiceException {
        OrganizationalEntityDocument oed = null;
        XmlCursor cursor = literal.newCursor();
        if (HTSSDKUtils.searchForElement(cursor, "organizationalEntity")) {
            try {
                oed = OrganizationalEntityDocument.Factory.parse((Reader)cursor.newReader());
            }
            catch (Exception ex) {
                Utils.throwHumanTaskServiceException(ex);
            }
        } else {
            oed = OrganizationalEntityDocument.Factory.newInstance();
            oed.addNewOrganizationalEntity();
        }
        return oed;
    }

    public static String getXML(XmlObject xmlObject) {
        XmlOptions options = new XmlOptions();
        options.setLoadStripWhitespace();
        options.setLoadTrimTextBuffer();
        String text = xmlObject.xmlText(options);
        return text;
    }

    public static String getMixedContent(XmlObject xmlObject) {
        StringBuffer text = new StringBuffer();
        XmlCursor cursor = null;
        try {
            cursor = xmlObject.newCursor();
            if (cursor.currentTokenType() == XmlCursor.TokenType.STARTDOC) {
                cursor.toFirstChild();
            }
            if (cursor.toFirstContentToken() != XmlCursor.TokenType.NONE) {
                do {
                    if (cursor.currentTokenType() == XmlCursor.TokenType.TEXT) {
                        text.append(cursor.getChars());
                        continue;
                    }
                    if (cursor.currentTokenType() != XmlCursor.TokenType.START) continue;
                    text.append(cursor.xmlText());
                    cursor.toEndToken();
                } while (cursor.toNextToken() != XmlCursor.TokenType.END);
            }
        }
        finally {
            if (cursor != null) {
                cursor.dispose();
            }
        }
        return text.toString();
    }

    public static String getText(XmlObject xmlObject) {
        StringBuffer text = new StringBuffer();
        XmlCursor cursor = null;
        try {
            cursor = xmlObject.newCursor();
            text = HTSSDKUtils.getText(cursor);
        }
        finally {
            if (cursor != null) {
                cursor.dispose();
            }
        }
        return text.toString();
    }

    public static StringBuffer getText(XmlCursor cursor) {
        StringBuffer text = new StringBuffer();
        XmlCursor.TokenType tt = cursor.toFirstContentToken();
        while (tt.isText()) {
            if (cursor.isText()) {
                text.append(cursor.getChars());
            }
            tt = cursor.toNextToken();
        }
        return text;
    }

    public static XmlObject setText(String text) {
        XmlObject xmlObj = XmlObject.Factory.newInstance();
        XmlCursor cursor = xmlObj.newCursor();
        cursor.toFirstContentToken();
        cursor.insertChars(text);
        cursor.dispose();
        return xmlObj;
    }

    public static String makeFault(UsI18NCode code, Object[] params) {
        HumanTaskServiceException use = new HumanTaskServiceException(code, params);
        return HumanTaskServiceHandler.buildFaultElement((Throwable)((Object)use)).asXML();
    }

    public static void setStateChanges(TTask task, StateChangesDocument stateChangesDoc) {
        HTSSDKUtils.appendXMLBean((XmlObject)task, (XmlObject)stateChangesDoc);
    }

    public static void setDeadlines(XmlObject task, DeadlinesDocument deadlinesDoc) {
        DeadlineInstanceList deadlines = deadlinesDoc.getDeadlines();
        HTSSDKUtils.appendXMLBean("task", task, (XmlObject)deadlines);
    }

    public static void setTaskRead(XmlObject task, boolean taskRead) throws HumanTaskServiceException {
        HTSSDKUtils.setCustomXML(task, "taskRead", taskRead);
    }

    public static void setDueDate(XmlObject task, String dueDate) throws HumanTaskServiceException {
        HTSSDKUtils.setCustomXML(task, "dueDate", dueDate == null ? "" : dueDate);
    }

    public static void setTaskClassProperties(XmlObject task, List<HTSTaskClassProperty> properties) throws HumanTaskServiceException {
        TaskClassPropertyUtil util = new TaskClassPropertyUtil(properties);
        HTSSDKUtils.appendXMLBean(task, (XmlObject)util.getPropertiesDoc());
    }

    public static void setRolesForTask(XmlObject task, List<HTSRole.Roles> roles) throws HumanTaskServiceException {
        XmlObject xmlRoles = XmlObject.Factory.newInstance();
        XmlCursor cursor = xmlRoles.newCursor();
        cursor.toNextToken();
        cursor.beginElement(new QName("roles"));
        for (HTSRole.Roles role : roles) {
            cursor.insertElementWithText("role", role.getRole());
        }
        cursor.dispose();
        HTSSDKUtils.appendXMLBean(task, xmlRoles);
    }

    public static List<HTSRole.Roles> getRolesForTask(XmlObject task) throws HumanTaskServiceException {
        XmlCursor cursor = task.newCursor();
        ArrayList<HTSRole.Roles> roles = new ArrayList<HTSRole.Roles>();
        if (HTSSDKUtils.searchForElement(cursor, "roles")) {
            while (HTSSDKUtils.searchForElement(cursor, "role")) {
                String roleString = cursor.getTextValue();
                HTSRole.Roles role = HTSRole.Roles.findRole(roleString);
                if (role == null) continue;
                roles.add(role);
            }
        }
        return roles;
    }

    public static void setTaskReadLevelForCurrentUser(XmlObject task, String taskReadLevel) {
        XmlObject xmlTaskReadLevel = XmlObject.Factory.newInstance();
        XmlCursor cursor = xmlTaskReadLevel.newCursor();
        cursor.toNextToken();
        cursor.insertElementWithText("taskReadLevelForCurrentUser", taskReadLevel);
        cursor.dispose();
        HTSSDKUtils.appendXMLBean(task, xmlTaskReadLevel);
    }

    public static Element setValidMethods(Element element, Map<String, Boolean> methodMap) throws HumanTaskServiceException {
        Iterator<String> methods = methodMap.keySet().iterator();
        Element capabilities = element.addElement(CAPABILITIES);
        while (methods.hasNext()) {
            String method = methods.next();
            capabilities.addElement(method).setText(methodMap.get(method).toString());
        }
        return element;
    }

    public static Element buildMenus(Element element, Map<String, Operation> operations) {
        Element menus = element.addElement("menus");
        for (Map.Entry<String, Operation> operation : operations.entrySet()) {
            String opName = operation.getValue().getOperationName();
            String targetStatus = operation.getKey();
            if (opName == null || targetStatus == null) continue;
            Element menu = menus.addElement("menu");
            menu.addElement("targetStatus").setText(targetStatus);
            menu.addElement("operation").setText(opName);
        }
        return element;
    }

    public static void setTaskIconPath(XmlObject task, String taskIconPath) throws HumanTaskServiceException {
        HTSSDKUtils.setCustomXML(task, "taskIconPath", taskIconPath);
    }

    public static void setCustomXML(XmlObject insertee, XmlObject insertion) throws HumanTaskServiceException {
        XmlCursor xObjcursor = insertee.newCursor();
        xObjcursor.toFirstChild();
        xObjcursor.toFirstContentToken();
        insertion.newCursor().copyXmlContents(xObjcursor);
    }

    public static void setCustomXML(XmlObject xObj, String elementName, Object value) throws HumanTaskServiceException {
        XmlCursor xObjcursor = xObj.newCursor();
        xObjcursor.toEndToken();
        if (value == null) {
            value = "";
        }
        xObjcursor.insertElementWithText(new QName(elementName), String.valueOf(value));
    }

    public static void setCustomXML(XmlObject xObj, String namespace, String elementName, Object value) throws HumanTaskServiceException {
        XmlCursor xObjcursor = xObj.newCursor();
        xObjcursor.toEndToken();
        if (value == null) {
            value = "";
        }
        xObjcursor.insertElementWithText(new QName(namespace, elementName), String.valueOf(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<XmlObject> getOperations(XmlObject object, String[] operationNames) {
        ArrayList<XmlObject> ops = new ArrayList<XmlObject>();
        for (int i = 0; i < operationNames.length; ++i) {
            XmlCursor cursor = null;
            try {
                cursor = object.newCursor();
                while (HTSSDKUtils.searchForElement(cursor, operationNames[i])) {
                    XmlObject obj = cursor.getObject();
                    if (obj == null) continue;
                    ops.add(obj);
                }
                continue;
            }
            finally {
                if (cursor != null) {
                    cursor.dispose();
                }
            }
        }
        return ops;
    }

    public static StateChangesDocument getStateChanges(XmlObject stateChangeParent) throws HumanTaskServiceException {
        StateChangesDocument scDoc = null;
        XmlCursor cursor = stateChangeParent.newCursor();
        HTSSDKUtils.searchForElement(cursor, "stateChanges");
        try {
            if (cursor.getObject() instanceof StateChangesImpl) {
                scDoc = StateChangesDocument.Factory.parse((InputStream)cursor.newInputStream());
            }
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e);
        }
        cursor.dispose();
        return scDoc;
    }

    public static PurgeConstraintsDocument getPurgeConstraint(XmlObject purgeConstraintParent) throws HumanTaskServiceException {
        PurgeConstraintsDocument scDoc = null;
        XmlCursor cursor = purgeConstraintParent.newCursor();
        HTSSDKUtils.searchForElement(cursor, "purgeConstraints");
        try {
            if (cursor.getObject() instanceof PurgeConstraintsImpl) {
                scDoc = PurgeConstraintsDocument.Factory.parse((InputStream)cursor.newInputStream());
            }
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e);
        }
        cursor.dispose();
        return scDoc;
    }

    public static ParentTaskDocument getParentFolder(XmlObject object) throws HumanTaskServiceException {
        ParentTaskDocument scDoc = null;
        XmlCursor cursor = object.newCursor();
        HTSSDKUtils.searchForElement(cursor, "parentTask");
        try {
            if (cursor.getObject() instanceof ParentTaskDocument.ParentTask) {
                scDoc = ParentTaskDocument.Factory.parse((InputStream)cursor.newInputStream());
            }
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e);
        }
        cursor.dispose();
        return scDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TDeadlines getNotificationDeadlines(XmlObject deadlinesParent) throws HumanTaskServiceException {
        TDeadlines tDeadlines = null;
        NotificationDeadlinesDocument nDoc = null;
        NotificationDeadlinesImpl nDocImpl = null;
        XmlCursor cursor = null;
        try {
            cursor = deadlinesParent.newCursor();
            if (cursor != null) {
                HTSSDKUtils.searchForElement(cursor, "notificationDeadlines");
                if (cursor.getObject() instanceof NotificationDeadlinesImpl && (nDoc = NotificationDeadlinesDocument.Factory.parse((InputStream)cursor.newInputStream())) != null && (nDocImpl = nDoc.getNotificationDeadlines()) != null) {
                    tDeadlines = nDocImpl.getNDeadlines();
                }
            }
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e);
        }
        finally {
            if (cursor != null) {
                cursor.dispose();
            }
        }
        return tDeadlines;
    }

    public static String getRenderingUri(XmlObject rendering) throws HumanTaskServiceException {
        return HTSSDKUtils.getText(rendering, "uri");
    }

    public static String getRenderingValue(XmlObject rendering) throws HumanTaskServiceException {
        String value = null;
        XmlCursor cursor = rendering.newCursor();
        if (cursor.toFirstChild()) {
            XmlOptions opts = new XmlOptions();
            opts.setSaveOuter();
            if (cursor != null) {
                value = cursor.getObject().xmlText(opts);
            }
        }
        return value == null ? value : value.toString();
    }

    public static String getText(XmlObject object, String elementName) throws HumanTaskServiceException {
        String text = null;
        XmlCursor cursor = object.newCursor();
        if (HTSSDKUtils.searchForElement(cursor, elementName) && cursor.getObject() != null) {
            text = HTSSDKUtils.getText(cursor.getObject());
        }
        return "".equals(text) ? null : text;
    }

    public static String getTextOfChild(XmlObject object, String elementName) throws HumanTaskServiceException {
        String text = null;
        XmlCursor cursor = object.newCursor();
        cursor.toNextToken();
        if (HTSSDKUtils.searchSiblingsForElement(cursor, elementName) && cursor.getObject() != null) {
            text = HTSSDKUtils.getText(cursor.getObject());
        }
        return "".equals(text) ? null : text;
    }

    public static PropertiesDocument getTaskClassProperties(XmlObject task) throws HumanTaskServiceException {
        TProperties propsImpl = null;
        XmlCursor cursor = task.newCursor();
        HTSSDKUtils.searchForElement(cursor, "properties");
        try {
            if (cursor.getObject() instanceof TProperties) {
                propsImpl = (TProperties)cursor.getObject();
            }
        }
        catch (Throwable t) {
            Utils.logException(t);
        }
        cursor.dispose();
        if (propsImpl == null) {
            PropertiesDocument propsDoc = PropertiesDocument.Factory.newInstance();
            propsDoc.addNewProperties();
            propsImpl = propsDoc.addNewProperties();
        }
        PropertiesDocument doc = PropertiesDocument.Factory.newInstance();
        doc.setProperties(propsImpl);
        return doc;
    }

    public static String getTaskIconPath(XmlObject task) throws HumanTaskServiceException {
        return HTSSDKUtils.getText(task, "taskIconPath");
    }

    public static String getTaskclassVersionId(XmlObject task) throws HumanTaskServiceException {
        return HTSSDKUtils.getText(task, "versionId");
    }

    public static void setTaskclassVersionId(XmlObject task, String versionId) throws HumanTaskServiceException {
        HTSSDKUtils.setCustomXML(task, "versionId", versionId);
    }

    public static boolean getTaskRead(XmlObject taskAbstract) throws HumanTaskServiceException {
        boolean read = false;
        XmlCursor cursor = taskAbstract.selectPath("./taskRead")[0].newCursor();
        read = Boolean.valueOf(cursor.getTextValue());
        return read;
    }

    public static String getTaskSubscriptions(XmlObject task, String elementName) throws HumanTaskServiceException {
        return HTSSDKUtils.getText(task, elementName);
    }

    public static void appendXMLBean(XmlObject task, XmlObject xmlObject) {
        XmlCursor xmlObjCursor = xmlObject.newCursor();
        XmlCursor cursor = task.newCursor();
        xmlObjCursor.toFirstChild();
        cursor.toEndToken();
        xmlObjCursor.moveXml(cursor);
        cursor.dispose();
        xmlObjCursor.dispose();
    }

    public static XmlObject getXmlObject(XmlObject object, String elementName) {
        XmlObject xmlObject = null;
        XmlCursor cursor = object.newCursor();
        if (HTSSDKUtils.searchForElement(cursor, elementName) && cursor.getObject() != null) {
            xmlObject = cursor.getObject();
        }
        return xmlObject;
    }

    public static XmlObject getXmlObjectChild(XmlObject object, String elementName) {
        XmlObject xmlObject = null;
        XmlCursor cursor = object.newCursor();
        cursor.toNextToken();
        if (HTSSDKUtils.searchSiblingsForElement(cursor, elementName) && cursor.getObject() != null) {
            xmlObject = cursor.getObject();
        }
        return xmlObject;
    }

    private static XmlAnySimpleType createNode(String elementName, Object value) throws HumanTaskServiceException {
        XmlAnySimpleType xast = null;
        try {
            xast = XmlAnySimpleType.Factory.parse((String)("<" + elementName + ">" + String.valueOf(value) + "</" + elementName + ">"));
        }
        catch (XmlException e) {
            Utils.throwHumanTaskServiceException(e);
        }
        return xast;
    }

    private static void appendXMLBean(String elementName, XmlObject task, XmlObject xmlObject) {
        XmlCursor xmlObjCursor = xmlObject.newCursor();
        XmlCursor cursor = task.newCursor();
        cursor.toStartDoc();
        HTSSDKUtils.searchForElement(cursor, elementName);
        cursor.toEndToken();
        xmlObjCursor.moveXml(cursor);
        cursor.dispose();
        xmlObjCursor.dispose();
    }

    private static boolean searchForElement(XmlCursor cursor, String name) {
        boolean found = false;
        while (!cursor.toNextToken().isNone() && !found) {
            if (cursor.currentTokenType().intValue() != 3 || !cursor.getName().getLocalPart().equals(name)) continue;
            found = true;
            break;
        }
        return found;
    }

    private static boolean searchSiblingsForElement(XmlCursor cursor, String name) {
        boolean found = false;
        while (cursor.toNextSibling() && !found) {
            if (cursor.currentTokenType().intValue() != 3 || !cursor.getName().getLocalPart().equals(name)) continue;
            found = true;
            break;
        }
        return found;
    }
}

