/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.jsmcommon.http.HTTPRequest;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.Headers;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logging.USCategory;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.BiBusHeaderUtilities;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.xmlbeans.XmlObject;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class HTSServiceCaller {
    private String soapAction = "http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1";
    private String dispUrl;

    public HTSServiceCaller(String dispatcherUrl) {
        this.dispUrl = dispatcherUrl;
    }

    public Node invoke(BiBusHeader biBusHeader, XmlObject body) throws Exception {
        HTTPRequest request = new HTTPRequest(this.soapAction, this.dispUrl);
        Element bodyNode = null;
        try {
            Headers headers = new Headers(biBusHeader);
            BIBusEnvelope biBusEnvelope = BiBusHeaderUtilities.getHeadedEnvelope(headers);
            biBusEnvelope.getBody().add(HTSSDKUtils.marshallAPIObjectToElement(body));
            StringWriter aWriter = this.getRequest(biBusEnvelope);
            request.setRequestBody(aWriter.toString());
            String response = request.retrieveContent();
            BIBusEnvelope responseEnvelope = null;
            responseEnvelope = new BIBusEnvelope((Reader)new StringReader(response));
            if (responseEnvelope.getFaultString() != null) {
                SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug(responseEnvelope.toString());
                throw new HumanTaskServiceException(UsI18NCode.MSG_US_GENERAL_ERROR, new Object[]{responseEnvelope});
            }
            bodyNode = responseEnvelope.getBody();
            if (bodyNode != null) {
                bodyNode = bodyNode.selectSingleNode("./*[1]");
            }
        }
        catch (Throwable e) {
            throw new Exception("hts caller failed with URL " + request.getURL(), e);
        }
        return bodyNode;
    }

    private StringWriter getRequest(BIBusEnvelope biBusEnvelope) throws IOException {
        StringWriter aWriter = new StringWriter();
        OutputFormat format = new OutputFormat();
        format.setNewLineAfterDeclaration(false);
        XMLWriter xmlWriter = new XMLWriter((Writer)aWriter, format);
        xmlWriter.write(biBusEnvelope.getAsDocument());
        xmlWriter.flush();
        return aWriter;
    }
}

