/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.ibm.cognos.internal.hts.persist.dao.openjpa.GetTasksWhereClause;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSFolder;
import com.ibm.cognos.internal.hts.util.HTSServiceCaller;
import com.ibm.cognos.internal.hts.util.TimeUtils;
import com.ibm.cognos.internal.hts.ws_ht.api.TTaskQueryResultRow;
import com.ibm.cognos.internal.hts.ws_ht.api.TTaskQueryResultSet;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.CompleteNotificationDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.DeadlineInstance;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.DeadlineInstanceList;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.DeadlineType;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.GetPerfDataDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.StartPerfDataCollectionDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.UpdateTaskDetailsDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.ClaimDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.CompleteDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.GetInputDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.GetInputResponseDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.QueryDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.QueryResponseDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.ReleaseDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.StartDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.xsd.StopDocument;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class HtsUtils {
    private HTSServiceCaller htsCaller;

    public HtsUtils(String dispatcherUrl) {
        this.htsCaller = new HTSServiceCaller(dispatcherUrl);
    }

    public TTaskQueryResultRow[] filteredQuery(BiBusHeader header, String camId) throws Exception {
        QueryDocument queryDoc = QueryDocument.Factory.newInstance();
        QueryDocument.Query query = queryDoc.addNewQuery();
        StringBuffer buf = new StringBuffer();
        buf.append("Task.folderName");
        buf.append("=");
        buf.append((Object)HTSFolder.UI_FOLDERS.INBOX);
        buf.append(" AND ");
        buf.append("Task.folderUser");
        buf.append("=");
        buf.append(GetTasksWhereClause.encodeWhereClauseToken(camId));
        query.setWhereClause(buf.toString());
        Node result = this.htsCaller.invoke(header, (XmlObject)queryDoc);
        QueryResponseDocument response = QueryResponseDocument.Factory.parse((String)result.asXML());
        TTaskQueryResultSet rs = response.getQueryResponse().getQuery();
        return rs.getRowArray();
    }

    public String makeApproveAllOutputData(String id, BiBusHeader header) throws Exception {
        Node inputResponseNode = this.getInputMessage(id, header);
        GetInputResponseDocument inputResponse = GetInputResponseDocument.Factory.parse((String)inputResponseNode.asXML());
        SAXReader reader = new SAXReader();
        Document doc = reader.read((Reader)new StringReader(inputResponse.toString()));
        List nodes = doc.selectNodes("//tsePreview/agentPreview/*/*/@eventId");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<testOutput>");
        for (Node node : nodes) {
            buffer.append("<item status=\"accept\" ");
            buffer.append(" id=\"" + node.getText() + "\"");
            buffer.append("/>");
        }
        buffer.append("<outcome>");
        buffer.append("test success");
        buffer.append("</outcome>");
        buffer.append("</testOutput>");
        return buffer.toString();
    }

    public Node startCollectingPerfData(BiBusHeader header) throws Exception {
        StartPerfDataCollectionDocument start = StartPerfDataCollectionDocument.Factory.newInstance();
        start.addNewStartPerfDataCollection();
        return this.htsCaller.invoke(header, (XmlObject)start);
    }

    public Node getPerfData(BiBusHeader header) throws Exception {
        GetPerfDataDocument getPerf = GetPerfDataDocument.Factory.newInstance();
        getPerf.addNewGetPerfData();
        return this.htsCaller.invoke(header, (XmlObject)getPerf);
    }

    public Node getInputMessage(String taskId, BiBusHeader header) throws Exception {
        GetInputDocument claim = GetInputDocument.Factory.newInstance();
        claim.addNewGetInput();
        claim.getGetInput().setIdentifier(taskId);
        return this.htsCaller.invoke(header, (XmlObject)claim);
    }

    public Node claimTask(String taskId, BiBusHeader header) throws Exception {
        ClaimDocument claim = ClaimDocument.Factory.newInstance();
        claim.addNewClaim();
        claim.getClaim().setIdentifier(taskId);
        return this.htsCaller.invoke(header, (XmlObject)claim);
    }

    public Node releaseTask(String taskId, BiBusHeader header) throws Exception {
        ReleaseDocument release = ReleaseDocument.Factory.newInstance();
        release.addNewRelease();
        release.getRelease().setIdentifier(taskId);
        return this.htsCaller.invoke(header, (XmlObject)release);
    }

    public Node startTask(String taskId, BiBusHeader header) throws Exception {
        StartDocument start = StartDocument.Factory.newInstance();
        start.addNewStart();
        start.getStart().setIdentifier(taskId);
        return this.htsCaller.invoke(header, (XmlObject)start);
    }

    public Node stopTask(String taskId, BiBusHeader header) throws Exception {
        StopDocument stop = StopDocument.Factory.newInstance();
        stop.addNewStop();
        stop.getStop().setIdentifier(taskId);
        return this.htsCaller.invoke(header, (XmlObject)stop);
    }

    public Node completeTask(String taskId, BiBusHeader header) throws Exception {
        return this.completeTask(taskId, header, null);
    }

    public Node completeTask(String taskId, BiBusHeader header, String outputData) throws Exception {
        CompleteDocument complete = CompleteDocument.Factory.newInstance();
        complete.addNewComplete();
        complete.getComplete().setIdentifier(taskId);
        XmlObject data = complete.getComplete().addNewTaskData();
        if (outputData == null) {
            outputData = "<empty/>";
        }
        StringReader reader = new StringReader(outputData);
        XmlObject xobj = XmlObject.Factory.parse((Reader)reader);
        data.set(xobj);
        return this.htsCaller.invoke(header, (XmlObject)complete);
    }

    public Node updatePriority(String taskId, BiBusHeader header, String prio) throws Exception {
        UpdateTaskDetailsDocument update = UpdateTaskDetailsDocument.Factory.newInstance();
        update.addNewUpdateTaskDetails();
        update.getUpdateTaskDetails().setIdentifier(taskId);
        update.getUpdateTaskDetails().setPriority(new BigInteger(prio));
        return this.htsCaller.invoke(header, (XmlObject)update);
    }

    public Node updateDeadline(String taskId, BiBusHeader header, DeadlineType.Enum type, String date) throws Exception {
        UpdateTaskDetailsDocument update = UpdateTaskDetailsDocument.Factory.newInstance();
        update.addNewUpdateTaskDetails();
        update.getUpdateTaskDetails().setIdentifier(taskId);
        DeadlineInstanceList deadlines = update.getUpdateTaskDetails().addNewDeadlines();
        DeadlineInstance deadline = deadlines.addNewDeadlineInstance();
        Calendar cal = TimeUtils.getCalendar(date);
        TimeUtils.resetHours(cal);
        deadline.setDate(cal);
        deadline.setType(type);
        deadline.setNotify(true);
        return this.htsCaller.invoke(header, (XmlObject)update);
    }

    public Node completeNotification(String taskId, BiBusHeader header) throws Exception {
        CompleteNotificationDocument cnd = CompleteNotificationDocument.Factory.newInstance();
        cnd.addNewCompleteNotification();
        cnd.getCompleteNotification().setIdentifier(taskId);
        return this.htsCaller.invoke(header, (XmlObject)cnd);
    }
}

