/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.HTSConstants;
import com.ibm.cognos.internal.hts.util.Utils;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;

public class TimeUtils {
    public static long getDateLong(Calendar cal, long defaultValue) {
        if (cal == null) {
            return defaultValue;
        }
        return cal.getTime().getTime();
    }

    public static Date getDate(String xmlDate) throws HumanTaskServiceException {
        XMLGregorianCalendar cal = Utils.getDataTypeFactory().newXMLGregorianCalendar(xmlDate);
        return cal.toGregorianCalendar().getTime();
    }

    public static String getXsDate(GregorianCalendar cal) throws HumanTaskServiceException {
        XMLGregorianCalendar xcal = Utils.getDataTypeFactory().newXMLGregorianCalendar(cal);
        return xcal.toXMLFormat();
    }

    public static Calendar getCalendar(String dateStr) throws HumanTaskServiceException {
        Date xmlDate = TimeUtils.getDate(dateStr);
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(xmlDate);
        return cal;
    }

    public static void resetHours(Calendar cal) throws HumanTaskServiceException {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
    }

    public static Calendar getUTCCalendar(String dateStr) throws HumanTaskServiceException {
        Date xmlDate = TimeUtils.getDate(dateStr);
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.setTime(xmlDate);
        return cal;
    }

    public static Calendar toUTCCalendar(Long time) {
        if (time == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTimeInMillis(time);
        return cal;
    }

    public static Calendar toUserTZCalendar(Long time, IAbstractContext aContext) {
        BiBusHeader biBusHeader = null;
        Calendar userTZCalendar = null;
        try {
            if (time != null && time > 0L) {
                if (aContext != null) {
                    biBusHeader = aContext.getHeader().getBiBusHeader();
                }
                userTZCalendar = TimeUtils.toUserTZCalendar(time, biBusHeader);
            }
        }
        catch (Exception ex) {
            Utils.logException(ex);
        }
        return userTZCalendar;
    }

    public static Calendar toUserTZCalendar(Long time, BiBusHeader biBusHeader) {
        Calendar userTZCalendar = null;
        String userTimeZoneID = null;
        try {
            if (time != null && time > 0L) {
                if (biBusHeader != null) {
                    userTimeZoneID = BiBusUtilities.getUserPreferenceVar((BiBusHeader)biBusHeader, (String)HTSConstants.HTS_BIBUSHEADER_TIMEZONEID);
                }
                userTZCalendar = userTimeZoneID != null && !userTimeZoneID.trim().equals("") ? Calendar.getInstance(TimeZone.getTimeZone(userTimeZoneID)) : Calendar.getInstance();
                userTZCalendar.setTimeInMillis(time);
            }
        }
        catch (Exception ex) {
            Utils.logException(ex);
        }
        return userTZCalendar;
    }

    public static Calendar toUserTZCalendar(Long time, String timezone) {
        Calendar userTZCalendar = null;
        String userTimeZoneID = timezone;
        try {
            if (time != null && time > 0L) {
                userTZCalendar = userTimeZoneID != null && !userTimeZoneID.trim().equals("") ? Calendar.getInstance(TimeZone.getTimeZone(userTimeZoneID)) : Calendar.getInstance();
                userTZCalendar.setTimeInMillis(time);
            }
        }
        catch (Exception ex) {
            Utils.logException(ex);
        }
        return userTZCalendar;
    }

    public static String getUserTZFormattedTime(Long time, IAbstractContext aContext, Locale locale) {
        BiBusHeader biBusHeader = null;
        String userTZFormattedTime = "";
        try {
            if (aContext != null) {
                biBusHeader = aContext.getHeader().getBiBusHeader();
                userTZFormattedTime = TimeUtils.getUserTZFormattedTime(time, biBusHeader, locale);
            }
        }
        catch (Exception ex) {
            Utils.logException(ex);
        }
        return userTZFormattedTime;
    }

    public static String getUserTZFormattedTime(Long time, BiBusHeader biBusHeader, Locale locale) {
        String userTZFormattedTime = "";
        try {
            if (biBusHeader != null) {
                String timezoneString = BiBusUtilities.getUserPreferenceVar((BiBusHeader)biBusHeader, (String)HTSConstants.HTS_BIBUSHEADER_TIMEZONEID);
                userTZFormattedTime = TimeUtils.getUserTZFormattedTime(time, timezoneString, locale);
            }
        }
        catch (Exception ex) {
            Utils.logException(ex);
        }
        return userTZFormattedTime;
    }

    public static String getUserTZFormattedTime(Long time, String timeZone, Locale locale) {
        String userTZFormattedTime = "";
        Calendar userTZCalendar = null;
        DateFormat dateFormatter = null;
        try {
            if (time != null && time > 0L && timeZone != null && timeZone.length() > 0 && locale != null) {
                userTZCalendar = TimeUtils.toUserTZCalendar(time, timeZone);
                dateFormatter = DateFormat.getDateTimeInstance(2, 2, locale);
                dateFormatter.setTimeZone(userTZCalendar.getTimeZone());
                userTZFormattedTime = dateFormatter.format(userTZCalendar.getTime());
            }
        }
        catch (Exception ex) {
            Utils.logException(ex);
        }
        return userTZFormattedTime;
    }
}

