/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logging.USCategory;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;

public class Utils {
    private static boolean debug = false;
    private static final String XSRF_TOKEN = "XSRF-TOKEN";
    private static final String ACTION = "action";
    private static final String MONITORSERVICEREQUEST = "MonitorServiceRequest";
    private static DatatypeFactory dataTypeFactory;

    private Utils() {
    }

    public static DatatypeFactory getDataTypeFactory() throws HumanTaskServiceException {
        try {
            if (dataTypeFactory == null) {
                dataTypeFactory = DatatypeFactory.newInstance();
            }
        }
        catch (DatatypeConfigurationException e) {
            Utils.throwHumanTaskServiceException(e);
        }
        return dataTypeFactory;
    }

    public static boolean equals(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        return object1.equals(object2);
    }

    public static void throwHumanTaskServiceException(Throwable t) throws HumanTaskServiceException {
        Utils.throwHumanTaskServiceException(t, null, new Object[0]);
    }

    public static void throwHumanTaskServiceException(UsI18NCode code, Object[] params) throws HumanTaskServiceException {
        Utils.throwHumanTaskServiceException(null, code, params);
    }

    public static void throwHumanTaskServiceException(Throwable t, UsI18NCode code) throws HumanTaskServiceException {
        Utils.throwHumanTaskServiceException(t, code, new Object[0]);
    }

    public static HumanTaskServiceException makeHumanTaskServiceException(Throwable t) {
        HumanTaskServiceException ut = null;
        ut = t instanceof HumanTaskServiceException ? (HumanTaskServiceException)((Object)t) : (t instanceof LocalizableException ? new HumanTaskServiceException((LocalizableException)t) : new HumanTaskServiceException(UsI18NCode.MSG_US_GENERAL_ERROR, new Object[]{t.getMessage()}, t));
        return ut;
    }

    public static void throwHumanTaskServiceException(Throwable t, UsI18NCode code, Object[] params) throws HumanTaskServiceException {
        if (params == null) {
            params = new Object[]{};
        }
        if (code == null) {
            code = UsI18NCode.MSG_US_GENERAL_ERROR;
        }
        SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).log(SDSLevel.ERROR, (I18NCode)code, params);
        if (t == null) {
            t = new HumanTaskServiceException(code, params);
        }
        SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug((Throwable)t);
        if (debug) {
            ((Throwable)t).printStackTrace();
        }
        if (t instanceof HumanTaskServiceException) {
            HumanTaskServiceException ut = (HumanTaskServiceException)((Object)t);
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).log(SDSLevel.ERROR, ut.getI18NCode(), ut.getParams());
            throw ut;
        }
        if (t instanceof LocalizableException) {
            LocalizableException lt = (LocalizableException)t;
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).log(SDSLevel.ERROR, lt.getI18NCode(), lt.getParams());
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_GENERAL_ERROR, new Object[]{((Throwable)t).getMessage()}, (Throwable)t);
        }
        SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).log(SDSLevel.ERROR, (I18NCode)UsI18NCode.MSG_US_GENERAL_ERROR, new Object[]{((Throwable)t).getMessage()});
        throw new HumanTaskServiceException(UsI18NCode.MSG_US_GENERAL_ERROR, new Object[]{((Throwable)t).getMessage()}, (Throwable)t);
    }

    public static void logException(Throwable t, I18NCode code, Object[] params) {
        if (debug && t != null) {
            t.printStackTrace();
        }
        if (t != null) {
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug(t);
            if (t instanceof HumanTaskServiceException) {
                HumanTaskServiceException ut = (HumanTaskServiceException)((Object)t);
                SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).log(SDSLevel.ERROR, ut.getI18NCode(), ut.getParams());
            } else if (t instanceof LocalizableException) {
                LocalizableException lt = (LocalizableException)t;
                SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).log(SDSLevel.ERROR, lt.getI18NCode(), lt.getParams());
            } else {
                SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).log(SDSLevel.ERROR, (I18NCode)UsI18NCode.MSG_US_GENERAL_ERROR, new Object[]{t.getMessage()});
            }
        }
        if (code != null) {
            SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).log(SDSLevel.ERROR, code, params);
        }
    }

    public static void setPrintToStdOut(boolean sendToStOut) {
        debug = sendToStOut;
    }

    public static void debug(String message) {
        if (debug && message != null) {
            System.out.println(message);
        }
        SDSLogger.getLogger((SDSCategory)USCategory.RUNTIME).debug(message);
    }

    public static void logException(Throwable t) {
        Utils.logException(t, null, null);
    }

    public static String serializeDocument(Document doc) throws IOException {
        OutputFormat of = new OutputFormat(doc, "UTF-8", false);
        of.setOmitComments(false);
        of.setOmitXMLDeclaration(true);
        StringWriter writer = new StringWriter();
        XMLSerializer output = new XMLSerializer((Writer)writer, of);
        output.serialize(doc);
        return writer.toString();
    }
}

