/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.cam;

import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.ws_ht.OrganizationalEntityDocument;
import com.ibm.cognos.internal.hts.ws_ht.TFrom;
import com.ibm.cognos.internal.hts.ws_ht.TGenericHumanRole;
import com.ibm.cognos.internal.hts.ws_ht.TGrouplist;
import com.ibm.cognos.internal.hts.ws_ht.TOrganizationalEntity;
import com.ibm.cognos.internal.hts.ws_ht.TPeopleAssignments;
import com.ibm.cognos.internal.hts.ws_ht.TUserlist;
import java.util.HashSet;
import java.util.Set;

public class UserCollector {
    private Set<HTSTaskUser> users = new HashSet<HTSTaskUser>();

    public void collectUsers(TPeopleAssignments[] peopleAssignments) throws HumanTaskServiceException {
        if (peopleAssignments == null) {
            return;
        }
        for (int i = 0; i < peopleAssignments.length; ++i) {
            this.collectUsers(peopleAssignments[i].getBusinessAdministratorsArray());
            this.collectUsers(peopleAssignments[i].getExcludedOwnersArray());
            this.collectUsers(peopleAssignments[i].getPotentialOwnersArray());
            this.collectUsers(peopleAssignments[i].getRecipientsArray());
            this.collectUsers(peopleAssignments[i].getTaskStakeholdersArray());
            this.collectUsers(peopleAssignments[i].getTaskInitiatorArray());
        }
    }

    public void collectUsers(TGenericHumanRole[] organizationalEntities) throws HumanTaskServiceException {
        if (organizationalEntities == null) {
            return;
        }
        for (TGenericHumanRole genericHumanRole : organizationalEntities) {
            this.collectUsers(genericHumanRole);
        }
    }

    public void collectUsers(TGenericHumanRole organizationalEntity) throws HumanTaskServiceException {
        if (organizationalEntity != null) {
            this.collectUsers(organizationalEntity.getFrom());
        }
    }

    public void collectUsers(TFrom from) throws HumanTaskServiceException {
        HTSTaskUser user;
        int j;
        if (from == null) {
            return;
        }
        String lpg = from.getLogicalPeopleGroup().getLocalPart();
        OrganizationalEntityDocument oed = HTSSDKUtils.getOrganizationalEntity(from.getLiteral());
        TOrganizationalEntity tOrg = oed.getOrganizationalEntity();
        TUserlist users = tOrg.sizeOfUsersArray() != 0 ? tOrg.getUsersArray(0) : null;
        TGrouplist groups = tOrg.sizeOfGroupsArray() != 0 ? tOrg.getGroupsArray(0) : null;
        for (j = 0; users != null && j < users.sizeOfUserArray(); ++j) {
            user = new HTSTaskUser(users.getUserArray(j), false, lpg.toUpperCase());
            this.users.add(user);
        }
        for (j = 0; groups != null && j < groups.sizeOfGroupArray(); ++j) {
            user = new HTSTaskUser(groups.getGroupArray(j), true, lpg.toUpperCase());
            this.users.add(user);
        }
    }

    public Set<HTSTaskUser> getUsers() {
        return this.users;
    }
}

