/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.cam;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.security.IAuthenticator;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.Headers;
import com.cognos.jsmcommon.util.UserAccountUtil;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.genHandlers.RetryHandler;
import com.ibm.cognos.internal.hts.apiHandlers.genHandlers.UserDisplayNameStoreHandler;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logicalPeopleGroup.LogicalPeopleGroupSupport;
import com.ibm.cognos.internal.hts.logicalPeopleGroup.LogicalPeopleGroupSupportFactory;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.ITransactionHandler;
import com.ibm.cognos.internal.hts.persist.dao.TaskuserDAO;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskReadBy;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.properties.HTSServerProperties;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.GuidUtils;
import com.ibm.cognos.internal.hts.util.LPGUserKey;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.cam.IUserUtils;
import com.ibm.cognos.internal.hts.ws_ht.TGrouplist;
import com.ibm.cognos.internal.hts.ws_ht.TOrganizationalEntity;
import com.ibm.cognos.internal.hts.ws_ht.TUserlist;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class UserUtils
implements IUserUtils {
    public static final String CACHED_USERS = "CACHED_USERS";
    private static IUserUtils m_instance = null;
    private TaskuserDAO taskUserDao;

    public static IUserUtils instance() {
        if (m_instance == null) {
            m_instance = new UserUtils();
        }
        return m_instance;
    }

    public static void setInstance(IUserUtils utils) {
        m_instance = utils;
    }

    @Override
    public HTSTaskUser getUser(Headers header) throws HumanTaskServiceException {
        String userToken = null;
        try {
            LogicalPeopleGroupSupport lpgSupport = LogicalPeopleGroupSupportFactory.getInstance().getDefaultLogicalPeopleGroupSupport();
            UserAccountUtil util = lpgSupport.getUserAccountUtil(header);
            userToken = util.getUserSearchPath();
        }
        catch (SDKClientException e) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_USER_DATA, e);
        }
        catch (EMFSecurityException e) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_USER_DATA, e);
        }
        catch (Exception e) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_USER_DATA, e);
        }
        if (userToken == null) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_INACCESSIBLE_USER_DATA);
        }
        HTSTaskUser user = this.findOrStoreUser(userToken, false, LogicalPeopleGroupSupportFactory.getInstance().getDefaultLogicalPeopleGroup());
        return user;
    }

    @Override
    public List<HTSTaskUser> getUsers(TOrganizationalEntity oed, String lpg) throws HumanTaskServiceException {
        HTSTaskUser user;
        int j;
        ArrayList<HTSTaskUser> userPojos = new ArrayList<HTSTaskUser>();
        TUserlist users = oed.sizeOfUsersArray() != 0 ? oed.getUsersArray(0) : null;
        TGrouplist groups = oed.sizeOfGroupsArray() != 0 ? oed.getGroupsArray(0) : null;
        for (j = 0; users != null && j < users.sizeOfUserArray(); ++j) {
            user = this.findOrStoreUser(users.getUserArray(j), false, lpg);
            userPojos.add(user);
        }
        for (j = 0; groups != null && j < groups.sizeOfGroupArray(); ++j) {
            user = this.findOrStoreUser(groups.getGroupArray(j), true, lpg);
            if (!user.isGroup()) {
                Utils.throwHumanTaskServiceException(UsI18NCode.MSG_USV_ERROR_CONFLICTED_GROUP_USER_ROLE, new Object[]{user.getUserToken()});
            }
            userPojos.add(user);
        }
        return userPojos;
    }

    @Override
    public HTSTaskUser findOrStoreUser(String userToken) throws HumanTaskServiceException {
        return this.findOrStoreUser(userToken, false, LogicalPeopleGroupSupportFactory.getInstance().getDefaultLogicalPeopleGroup());
    }

    @Override
    public HTSTaskUser findUser(String userToken) throws HumanTaskServiceException {
        TaskuserDAO tudao = DAOFactory.getFactory().buildTaskuserDAO();
        if (userToken != null) {
            userToken = userToken.trim();
        }
        List<HTSTaskUser> list = tudao.findByUser(userToken, LogicalPeopleGroupSupportFactory.getInstance().getDefaultLogicalPeopleGroup());
        HTSTaskUser user = null;
        if (list != null && list.size() > 0) {
            user = list.get(0);
        }
        return user;
    }

    @Override
    public HTSTaskUser findOrStoreUser(String userToken, boolean isGroup, String group) throws HumanTaskServiceException {
        if (userToken != null) {
            userToken = userToken.trim();
        }
        Map<String, Object> threadProps = null;
        HTSTaskUser user = null;
        if (AbstractContext.getThreadProperties() != null) {
            threadProps = AbstractContext.getThreadProperties();
            if (threadProps != null) {
                HashMap<LPGUserKey, HTSTaskUser> cachedUsers = (HashMap<LPGUserKey, HTSTaskUser>)threadProps.get(CACHED_USERS);
                if (cachedUsers == null) {
                    cachedUsers = new HashMap<LPGUserKey, HTSTaskUser>();
                    threadProps.put(CACHED_USERS, cachedUsers);
                }
                if ((user = (HTSTaskUser)cachedUsers.get(new LPGUserKey(userToken, group))) == null) {
                    user = this.getOrStoreUser(userToken, isGroup, group);
                    cachedUsers.put(new LPGUserKey(userToken, group), user);
                }
            }
        } else {
            user = this.getOrStoreUser(userToken, isGroup, group);
        }
        return user;
    }

    private synchronized HTSTaskUser getOrStoreUser(String userToken, boolean isGroup, String group) throws HumanTaskServiceException {
        HTSTaskUser user = this.findUser(userToken);
        if (user == null) {
            user = new HTSTaskUser(userToken, isGroup, group);
            user.setId(GuidUtils.create());
            this.storeUser(user);
        }
        return user;
    }

    private void storeUser(HTSTaskUser user) throws HumanTaskServiceException {
        boolean startedTrans = false;
        ITransactionHandler tx = null;
        try {
            tx = AbstractContext.getCurrentTransactionHandler();
            if (!tx.inTransaction()) {
                startedTrans = true;
                tx.beginTransaction();
            }
            this.getTaskUserDao().save(user);
            if (startedTrans) {
                tx.commitTransaction();
            }
        }
        catch (RuntimeException e) {
            if (startedTrans) {
                tx.rollbackTransaction();
            }
            Utils.throwHumanTaskServiceException(e);
        }
    }

    @Override
    public Set<String> expandGroup(IAbstractContext context, HTSTaskUser user) throws HumanTaskServiceException {
        Set<String> users = null;
        try {
            String group = user.getLogicalPeopleGroup().toUpperCase();
            LogicalPeopleGroupSupport support = this.getPeopleGroupSupport(group, context.getHeader().getBiBusHeader());
            users = support.expandGroup(user.getUserToken(), context);
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e);
        }
        return users;
    }

    @Override
    public Set<String> getCurrentUserRolesAndGroups(HTSTaskUser currentUser, IAbstractContext context) throws HumanTaskServiceException {
        Set<String> groups = null;
        try {
            String group = currentUser.getLogicalPeopleGroup().toUpperCase();
            LogicalPeopleGroupSupport support = this.getPeopleGroupSupport(group, context.getHeader().getBiBusHeader());
            groups = support.getGroups(currentUser.getUserToken(), context);
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e);
        }
        return groups;
    }

    public String getUserNameFromCache(BiBusHeader biBusHeader, HTSTaskUser user, Locale locale) throws HumanTaskServiceException {
        return user.getDisplayName(locale);
    }

    @Override
    public String getUserName(IAbstractContext context, HTSTaskUser user) throws HumanTaskServiceException {
        String value = null;
        if (this.isCachingUserNames()) {
            UserDisplayNameStoreHandler userDisplayHandler = new UserDisplayNameStoreHandler(user);
            new RetryHandler(userDisplayHandler).handleRequestImpl(context);
            value = userDisplayHandler.getDisplayName();
        } else {
            value = this.getUserName(context.getHeader().getBiBusHeader(), user, context.getLocale());
        }
        return value;
    }

    private boolean isCachingUserNames() {
        String doCache = HTSServerProperties.getInstance().getProperty("userNames.cache");
        if (doCache == null) {
            doCache = "true";
        }
        return Boolean.valueOf(doCache);
    }

    private synchronized TaskuserDAO getTaskUserDao() {
        if (this.taskUserDao == null) {
            this.taskUserDao = DAOFactory.getFactory().buildTaskuserDAO();
        }
        return this.taskUserDao;
    }

    @Override
    public LogicalPeopleGroupSupport getPeopleGroupSupport(String lpg, BiBusHeader header) throws HumanTaskServiceException {
        LogicalPeopleGroupSupport support = LogicalPeopleGroupSupportFactory.getInstance().getLogicalPeopleGroupSupport(lpg == null ? null : lpg);
        support.initialize(header);
        return support;
    }

    @Override
    public BiBusHeader logon(HTSTaskUser user) {
        try {
            IAuthenticator auth = AuthenticatorFactory.getInstance();
            JobBiBusHeaders headers = new JobBiBusHeaders(new BiBusHeader());
            headers.setCamCredential(user.getUserToken() + "/credential");
            auth.logon(headers);
            return headers.getBiBusHeader();
        }
        catch (SDKClientException e) {
            Utils.logException(e);
        }
        catch (EMFSecurityException e) {
            Utils.logException(e);
        }
        return null;
    }

    @Override
    public void logoff(BiBusHeader header) {
        try {
            IAuthenticator auth = AuthenticatorFactory.getInstance();
            auth.logoff(header);
        }
        catch (EMFSecurityException e) {
            Utils.logException(e);
        }
    }

    @Override
    public String getTaskReadLevelForUser(HTSTask task, HTSTaskUser user) {
        List<HTSTaskReadBy> readBys = task.getTaskReadBys();
        String taskReadLevel = "";
        if (readBys != null) {
            for (HTSTaskReadBy htsTaskReadBy : readBys) {
                if (!htsTaskReadBy.getUser().getUserToken().equals(user.getUserToken())) continue;
                if (htsTaskReadBy.getTaskReadLevel() == HTSTaskReadBy.READ_LEVEL.ACKNOWLEDGED.ordinal()) {
                    taskReadLevel = HTSTaskReadBy.READ_LEVEL.ACKNOWLEDGED.name();
                    continue;
                }
                if (htsTaskReadBy.getTaskReadLevel() != HTSTaskReadBy.READ_LEVEL.LOOKED_AT.ordinal()) continue;
                taskReadLevel = HTSTaskReadBy.READ_LEVEL.LOOKED_AT.name();
            }
        }
        return taskReadLevel;
    }

    @Override
    public String getUserName(BiBusHeader biBusHeader, HTSTaskUser user, Locale locale) throws HumanTaskServiceException {
        String name = null;
        try {
            String group = user.getLogicalPeopleGroup().toUpperCase();
            LogicalPeopleGroupSupport support = this.getPeopleGroupSupport(group, biBusHeader);
            name = support.getDisplayName(user.getUserToken(), locale);
        }
        catch (Exception e) {
            Utils.throwHumanTaskServiceException(e);
        }
        return name;
    }

    @Override
    public String getDefaultLogicalPeopleGroup() {
        return LogicalPeopleGroupSupportFactory.getInstance().getDefaultLogicalPeopleGroup();
    }
}

