/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao;

import com.cognos.jsmcommon.util.Headers;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSCallback;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSCallbackParam;
import com.ibm.cognos.internal.hts.util.GuidUtils;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.wsa.ReplyToDocument;
import com.ibm.cognos.internal.hts.wsa.ToDocument;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.client.Call;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.utils.XMLUtils;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class CallbackUtilities {
    public static String WS_ADDRESSING_HEADER_NAME = "US-ADDRESSING";
    public static final QName EVENT_ID_REF_PARAM = new QName("http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1", "eventId", "ns1");
    public static final QName TASK_ID_REF_PARAM = new QName("http://www.ibm.com/xmlns/prod/cognos/WS-HT/ext", "taskId", "ext");
    public static final QName STATUS_FLAG_REF_PARAM = new QName("http://www.ibm.com/xmlns/prod/cognos/WS-HT/ext", "status", "ext");

    public static void addCallbackHeaders(Call call, HTSCallback callback) throws Exception {
        List<Element> headers = CallbackUtilities.getCallbackHeaders(callback);
        for (Element element : headers) {
            try {
                call.addHeader(new SOAPHeaderElement(element));
            }
            catch (Exception e) {
                Utils.logException(e);
            }
        }
    }

    public static void addCallbackHeaders(BIBusEnvelope envelope, HTSCallback callback) throws Exception {
        List<org.dom4j.Element> headers = CallbackUtilities.getDom4JCallbackHeaders(callback);
        for (org.dom4j.Element element : headers) {
            try {
                envelope.getHeader().add(element);
            }
            catch (Exception e) {
                Utils.throwHumanTaskServiceException(e);
            }
        }
    }

    public static ReplyToDocument makeReplyToDocument(org.dom4j.Element ele) {
        ReplyToDocument replyToDocument = null;
        try {
            if (ele != null) {
                replyToDocument = ReplyToDocument.Factory.parse((String)ele.asXML());
            }
        }
        catch (XmlException xmlException) {
            // empty catch block
        }
        return replyToDocument;
    }

    public static ToDocument makeToDocument(org.dom4j.Element ele) {
        ToDocument toDocument = null;
        try {
            if (ele != null) {
                toDocument = ToDocument.Factory.parse((String)ele.asXML());
            }
        }
        catch (XmlException xmlException) {
            // empty catch block
        }
        return toDocument;
    }

    public static HTSCallback parseRequestHeader(Headers header) {
        ReplyToDocument rtd = CallbackUtilities.makeReplyToDocument(header.getReplyToElement());
        HTSCallback cb = CallbackUtilities.makeCallBack(rtd);
        if (header.getBiBusHeader().getCAM() != null) {
            cb.setCredential(header.getBiBusHeader().getCAM().getCAMCredentialPath());
        }
        return cb;
    }

    public static HTSCallback makeCallBack(ReplyToDocument rtd) {
        if (rtd == null) {
            return null;
        }
        HTSCallback cb = new HTSCallback();
        cb.setId(GuidUtils.create());
        cb.setAction(rtd.getReplyTo().getMetadata().getResponseAction());
        cb.setOperation(rtd.getReplyTo().getMetadata().getResponseOperation());
        cb.setAddress(rtd.getReplyTo().getAddress().getStringValue());
        XmlCursor cursor = rtd.getReplyTo().getReferenceParameters().newCursor();
        cursor.toFirstChild();
        do {
            HTSCallbackParam cbp = new HTSCallbackParam(cursor.getName().toString(), cursor.getTextValue());
            cb.addCallBackParam(cbp);
        } while (cursor.toNextSibling());
        return cb;
    }

    public static void setWsAddressingResponseHeader(Headers header, HTSCallback callback) throws DocumentException {
        List<org.dom4j.Element> headers = CallbackUtilities.getDom4JCallbackHeaders(callback);
        for (org.dom4j.Element element : headers) {
            header.updateExtraHeader(element);
        }
        if (callback.getCredential() != null && !"".equals(callback.getCredential())) {
            header.getBiBusHeader().getCAM().setCAMCredentialPath(callback.getCredential());
        }
    }

    public static void setWsAddressingRequestHeader(Headers header, HTSCallback callback) throws DocumentException {
        ReplyToDocument rtd = CallbackUtilities.makeReplyTo(callback);
        SAXReader reader = new SAXReader();
        Document doc = reader.read(new InputSource(new StringReader(rtd.toString())));
        header.updateExtraHeader(doc.getRootElement());
    }

    public static ReplyToDocument makeReplyTo(HTSCallback callback) {
        return CallbackUtilities.makeReplyTo(callback, false);
    }

    public static ReplyToDocument makeReplyTo(HTSCallback callback, boolean error) {
        ReplyToDocument rtd = ReplyToDocument.Factory.newInstance();
        rtd.addNewReplyTo();
        rtd.getReplyTo().addNewAddress();
        rtd.getReplyTo().getAddress().setStringValue(callback.getAddress());
        rtd.getReplyTo().addNewReferenceParameters();
        XmlCursor cursor = rtd.getReplyTo().getReferenceParameters().newCursor();
        cursor.toFirstContentToken();
        for (HTSCallbackParam param : callback.getHtsCallbackparams()) {
            QName qName = QName.valueOf(param.getQname());
            cursor.beginElement(qName.getLocalPart(), qName.getNamespaceURI());
            cursor.insertChars(param.getValue());
            cursor.toNextToken();
        }
        rtd.getReplyTo().addNewMetadata();
        rtd.getReplyTo().getMetadata().setResponseAction(callback.getAction());
        rtd.getReplyTo().getMetadata().setResponseOperation(callback.getOperation());
        return rtd;
    }

    public static ToDocument makeTo(HTSCallback callback) {
        ToDocument td = ToDocument.Factory.newInstance();
        td.addNewTo().setStringValue(callback.getAddress());
        return td;
    }

    public static void removeCallbackParameter(String name, HTSCallback cb) {
        List<HTSCallbackParam> cbp = cb.getHtsCallbackparams();
        HTSCallbackParam param = null;
        for (HTSCallbackParam callbackparam : cbp) {
            if (!callbackparam.getQname().contains(name)) continue;
            param = callbackparam;
        }
        if (param != null) {
            cb.getHtsCallbackparams().remove(param);
        }
    }

    public static void addCallbackParameter(QName name, String value, HTSCallback cb) {
        HTSCallbackParam cbp = new HTSCallbackParam(name.toString(), value);
        cb.addCallBackParam(cbp);
    }

    public static String getCallbackParameter(String name, HTSCallback cb) {
        List<HTSCallbackParam> cbp = cb.getHtsCallbackparams();
        for (HTSCallbackParam callbackparam : cbp) {
            if (!callbackparam.getQname().contains(name)) continue;
            return callbackparam.getValue();
        }
        return null;
    }

    private static List<String> getCallbackHeadersAsString(HTSCallback callback) {
        ArrayList<String> headerStrings = new ArrayList<String>();
        headerStrings.add(CallbackUtilities.makeTo(callback).toString());
        List<HTSCallbackParam> params = callback.getHtsCallbackparams();
        int i = 1;
        for (HTSCallbackParam param : params) {
            StringBuffer buff = new StringBuffer();
            QName qname = QName.valueOf(param.getQname());
            String prefix = "uscbp" + i++;
            String qualName = prefix + ":" + qname.getLocalPart();
            buff.append("<");
            buff.append(qualName);
            buff.append(" xmlns:");
            buff.append(prefix);
            buff.append("=\"");
            buff.append(qname.getNamespaceURI());
            buff.append("\"");
            buff.append(">");
            buff.append(param.getValue());
            buff.append("</");
            buff.append(qualName);
            buff.append(">");
            headerStrings.add(buff.toString());
        }
        return headerStrings;
    }

    static List<Element> getCallbackHeaders(HTSCallback callback) throws Exception {
        ArrayList<Element> headers = new ArrayList<Element>();
        List<String> headerStrings = CallbackUtilities.getCallbackHeadersAsString(callback);
        for (String header : headerStrings) {
            headers.add(CallbackUtilities.makeElement(header));
        }
        return headers;
    }

    static List<org.dom4j.Element> getDom4JCallbackHeaders(HTSCallback callback) throws DocumentException {
        ArrayList<org.dom4j.Element> headers = new ArrayList<org.dom4j.Element>();
        SAXReader reader = new SAXReader();
        List<String> headerStrings = CallbackUtilities.getCallbackHeadersAsString(callback);
        for (String header : headerStrings) {
            headers.add(reader.read(new InputSource(new StringReader(header))).getRootElement());
        }
        return headers;
    }

    private static Element makeElement(String content) throws Exception {
        ByteArrayInputStream sourceStream = new ByteArrayInputStream(content.getBytes("UTF-8"));
        org.w3c.dom.Document doc = XMLUtils.newDocument((InputStream)sourceStream);
        return doc.getDocumentElement();
    }
}

