/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao;

import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.genHandlers.CommentInsertHandler;
import com.ibm.cognos.internal.hts.apiHandlers.genHandlers.RetryHandler;
import com.ibm.cognos.internal.hts.apiHandlers.genHandlers.TransactionHandler;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSPost;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSThread;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.HTSConstants;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.util.TimeUtils;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.cam.UserUtils;
import com.ibm.cognos.internal.hts.util.dao.builder.AbstractCommentBuilder;
import com.ibm.cognos.internal.hts.ws_ht.api.TComment;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import org.apache.xmlbeans.XmlObject;

public class CommentUtil {
    public static TComment makeComment(HTSPost post, List<HTSPost> posts, IAbstractContext context) throws HumanTaskServiceException {
        TComment comment = TComment.Factory.newInstance();
        try {
            String pagetext = URLDecoder.decode(post.getPagetext(), HTSConstants.HTS_ENCODING);
            comment.setText(pagetext);
        }
        catch (UnsupportedEncodingException ex) {
            Utils.throwHumanTaskServiceException(ex);
        }
        comment.setAddedAt(TimeUtils.toUTCCalendar(post.getCreateDate()));
        comment.setAddedBy(post.getHtsTaskUser().getUserToken());
        String formattedAddedBy = UserUtils.instance().getUserName(context, post.getHtsTaskUser());
        HTSSDKUtils.setCustomXML((XmlObject)comment, HTSConstants.HTS_FORMATTED_ADDED_BY, formattedAddedBy);
        HTSSDKUtils.setCustomXML((XmlObject)comment, HTSConstants.HTS_ID, post.getId());
        String parentId = post.getParentHtsPost() == null ? null : post.getParentHtsPost().getId();
        HTSSDKUtils.setCustomXML((XmlObject)comment, HTSConstants.HTS_PARENT_ID, parentId);
        int replyCount = CommentUtil.calculateReplyCount(post, posts);
        HTSSDKUtils.setCustomXML((XmlObject)comment, HTSConstants.HTS_REPLY_COUNT, replyCount);
        if (post.getHtsPostTasks() != null) {
            for (HTSTask link : post.getHtsPostTasks()) {
                if (link == null) continue;
                HTSSDKUtils.setCustomXML((XmlObject)comment, HTSConstants.HTS_TASK_ID, link.getId());
            }
        }
        HTSSDKUtils.setCustomXML((XmlObject)comment, "commentType", post.getHtsThread().getType());
        return comment;
    }

    private static int calculateReplyCount(HTSPost aPost, List<HTSPost> hTSPosts) {
        int replies = 0;
        for (HTSPost post : hTSPosts) {
            if (post.getParentHtsPost() == null || !post.getParentHtsPost().equals(aPost)) continue;
            ++replies;
        }
        return replies;
    }

    public static String addCommentToObject(AbstractCommentBuilder builder) throws HumanTaskServiceException {
        HTSPost post = null;
        HTSThread thread = builder.getThread();
        post = builder.getPost();
        post.setHtsThread(thread);
        thread.addHTSPost(post);
        return post == null ? null : post.getId();
    }

    public static String insertComment(IAbstractContext context, AbstractCommentBuilder builder) throws HumanTaskServiceException {
        CommentInsertHandler pundit = new CommentInsertHandler(builder);
        new RetryHandler(new TransactionHandler(pundit)).handleRequest(context);
        HTSPost post = builder.getBuiltPost();
        return post == null ? null : post.getId();
    }
}

