/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao;

import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSFolder;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.cam.UserUtils;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.FolderAction;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.PrivateFolder;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.PublicFolder;
import java.util.ArrayList;
import java.util.List;

public class FolderUtils {
    public static FolderAction getFolderAction(List<HTSFolder> folders) {
        FolderAction fa = FolderAction.Factory.newInstance();
        for (HTSFolder folder : folders) {
            if (!HTSFolder.TYPE.PUBLIC.getType().equals(folder.getFolderType())) continue;
            PublicFolder pubFolder = fa.addNewPublicFolder();
            pubFolder.setName(folder.getFolderName());
        }
        return fa.sizeOfPublicFolderArray() > 0 ? fa : null;
    }

    public static List<HTSFolder> getFolders(FolderAction folderAction, HTSTaskUser creator, HTSTask task) throws HumanTaskServiceException {
        ArrayList<HTSTask> tasks = new ArrayList<HTSTask>();
        tasks.add(task);
        return FolderUtils.getFolders(folderAction, creator, tasks);
    }

    public static List<HTSFolder> getFolders(FolderAction folderAction, HTSTaskUser creator, List<HTSTask> taskList) throws HumanTaskServiceException {
        ArrayList<HTSFolder> htsFolders = new ArrayList<HTSFolder>();
        PrivateFolder[] privates = folderAction.getPrivateFolderArray();
        for (int j = 0; j < privates.length; ++j) {
            List<HTSFolder> folders = FolderUtils.getPrivateFolders(privates[j].getName(), privates[j].getUserArray(), creator, taskList);
            htsFolders.addAll(folders);
        }
        PublicFolder[] publics = folderAction.getPublicFolderArray();
        for (int j = 0; j < publics.length; ++j) {
            htsFolders.addAll(FolderUtils.getHtsFolders(publics[j].getName(), HTSFolder.TYPE.PUBLIC, null, taskList));
        }
        return htsFolders;
    }

    private static List<HTSFolder> getPrivateFolders(String name, String[] users, HTSTaskUser creator, List<HTSTask> taskList) throws HumanTaskServiceException {
        ArrayList<HTSFolder> htsFolders = new ArrayList<HTSFolder>();
        if (users == null || users.length == 0) {
            htsFolders.addAll(FolderUtils.getHtsFolders(name, HTSFolder.TYPE.PRIVATE, creator, taskList));
        }
        for (int i = 0; i < users.length; ++i) {
            HTSTaskUser user = UserUtils.instance().findUser(users[i]);
            htsFolders.addAll(FolderUtils.getHtsFolders(name, HTSFolder.TYPE.PRIVATE, user, taskList));
        }
        return htsFolders;
    }

    private static List<HTSFolder> getHtsFolders(String name, HTSFolder.TYPE type, HTSTaskUser user, List<HTSTask> taskList) throws HumanTaskServiceException {
        ArrayList<HTSFolder> folders = new ArrayList<HTSFolder>();
        for (HTSTask task : taskList) {
            FolderUtils.checkForCustomFolder(folders, name, type, user, task);
            folders.add(FolderUtils.makeFolder(name, type, user, task));
        }
        return folders;
    }

    private static void checkForCustomFolder(List<HTSFolder> folders, String name, HTSFolder.TYPE type, HTSTaskUser user, HTSTask task) {
        if (name != null && name.length() > 0 && !FolderUtils.isUIFolder(name)) {
            HTSFolder folder = FolderUtils.makeFolder(HTSFolder.UI_FOLDERS.INBOX.name(), HTSFolder.TYPE.PRIVATE, user, task);
            folders.add(folder);
        }
    }

    private static boolean isUIFolder(String name) {
        boolean isUIFolder = false;
        HTSFolder.UI_FOLDERS[] values = HTSFolder.UI_FOLDERS.values();
        for (int i = 0; i < values.length && !isUIFolder; ++i) {
            isUIFolder = name.equalsIgnoreCase(values[i].name());
        }
        return isUIFolder;
    }

    public static HTSFolder makeFolder(String name, HTSFolder.TYPE type, HTSTaskUser user, HTSTask task) {
        HTSFolder folder = task.getFolderByNameAndUser(name, user);
        if (folder == null) {
            folder = new HTSFolder();
            folder.setFolderName(name);
            folder.setFolderType(type.name());
            folder.setHtsTaskuser(user);
            task.addFolder(folder);
        }
        return folder;
    }
}

