/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao;

import com.ibm.cognos.internal.hts.apiHandlers.context.ChangedHumanRoleMode;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logicalPeopleGroup.LogicalPeopleGroupSupport;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSHumanRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.cam.UserUtils;
import com.ibm.cognos.internal.hts.util.dao.humanrole.HumanRoleOrganizationalEntityConverter;
import com.ibm.cognos.internal.hts.util.dao.humanrole.OrganizationalEntityConverter;
import com.ibm.cognos.internal.hts.ws_ht.OrganizationalEntityDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.FormattedBusinessAdministratorsDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.FormattedNotificationRecipientsDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.FormattedPotentialOwnersDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.FormattedTaskInitiatorsDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.FormattedTaskStakeholdersDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.TFormattedOrganizationalEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;

public class HumanroleUtils {
    private static final String CACHED_PEOPLE_GROUPS = "CACHED_PEOPLE_GROUPS";

    public static HTSRole getRole(HTSRole.Roles roleEnum) {
        return HTSRole.fromRole(roleEnum.getRole());
    }

    public static void checkActualOwnerOrRoles(HTSTask task, HTSTaskUser user, HTSRole.Roles[] roles, String operation) throws HumanTaskServiceException {
        try {
            HumanroleUtils.checkActualOwner(task, user);
        }
        catch (HumanTaskServiceException e) {
            HumanroleUtils.checkRoles(task, user, roles);
        }
    }

    public static void checkActualOwner(HTSTask task, HTSTaskUser user) throws HumanTaskServiceException {
        if (task.getActualOwner() == null || !task.getActualOwner().equals(user)) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_NOT_OWNER, new Object[]{user.getUserToken(), task.getName()});
        }
    }

    public static void checkRoles(HTSTask task, HTSTaskUser user, HTSRole.Roles[] roles) throws HumanTaskServiceException {
        if (!HumanroleUtils.hasRoles(roles, task, user)) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_ROLE, new Object[]{HTSRole.Roles.POTENTIAL_OWNERS.getRole(), user.getUserToken()});
        }
    }

    public static boolean hasRole(HTSRole.Roles role, HTSTask task, HTSTaskUser user) {
        return HumanroleUtils.hasRoles(new HTSRole.Roles[]{role}, task, user);
    }

    public static List<HTSHumanRole> findHumanRolesByTokensForTask(HTSTask task, Set<String> userTokens) {
        ArrayList<HTSHumanRole> hrs = new ArrayList<HTSHumanRole>();
        List<HTSHumanRole> allHrs = task.getHtsHumanRoles();
        for (HTSHumanRole humanRole : allHrs) {
            if (!userTokens.contains(humanRole.getHtsTaskUser().getUserToken())) continue;
            hrs.add(humanRole);
        }
        return hrs;
    }

    public static List<HTSHumanRole> findHumanRolesForLpgForTask(HTSTask task, String group) {
        ArrayList<HTSHumanRole> hrs = new ArrayList<HTSHumanRole>();
        List<HTSHumanRole> allHrs = task.getHtsHumanRoles();
        for (HTSHumanRole humanRole : allHrs) {
            if (!humanRole.getHtsTaskUser().getLogicalPeopleGroup().equals(group)) continue;
            hrs.add(humanRole);
        }
        return hrs;
    }

    public static List<HTSRole.Roles> getRoles(HTSTask task, IAbstractContext context) throws HumanTaskServiceException {
        List<HTSRole.Roles> roles = context.getRolesForTask(task.getId());
        if (roles != null) {
            return roles;
        }
        HTSTaskUser user = context.getUsTaskUser();
        Set<String> roleAndGroupTokens = context.getCurrentUserRolesAndGroups();
        roleAndGroupTokens.add(user.getUserToken());
        List<HTSHumanRole> allHrs = task.getHtsHumanRoles();
        for (HTSHumanRole role : allHrs) {
            String userToken = role.getHtsTaskUser().getUserToken();
            String lpg = role.getHtsTaskUser().getLogicalPeopleGroup();
            LogicalPeopleGroupSupport lpgSupport = UserUtils.instance().getPeopleGroupSupport(lpg, context.getHeader().getBiBusHeader());
            Set<String> groupsFromUserToken = null;
            try {
                groupsFromUserToken = lpgSupport.getGroups(userToken, context);
            }
            catch (Exception e) {
                Utils.logException(e);
            }
            if (groupsFromUserToken == null || groupsFromUserToken.size() <= 0) continue;
            roleAndGroupTokens.addAll(groupsFromUserToken);
        }
        List<HTSHumanRole> humanroles = HumanroleUtils.findHumanRolesByTokensForTask(task, roleAndGroupTokens);
        roles = new ArrayList<HTSRole.Roles>();
        for (HTSHumanRole humanrole : humanroles) {
            roles.add(HTSRole.Roles.findRole(humanrole.getHtsRole().getRole()));
        }
        if (user.equals(task.getActualOwner())) {
            roles.add(HTSRole.Roles.ACTUAL_OWNER);
        }
        if (user.equals(task.getTaskInitiator()) || user.equals(task.getCreatedBy())) {
            roles.add(HTSRole.Roles.TASK_INITIATORS);
        }
        context.setRolesForTask(task.getId(), roles);
        return roles;
    }

    public static List<HTSHumanRole> getHumanRoles(HTSTask task, HTSRole.Roles[] roles) throws HumanTaskServiceException {
        ArrayList<HTSHumanRole> hrs = new ArrayList<HTSHumanRole>();
        HashSet<HTSRole> roleSet = new HashSet<HTSRole>();
        for (int i = 0; i < roles.length; ++i) {
            roleSet.add(HumanroleUtils.getRole(roles[i]));
        }
        for (HTSHumanRole hr : task.getHtsHumanRoles()) {
            if (!roleSet.contains(hr.getHtsRole())) continue;
            hrs.add(hr);
        }
        return hrs;
    }

    public static OrganizationalEntityDocument getHumanRole(HTSTask task, HTSRole.Roles role) throws HumanTaskServiceException {
        HumanRoleOrganizationalEntityConverter hroec = new HumanRoleOrganizationalEntityConverter(null);
        return ((OrganizationalEntityConverter)hroec).getOrganizationalEntity(task.getHumanroles(role));
    }

    public static void updateHumanRoles(IAbstractContext context, HTSTask task, List<HTSHumanRole> newHumanRoles, HTSRole.Roles updatedRole) {
        Map<String, HTSHumanRole> currentHumanRoleMap = HumanroleUtils.makeHumanRoleMap(task.getHtsHumanRoles(), updatedRole);
        Map<String, HTSHumanRole> newHumanRoleMap = HumanroleUtils.makeHumanRoleMap(newHumanRoles, updatedRole);
        for (String currentKey : currentHumanRoleMap.keySet()) {
            if (newHumanRoleMap.containsKey(currentKey)) continue;
            HTSHumanRole remove = currentHumanRoleMap.get(currentKey);
            context.addChangedHumanRole(ChangedHumanRoleMode.CHANGED_ROLE_TYPE_REMOVED, remove);
            task.removeHTSHumanrole(remove);
        }
        for (String newKey : newHumanRoleMap.keySet()) {
            if (currentHumanRoleMap.containsKey(newKey)) continue;
            HTSHumanRole add = newHumanRoleMap.get(newKey);
            task.addHTSHumanRole(add);
            context.addChangedHumanRole(ChangedHumanRoleMode.CHANGED_ROLE_TYPE_ADDED, add);
        }
    }

    private static Map<String, HTSHumanRole> makeHumanRoleMap(List<HTSHumanRole> hrs, HTSRole.Roles role) {
        HashMap<String, HTSHumanRole> hrMap = new HashMap<String, HTSHumanRole>();
        for (HTSHumanRole hr : hrs) {
            if (!hr.getHtsRole().getRole().equals(role.getRole())) continue;
            hrMap.put(hr.getHtsTaskUser().getUserToken(), hr);
        }
        return hrMap;
    }

    public static boolean hasRoles(HTSRole.Roles[] roles, HTSTask task, HTSTaskUser user) {
        boolean hasRole = false;
        List<HTSHumanRole> humanroles = task.getHtsHumanRoles();
        HashSet<HTSRole> roleSet = new HashSet<HTSRole>();
        for (int i = 0; i < roles.length; ++i) {
            roleSet.add(HumanroleUtils.getRole(roles[i]));
        }
        for (HTSHumanRole humanrole : humanroles) {
            if (!roleSet.contains(humanrole.getHtsRole()) || humanrole.getHtsTaskUser() == null || !humanrole.getHtsTaskUser().equals(user)) continue;
            hasRole = true;
            break;
        }
        return hasRole;
    }

    public static HTSRole getRole(String stringRole) {
        return HTSRole.fromRole(stringRole);
    }

    public static void setFormattedHumanRoles(XmlObject object, HTSTask task, IAbstractContext context) throws HumanTaskServiceException {
        String ownerName;
        HumanRoleOrganizationalEntityConverter hroec = new HumanRoleOrganizationalEntityConverter(context);
        TFormattedOrganizationalEntity fti = hroec.getFormattedOrganizationalEntity(task.getHumanroles(HTSRole.Roles.TASK_INITIATORS));
        FormattedTaskInitiatorsDocument ftid = FormattedTaskInitiatorsDocument.Factory.newInstance();
        ftid.setFormattedTaskInitiators(fti);
        HTSSDKUtils.appendXMLBean(object, (XmlObject)ftid);
        TFormattedOrganizationalEntity fba = hroec.getFormattedOrganizationalEntity(task.getHumanroles(HTSRole.Roles.BUSINESS_ADMINISTRATORS));
        FormattedBusinessAdministratorsDocument fbad = FormattedBusinessAdministratorsDocument.Factory.newInstance();
        fbad.setFormattedBusinessAdministrators(fba);
        HTSSDKUtils.appendXMLBean(object, (XmlObject)fbad);
        TFormattedOrganizationalEntity fpo = hroec.getFormattedOrganizationalEntity(task.getHumanroles(HTSRole.Roles.POTENTIAL_OWNERS));
        FormattedPotentialOwnersDocument fpod = FormattedPotentialOwnersDocument.Factory.newInstance();
        fpod.setFormattedPotentialOwners(fpo);
        HTSSDKUtils.appendXMLBean(object, (XmlObject)fpod);
        TFormattedOrganizationalEntity fnr = hroec.getFormattedOrganizationalEntity(task.getHumanroles(HTSRole.Roles.NOTIFICATION_RECIPIENTS));
        FormattedNotificationRecipientsDocument fnrd = FormattedNotificationRecipientsDocument.Factory.newInstance();
        fnrd.setFormattedNotificationRecipients(fnr);
        HTSSDKUtils.appendXMLBean(object, (XmlObject)fnrd);
        TFormattedOrganizationalEntity fts = hroec.getFormattedOrganizationalEntity(task.getHumanroles(HTSRole.Roles.TASK_STAKEHOLDERS));
        FormattedTaskStakeholdersDocument ftsd = FormattedTaskStakeholdersDocument.Factory.newInstance();
        ftsd.setFormattedTaskStakeholders(fts);
        HTSSDKUtils.appendXMLBean(object, (XmlObject)ftsd);
        HTSTaskUser owner = task.getActualOwner();
        HTSTaskUser initiator = task.getTaskInitiator();
        HTSTaskUser creator = task.getCreatedBy();
        if (owner != null) {
            ownerName = UserUtils.instance().getUserName(context, owner);
            HTSSDKUtils.setCustomXML(object, "http://www.ibm.com/xmlns/prod/cognos/WS-HT/ext", "formattedActualOwner", ownerName);
        } else if (HTSTask.TYPE.NOTIFICATION == task.getTaskType()) {
            ownerName = UserUtils.instance().getUserName(context, context.getUsTaskUser());
            HTSSDKUtils.setCustomXML(object, "http://www.ibm.com/xmlns/prod/cognos/WS-HT/ext", "formattedActualOwner", ownerName);
        }
        if (initiator != null) {
            String initiatorName = UserUtils.instance().getUserName(context, initiator);
            HTSSDKUtils.setCustomXML(object, "http://www.ibm.com/xmlns/prod/cognos/WS-HT/ext", "formattedTaskInitiator", initiatorName);
        }
        String creatorName = UserUtils.instance().getUserName(context, creator);
        HTSSDKUtils.setCustomXML(object, "http://www.ibm.com/xmlns/prod/cognos/WS-HT/ext", "formattedCreatedBy", creatorName);
    }
}

