/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao;

import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.TaskDAO;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSMessage;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.GuidUtils;
import com.ibm.cognos.internal.hts.util.pojo.MESSAGE_TYPE;
import java.util.ArrayList;
import java.util.List;

public class MessageUtils {
    public static HTSMessage createMessageInTask(HTSTask task, String messageString, String partName, MESSAGE_TYPE msgType) {
        List<HTSMessage> taskMessages;
        HTSMessage message = new HTSMessage();
        message.setId(GuidUtils.create());
        message.setTask(task);
        message.setMessageType(msgType.toString());
        message.setMessage(messageString);
        if (partName != null) {
            message.setName(partName);
        }
        if ((taskMessages = task.getHtsMessages()) == null) {
            taskMessages = new ArrayList<HTSMessage>();
            task.setHtsMessages(taskMessages);
        }
        taskMessages.add(message);
        return message;
    }

    public static void save(HTSTask task) throws HumanTaskServiceException {
        TaskDAO taskDao = DAOFactory.getFactory().buildTaskDAO();
        taskDao.update(task);
    }

    public static HTSMessage getInputMessage(HTSTask task, String part) {
        HTSMessage message = null;
        message = part == null ? MessageUtils.getMessageFromTask(task, MESSAGE_TYPE.INPUT) : MessageUtils.getMessageFromTask(task, MESSAGE_TYPE.INPUT, part);
        return message;
    }

    public static HTSMessage getOutputMessage(HTSTask task, String part) {
        HTSMessage message = null;
        message = part == null ? MessageUtils.getMessageFromTask(task, MESSAGE_TYPE.OUTPUT) : MessageUtils.getMessageFromTask(task, MESSAGE_TYPE.OUTPUT, part);
        return message;
    }

    public static HTSMessage getFaultMessage(HTSTask task) {
        return MessageUtils.getMessageFromTask(task, MESSAGE_TYPE.FAULT);
    }

    private static HTSMessage getMessageFromTask(HTSTask task, MESSAGE_TYPE msgType) {
        HTSMessage message = MessageUtils.findMessageOfType(task.getHtsMessages(), msgType);
        return message;
    }

    private static HTSMessage getMessageFromTask(HTSTask task, MESSAGE_TYPE msgType, String partName) {
        List<HTSMessage> msgs = MessageUtils.findMessagesOfType(task.getHtsMessages(), msgType);
        return MessageUtils.findMessageWithPartName(msgs, partName);
    }

    private static HTSMessage findMessageOfType(List<HTSMessage> messages, MESSAGE_TYPE msgType) {
        List<HTSMessage> foundMessages = MessageUtils.findMessagesOfType(messages, msgType);
        return foundMessages.size() == 0 ? null : foundMessages.get(0);
    }

    private static List<HTSMessage> findMessagesOfType(List<HTSMessage> messages, MESSAGE_TYPE msgType) {
        ArrayList<HTSMessage> msgList = new ArrayList<HTSMessage>();
        if (messages != null) {
            for (HTSMessage msg : messages) {
                if (!msg.getMessageType().equals(msgType.name())) continue;
                msgList.add(msg);
            }
        }
        return msgList;
    }

    private static HTSMessage findMessageWithPartName(List<HTSMessage> messages, String partName) {
        HTSMessage result = null;
        for (HTSMessage msg : messages) {
            String name = msg.getName();
            if (name == null || !name.equals(partName)) continue;
            result = msg;
            break;
        }
        return result;
    }
}

