/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao;

import com.ibm.cognos.internal.hts.persist.dao.TaskSearchProperties;
import com.ibm.cognos.internal.hts.service.Registry;
import com.ibm.cognos.internal.hts.util.dao.WhereClauseOrGroup;
import com.ibm.cognos.internal.hts.util.dao.WhereClausePiece;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import javax.persistence.Query;

public class ParamNameValue
implements WhereClausePiece {
    private static final String NAMED_PARAM = "namedParams";
    private String m_dbName;
    private Object m_value;
    private String m_operator;
    private static String NOT_STARTED = "NOT_STARTED";

    private ParamNameValue() {
    }

    public void setOperator(String op) {
        this.m_operator = op;
    }

    public String getOperator() {
        return this.m_operator;
    }

    public void setDBName(String name) {
        this.m_dbName = name;
    }

    public String getDBName() {
        return this.m_dbName;
    }

    public Object getValue() {
        return this.m_value;
    }

    public void setValue(Object value) {
        this.m_value = value;
    }

    @Override
    public boolean containsValue(Object value) {
        return value != null && value.equals(this.getValue());
    }

    public static WhereClausePiece makeParamNameValue(String dbCol, String operator, Object paramValue) {
        WhereClausePiece piece = null;
        TaskSearchProperties tsp = Registry.getService(TaskSearchProperties.class);
        if (tsp.getSearchValue("Task.Status").equals(dbCol) && NOT_STARTED.equals(paramValue)) {
            ParamNameValue ready = new ParamNameValue();
            ready.setOperator(operator);
            ready.setDBName(dbCol);
            ready.setValue(TStatus.READY.toString());
            ParamNameValue reserved = new ParamNameValue();
            reserved.setOperator(operator);
            reserved.setDBName(dbCol);
            reserved.setValue(TStatus.RESERVED.toString());
            piece = new WhereClauseOrGroup(ready, reserved);
        } else {
            ParamNameValue pnv = new ParamNameValue();
            pnv.setOperator(operator);
            pnv.setDBName(dbCol);
            pnv.setValue(paramValue);
            piece = pnv;
        }
        return piece;
    }

    @Override
    public int setParameter(Query query, int counter) {
        query.setParameter(NAMED_PARAM + counter++, this.getValue());
        return counter;
    }

    @Override
    public int appendWhereCaluse(StringBuffer statement, int counter) {
        statement.append(this.getDBName()).append(" ");
        statement.append(this.getOperator()).append(" ");
        if (this.m_operator.equals("IN")) {
            statement.append("(");
        }
        statement.append(":").append(NAMED_PARAM).append(counter++);
        if (this.m_operator.equals("IN")) {
            statement.append(")");
        }
        return counter;
    }
}

