/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao;

import com.cognos.jsmcommon.util.XMLUtils;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSPresentationDescription;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSPresentationElements;
import com.ibm.cognos.internal.hts.util.GuidUtils;
import com.ibm.cognos.internal.hts.util.HTMLContentValidator;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.ws_ht.TDescription;
import com.ibm.cognos.internal.hts.ws_ht.TPresentationElements;
import com.ibm.cognos.internal.hts.ws_ht.TText;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;

public class PresentationElementUtils {
    public static Collection<HTSPresentationElements> makePresentationElements(TPresentationElements apiPresElements) {
        HTSPresentationElements pe;
        int i;
        if (apiPresElements == null) {
            return null;
        }
        HashMap<String, HTSPresentationElements> pElements = new HashMap<String, HTSPresentationElements>();
        HTMLContentValidator validator = new HTMLContentValidator();
        for (i = 0; i < apiPresElements.sizeOfDescriptionArray(); ++i) {
            TDescription desc = apiPresElements.getDescriptionArray(i);
            pe = PresentationElementUtils.getPresentationElements(pElements, desc.getLang());
            HTSPresentationDescription pd = new HTSPresentationDescription(desc.getContentType());
            pd.setId(GuidUtils.create());
            String html = HTSSDKUtils.getMixedContent((XmlObject)desc);
            if (validator.getValidationError(html) == null) {
                pd.setDescription(html);
            } else {
                pd.setDescription(XMLUtils.escapeOnce((String)html));
            }
            pe.addDescription(pd);
        }
        for (i = 0; i < apiPresElements.sizeOfNameArray(); ++i) {
            TText name = apiPresElements.getNameArray(i);
            pe = PresentationElementUtils.getPresentationElements(pElements, name.getLang());
            pe.setName(HTSSDKUtils.getText((XmlObject)name));
        }
        for (i = 0; i < apiPresElements.sizeOfSubjectArray(); ++i) {
            TText subject = apiPresElements.getSubjectArray(i);
            pe = PresentationElementUtils.getPresentationElements(pElements, subject.getLang());
            pe.setSubject(HTSSDKUtils.getText((XmlObject)subject));
        }
        return pElements.values();
    }

    private static HTSPresentationElements getPresentationElements(Map<String, HTSPresentationElements> pMap, String lang) {
        HTSPresentationElements pElements = pMap.get(lang);
        if (pElements == null) {
            pElements = new HTSPresentationElements(lang);
            pMap.put(lang, pElements);
        }
        return pElements;
    }
}

