/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao;

import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.dao.MessageUtils;
import com.ibm.cognos.internal.hts.util.pojo.MESSAGE_TYPE;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;

public class StatusUtils {
    public static void _checkStatus(HTSTask task, TStatus.Enum statusEnum, String method) throws HumanTaskServiceException {
        if (!statusEnum.toString().equals(task.getStatus())) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_STATUS, new Object[]{task.getStatus(), method});
        }
    }

    public static void _checkStatus(HTSTask task, TStatus.Enum[] statusEnums, String method) throws HumanTaskServiceException {
        boolean found = false;
        for (int i = 0; i < statusEnums.length; ++i) {
            if (!statusEnums[i].toString().equals(task.getStatus())) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_STATUS, new Object[]{task.getStatus(), method});
        }
    }

    public static void setComplete(HTSTask task) throws HumanTaskServiceException {
        StatusUtils.setStatus(task, TStatus.COMPLETED, null);
    }

    public static void setFail(HTSTask task) throws HumanTaskServiceException {
        StatusUtils.setStatus(task, TStatus.FAILED, null);
    }

    public static void setError(HTSTask task, HumanTaskServiceException error) throws HumanTaskServiceException {
        StatusUtils.setStatus(task, TStatus.ERROR, error);
    }

    public static void setStatus(HTSTask task, TStatus.Enum status, HumanTaskServiceException error) throws HumanTaskServiceException {
        if (TStatus.ERROR.equals(status)) {
            MessageUtils.createMessageInTask(task, error.getFaultMessage(), error.getFaultType().getType(), MESSAGE_TYPE.FAULT);
        }
        task.setStatus(status.toString());
        DAOFactory.getFactory().buildTaskDAO().update(task);
    }
}

