/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao;

import com.cognos.jsmcommon.util.HashList;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.genHandlers.RetryHandler;
import com.ibm.cognos.internal.hts.apiHandlers.genHandlers.SubscriptionUpdateHandler;
import com.ibm.cognos.internal.hts.apiHandlers.genHandlers.TransactionHandler;
import com.ibm.cognos.internal.hts.logicalPeopleGroup.LogicalPeopleGroupSupportFactory;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.TaskDAO;
import com.ibm.cognos.internal.hts.persist.dao.TaskuserDAO;
import com.ibm.cognos.internal.hts.persist.dao.UnSubscriptionDAO;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSHumanRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSUnSubscription;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.GuidUtils;
import com.ibm.cognos.internal.hts.util.cam.UserUtils;
import com.ibm.cognos.internal.hts.util.dao.HumanroleUtils;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.SubscriptionEventState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SubscriptionUtil {
    public static Collection<HTSTaskUser> getSubscriptions(IAbstractContext context, HTSTask task, String event) throws HumanTaskServiceException {
        List<HTSHumanRole> roles = HumanroleUtils.getHumanRoles(task, new HTSRole.Roles[]{HTSRole.Roles.POTENTIAL_OWNERS, HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.BUSINESS_ADMINISTRATORS});
        Set<HTSTaskUser> userList = SubscriptionUtil.expand(context, roles);
        HashSet<HTSTaskUser> unsubscribe = new HashSet<HTSTaskUser>();
        HashSet<HTSTaskUser> subscribe = new HashSet<HTSTaskUser>();
        boolean globalSubscribe = SubscriptionUtil.collectSubscribeAndUnsubscribeEntries(context, task, event, unsubscribe, subscribe);
        Set<HTSTaskUser> excluded = SubscriptionUtil.getExcludedUsers(context, task);
        if (globalSubscribe) {
            userList.removeAll(excluded);
            userList.removeAll(unsubscribe);
        } else {
            subscribe.removeAll(excluded);
            userList = subscribe;
        }
        return userList;
    }

    public static Collection<HTSTaskUser> getUnSubscriptions(IAbstractContext context, HTSTask task, String event) throws HumanTaskServiceException {
        List<HTSHumanRole> roles = HumanroleUtils.getHumanRoles(task, new HTSRole.Roles[]{HTSRole.Roles.POTENTIAL_OWNERS, HTSRole.Roles.TASK_STAKEHOLDERS, HTSRole.Roles.BUSINESS_ADMINISTRATORS, HTSRole.Roles.NOTIFICATION_RECIPIENTS});
        Set<HTSTaskUser> userList = SubscriptionUtil.expand(context, roles);
        HashSet<HTSTaskUser> unsubscribe = new HashSet<HTSTaskUser>();
        HashSet<HTSTaskUser> subscribed = new HashSet<HTSTaskUser>();
        boolean globalSubscribe = SubscriptionUtil.collectSubscribeAndUnsubscribeEntries(context, task, event, unsubscribe, subscribed);
        Set<HTSTaskUser> excluded = SubscriptionUtil.getExcludedUsers(context, task);
        if (globalSubscribe) {
            unsubscribe.addAll(excluded);
            userList = unsubscribe;
        } else {
            userList.addAll(excluded);
            userList.removeAll(subscribed);
            userList.addAll(unsubscribe);
        }
        return userList;
    }

    private static boolean collectSubscribeAndUnsubscribeEntries(IAbstractContext context, HTSTask task, String event, Set<HTSTaskUser> unsubscribe, Set<HTSTaskUser> subscribe) throws HumanTaskServiceException {
        UnSubscriptionDAO subscriptionDAO = DAOFactory.getFactory().buildSubscriptionDAO();
        List<HTSUnSubscription> unsubscriptionsByEvent = subscriptionDAO.findUnSubscriptionUser(task, event);
        boolean globalSubscribe = true;
        for (HTSUnSubscription sub : unsubscriptionsByEvent) {
            if (sub == null) continue;
            SubscriptionEventState.Enum subState = SubscriptionEventState.Enum.forString((String)sub.getSubscriptionState());
            if (SubscriptionEventState.GLOBAL_UNSUBSCRIBE == subState) {
                globalSubscribe = false;
                continue;
            }
            if (SubscriptionEventState.GLOBAL_SUBSCRIBE == subState) {
                globalSubscribe = true;
                continue;
            }
            if (SubscriptionEventState.INDIVIDUAL_UNSUBSCRIBE == subState) {
                unsubscribe.add(sub.getUser());
                continue;
            }
            if (SubscriptionEventState.INDIVIDUAL_SUBSCRIBE != subState) continue;
            subscribe.add(sub.getUser());
        }
        return globalSubscribe;
    }

    public static List<HTSUnSubscription> getMySubscribedEvents(HTSTask task, HTSTaskUser user) {
        UnSubscriptionDAO subscriptionDAO = DAOFactory.getFactory().buildSubscriptionDAO();
        List<HTSUnSubscription> unsubscriptionsByState = subscriptionDAO.findUnSubscriptionsByState(task, user, SubscriptionEventState.INDIVIDUAL_SUBSCRIBE.toString());
        return unsubscriptionsByState;
    }

    public static List<HTSUnSubscription> getMyUnSubscribedEvents(HTSTask task, HTSTaskUser user) {
        UnSubscriptionDAO subscriptionDAO = DAOFactory.getFactory().buildSubscriptionDAO();
        List<HTSUnSubscription> unsubscriptionsByState = subscriptionDAO.findUnSubscriptionsByState(task, user, SubscriptionEventState.INDIVIDUAL_UNSUBSCRIBE.toString());
        return unsubscriptionsByState;
    }

    public static List<HTSUnSubscription> getMyFilteredSubscriptionList(String taskId, String userToken, boolean subscribed) {
        List<HTSUnSubscription> subscriptions = SubscriptionUtil.getMySubscriptionList(taskId, userToken, LogicalPeopleGroupSupportFactory.getInstance().getDefaultLogicalPeopleGroup());
        ArrayList<HTSUnSubscription> filteredSubscriptions = new ArrayList<HTSUnSubscription>();
        for (HTSUnSubscription unSubscription : subscriptions) {
            if (subscribed && (unSubscription.getSubscriptionState().equals(SubscriptionEventState.GLOBAL_SUBSCRIBE.toString()) || unSubscription.getSubscriptionState().equals(SubscriptionEventState.INDIVIDUAL_SUBSCRIBE.toString()))) {
                filteredSubscriptions.add(unSubscription);
                continue;
            }
            if (subscribed || !unSubscription.getSubscriptionState().equals(SubscriptionEventState.GLOBAL_UNSUBSCRIBE.toString()) && !unSubscription.getSubscriptionState().equals(SubscriptionEventState.INDIVIDUAL_UNSUBSCRIBE.toString())) continue;
            filteredSubscriptions.add(unSubscription);
        }
        return filteredSubscriptions;
    }

    public static List<HTSUnSubscription> getMySubscriptionList(String taskId, String userToken, String logicalPeopleGroup) {
        List<Object> unsubscriptions = new ArrayList(0);
        UnSubscriptionDAO subscriptionDAO = DAOFactory.getFactory().buildSubscriptionDAO();
        TaskDAO taskDao = DAOFactory.getFactory().buildTaskDAO();
        HTSTask task = (HTSTask)taskDao.getById(taskId);
        TaskuserDAO taskUserDao = DAOFactory.getFactory().buildTaskuserDAO();
        List<HTSTaskUser> users = taskUserDao.findByUser(userToken = userToken.replace("\\", ""), logicalPeopleGroup);
        if (!users.isEmpty() && task != null) {
            HTSTaskUser user = users.get(0);
            unsubscriptions = subscriptionDAO.findUnSubscriptionsByUser(task, user);
        }
        ArrayList<HTSUnSubscription> writableUnsubscriptions = new ArrayList<HTSUnSubscription>();
        writableUnsubscriptions.addAll(unsubscriptions);
        HashList hList = new HashList();
        for (HTSUnSubscription hTSUnSubscription : unsubscriptions) {
            hList.put((Object)hTSUnSubscription.getEvent(), (Object)hTSUnSubscription);
        }
        for (String string : hList.keySet()) {
            if (hList.getSize((Object)string) <= 1) continue;
            List list = hList.getList((Object)string);
            for (HTSUnSubscription subCheck : list) {
                if (!subCheck.getSubscriptionState().startsWith("GLOBAL")) continue;
                writableUnsubscriptions.remove(subCheck);
            }
        }
        return writableUnsubscriptions;
    }

    public static void doSubscription(SubscriptionEventState.Enum subscribeState, IAbstractContext context, HTSTask task, HTSTaskUser user, String event) throws HumanTaskServiceException {
        SubscriptionUtil.subscribe(context, task, user, event, subscribeState);
    }

    public static HTSUnSubscription makeHTSUnsubscription(String event, String state, HTSTaskUser user, HTSTask task) {
        HTSUnSubscription subscription = new HTSUnSubscription();
        subscription.setId(GuidUtils.create());
        subscription.setEvent(event);
        subscription.setUser(user);
        task.addUnSubscriber(subscription);
        subscription.setSubscriptionState(state);
        return subscription;
    }

    public static void subscribe(IAbstractContext context, HTSTask task, HTSTaskUser user, String event, SubscriptionEventState.Enum subscribeState) throws HumanTaskServiceException {
        if (user != null && SubscriptionUtil.getExcludedUsers(context, task).contains(user)) {
            return;
        }
        if (SubscriptionEventState.GLOBAL_SUBSCRIBE.equals(subscribeState) || SubscriptionEventState.GLOBAL_UNSUBSCRIBE.equals(subscribeState)) {
            user = null;
        }
        HTSUnSubscription subscription = SubscriptionUtil.findUnsubscription(task, user, event);
        if (subscribeState == null) {
            subscribeState = SubscriptionEventState.INDIVIDUAL_UNSUBSCRIBE;
        }
        SubscriptionUpdateHandler transaction = null;
        if (subscription == null) {
            transaction = new SubscriptionUpdateHandler(event, subscribeState.toString(), user, task);
        } else if (!subscribeState.toString().equals(subscription.getSubscriptionState())) {
            transaction = new SubscriptionUpdateHandler(subscription, subscribeState.toString());
        }
        if (transaction != null) {
            new RetryHandler(new TransactionHandler(transaction)).handleRequest(context);
        }
    }

    private static HTSUnSubscription findUnsubscription(HTSTask task, HTSTaskUser user, String event) {
        HTSUnSubscription foundUnsubscription = null;
        List<HTSUnSubscription> unsubscriptions = task.getUnSubscriptions();
        if (unsubscriptions == null) {
            return null;
        }
        boolean matched = false;
        for (HTSUnSubscription unSubscription : unsubscriptions) {
            matched = user == null ? unSubscription.getUser() == null : user.equals(unSubscription.getUser());
            if (matched) {
                matched = event.equals(unSubscription.getEvent());
            }
            if (!matched) continue;
            foundUnsubscription = unSubscription;
            break;
        }
        return foundUnsubscription;
    }

    private static Set<HTSTaskUser> expand(IAbstractContext context, List<HTSHumanRole> roles) throws HumanTaskServiceException {
        HashSet<HTSTaskUser> userList = new HashSet<HTSTaskUser>();
        for (HTSHumanRole hTSHumanRole : roles) {
            HTSTaskUser user = hTSHumanRole.getHtsTaskUser();
            if (user.isGroup()) {
                Set<String> expanded = UserUtils.instance().expandGroup(context, user);
                for (String expandedUser : expanded) {
                    HTSTaskUser transientUser = new HTSTaskUser();
                    transientUser.setUserToken(expandedUser);
                    userList.add(transientUser);
                }
                continue;
            }
            userList.add(user);
        }
        return userList;
    }

    private static Set<HTSTaskUser> getExcludedUsers(IAbstractContext context, HTSTask task) throws HumanTaskServiceException {
        HashSet<HTSTaskUser> userList = new HashSet();
        List<HTSHumanRole> roles = task.getHumanroles(HTSRole.Roles.EXLUDED_OWNERS);
        userList = SubscriptionUtil.expand(context, roles);
        return userList;
    }
}

