/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao;

import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskClassProperty;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskclass;
import com.ibm.cognos.internal.hts.util.GuidUtils;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.PropertiesDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.TProperties;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.TProperty;
import java.util.ArrayList;
import java.util.List;

public class TaskClassPropertyUtil {
    private List<HTSTaskClassProperty> propsList = new ArrayList<HTSTaskClassProperty>();
    private PropertiesDocument propsDoc;

    public TaskClassPropertyUtil(List<HTSTaskClassProperty> properties) {
        this.propsList = properties;
        this.propsDoc = PropertiesDocument.Factory.newInstance();
        TProperties props = this.propsDoc.addNewProperties();
        for (HTSTaskClassProperty taskClassProperty : properties) {
            TProperty prop = props.addNewProperty();
            prop.setName(taskClassProperty.getName());
            prop.setValue(taskClassProperty.getValue());
        }
    }

    public TaskClassPropertyUtil(PropertiesDocument propsDoc) {
        this.propsDoc = propsDoc;
        TProperty[] props = propsDoc.getProperties().getPropertyArray();
        for (int i = 0; i < props.length; ++i) {
            HTSTaskClassProperty tcProperty = new HTSTaskClassProperty();
            tcProperty.setName(props[i].getName());
            tcProperty.setValue(props[i].getValue());
            this.propsList.add(tcProperty);
        }
    }

    public void setTaskClass(HTSTaskclass htsTaskclass) {
        for (HTSTaskClassProperty tcProperty : this.propsList) {
            tcProperty.setId(GuidUtils.create());
        }
    }

    public PropertiesDocument getPropertiesDoc() {
        return this.propsDoc;
    }

    public List<HTSTaskClassProperty> getProperties() {
        return this.propsList;
    }
}

