/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.EnvironmentVar;
import com.cognos.developer.schemas.bibus._3.HdrSession;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.logicalPeopleGroup.LogicalPeopleGroupSupport;
import com.ibm.cognos.internal.hts.persist.dao.Criteria;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.ITransactionHandler;
import com.ibm.cognos.internal.hts.persist.dao.PostDAO;
import com.ibm.cognos.internal.hts.persist.dao.TaskDAO;
import com.ibm.cognos.internal.hts.persist.dao.TaskclassDAO;
import com.ibm.cognos.internal.hts.persist.dao.WhereClause;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSPost;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskclass;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSThread;
import com.ibm.cognos.internal.hts.persist.dao.pojo.types.TaskQuery;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.cam.UserUtils;
import com.ibm.cognos.internal.hts.util.dao.ParamNameValue;
import com.ibm.cognos.internal.hts.util.dao.WhereClausePiece;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TaskUtil {
    public static final String CURRENT_USER_MARKER = "@@CURRENT_USER@@";

    public static void persistTask(HTSTask task) throws HumanTaskServiceException {
        DAOFactory.getFactory().buildTaskDAO().save(task);
    }

    public static List<HTSTask> getAllChildTasks(HTSTask parent) throws HumanTaskServiceException {
        ArrayList<HTSTask> tasks = new ArrayList<HTSTask>();
        List<HTSThread> threads = parent.getHtsThreads();
        for (HTSThread thread : threads) {
            List<HTSPost> posts = thread.getHtsPosts();
            for (HTSPost post : posts) {
                for (HTSTask oneChild : post.getHtsPostTasks()) {
                    tasks.add(oneChild);
                }
            }
        }
        for (HTSTask oneChild : parent.getChildTasks()) {
            tasks.add(oneChild);
        }
        return tasks;
    }

    public static void deleteAllTasks() throws HumanTaskServiceException {
        TaskclassDAO taskClassDAO = DAOFactory.getFactory().buildTaskclassDAO();
        TaskDAO taskDAO = DAOFactory.getFactory().buildTaskDAO();
        List allTaskClasses = taskClassDAO.findAll();
        if (!allTaskClasses.isEmpty()) {
            ITransactionHandler tx = AbstractContext.getCurrentTransactionHandler();
            try {
                tx.beginTransaction();
                for (HTSTaskclass taskclass : allTaskClasses) {
                    List<HTSTask> tasks = taskDAO.findByTaskClass(taskclass);
                    ArrayList<HTSTask> deletedChildren = new ArrayList<HTSTask>();
                    for (HTSTask task : tasks) {
                        if (deletedChildren.contains(task)) continue;
                        deletedChildren.addAll(TaskUtil.deleteAllChildTasks(task));
                        taskDAO.delete(task);
                    }
                }
                tx.commitTransaction();
            }
            catch (RuntimeException ex) {
                tx.rollbackTransaction();
                Utils.throwHumanTaskServiceException(ex);
            }
        }
    }

    public static List<HTSTask> deleteAllChildTasks(HTSTask parent) throws HumanTaskServiceException {
        ArrayList<HTSTask> childs = new ArrayList<HTSTask>();
        TaskUtil.gatherChildrenAndClearReferences(childs, parent);
        TaskUtil.clearParentReferences(parent);
        TaskDAO taskDAO = DAOFactory.getFactory().buildTaskDAO();
        for (int i = childs.size() - 1; i >= 0; --i) {
            taskDAO.delete(childs.get(i));
        }
        return childs;
    }

    public static void clearParentReferences(HTSTask task) {
        PostDAO postDao = DAOFactory.getFactory().buildUspostDAO();
        List<HTSPost> parentPosts = postDao.findParentPosts(task.getId());
        for (HTSPost parentPost : parentPosts) {
            parentPost.getHtsPostTasks().remove(task);
        }
        TaskDAO taskDao = DAOFactory.getFactory().buildTaskDAO();
        List<HTSTask> parents = taskDao.findParentTask(task.getId());
        for (HTSTask parent : parents) {
            parent.getChildTasks().remove(task);
        }
    }

    public static void checkForRecursion(HTSTask parent, HTSTask newChildtask) throws HumanTaskServiceException {
        List<HTSTask> childs = TaskUtil.getAllChildTasks(newChildtask);
        childs.add(newChildtask);
        for (HTSTask child : childs) {
            if (child == null || !child.equals(parent)) continue;
            throw new HumanTaskServiceException(UsI18NCode.MSG_HTS_TASK_RECURSION, new Object[]{parent.getId(), newChildtask.getId()});
        }
    }

    public static void gatherChildrenAndClearReferences(List<HTSTask> childs, HTSTask parent) {
        List<HTSThread> threads = parent.getHtsThreads();
        for (HTSThread thread : threads) {
            List<HTSPost> posts = thread.getHtsPosts();
            if (posts == null) continue;
            for (HTSPost post : posts) {
                if (post.getHtsPostTasks() == null) continue;
                childs.addAll(post.getHtsPostTasks());
                for (HTSTask task : post.getHtsPostTasks()) {
                    TaskUtil.gatherChildrenAndClearReferences(childs, task);
                }
                post.getHtsPostTasks().clear();
            }
        }
        childs.addAll(parent.getChildTasks());
        if (parent.getChildTasks() != null) {
            for (HTSTask task : parent.getChildTasks()) {
                TaskUtil.gatherChildrenAndClearReferences(childs, task);
            }
            parent.getChildTasks().clear();
        }
    }

    public static void updateTask(HTSTask task) throws HumanTaskServiceException {
        DAOFactory.getFactory().buildTaskDAO().update(task);
    }

    public static List<HTSTask> getMyRoleTasks(TaskQuery type, HTSTaskUser currentUser) throws HumanTaskServiceException {
        return TaskUtil.getMyRoleTasks(type, currentUser, null);
    }

    public static List<HTSTask> getMyTasksForCm(TaskQuery type, IAbstractContext context, Criteria criteria) throws HumanTaskServiceException {
        TaskDAO taskDao = DAOFactory.getFactory().buildTaskDAO();
        LogicalPeopleGroupSupport cmSupport = UserUtils.instance().getPeopleGroupSupport("CM", context.getHeader().getBiBusHeader());
        HashSet<String> cmStoreIds = new HashSet<String>();
        WhereClause santa = criteria.getWhereClause();
        List<WhereClausePiece> pnvs = santa.getClauses();
        ArrayList<ParamNameValue> cmStoreIdClauses = new ArrayList<ParamNameValue>();
        for (WhereClausePiece wcp : pnvs) {
            ParamNameValue paramNameValue = null;
            if (wcp instanceof ParamNameValue) {
                paramNameValue = (ParamNameValue)wcp;
            }
            if (paramNameValue == null || !"Task.CmStoreId".equals(paramNameValue.getDBName())) continue;
            cmStoreIdClauses.add(paramNameValue);
        }
        for (ParamNameValue storeIdClause : cmStoreIdClauses) {
            try {
                santa.remove(storeIdClause);
                Set<String> checkedStoreIdList = cmSupport.getGroups(String.valueOf(storeIdClause.getValue()), context);
                cmStoreIds.addAll(checkedStoreIdList);
            }
            catch (Exception e) {
                Utils.throwHumanTaskServiceException(e, UsI18NCode.MSG_US_INVALID_PARAMETER, new Object[]{"Task.CmStoreId", storeIdClause, context.getOperationName()});
            }
        }
        return taskDao.findByCriteriaForUsers(criteria, cmStoreIds, context.getUsTaskUser());
    }

    public static List<HTSTask> getMyRoleTasks(TaskQuery type, IAbstractContext context, String whereClause) throws HumanTaskServiceException {
        Criteria criteria = DAOFactory.getFactory().buildTaskDAO().buildCriteria();
        criteria.getWhereClause().parseWhereClause(whereClause);
        return TaskUtil.getMyRoleTasks(type, context, criteria);
    }

    public static List<HTSTask> getMyRoleTasks(TaskQuery type, IAbstractContext context, Criteria criteria) throws HumanTaskServiceException {
        HTSTaskUser currentUser = context.getUsTaskUser();
        Set<String> additionaluserTokens = context.getCurrentUserRolesAndGroups();
        return TaskUtil.getMyRoleTasks(type, currentUser, additionaluserTokens, criteria);
    }

    public static List<HTSTask> getMyRoleTasks(TaskQuery type, HTSTaskUser currentUser, Set<String> additionalUserTokens, String whereClause) throws HumanTaskServiceException {
        Criteria criteria = DAOFactory.getFactory().buildTaskDAO().buildCriteria();
        criteria.getWhereClause().parseWhereClause(whereClause, new String[]{CURRENT_USER_MARKER}, new String[]{currentUser.getUserToken()});
        return TaskUtil.getMyRoleTasks(type, currentUser, additionalUserTokens, criteria);
    }

    public static List<HTSTask> getMyRoleTasks(TaskQuery type, HTSTaskUser currentUser, Set<String> additionalUserTokens) throws HumanTaskServiceException {
        return TaskUtil.getMyRoleTasks(type, currentUser, additionalUserTokens, DAOFactory.getFactory().buildTaskDAO().buildCriteria());
    }

    public static List<HTSTask> getMyRoleTasks(TaskQuery type, HTSTaskUser currentUser, Set<String> additionalUserTokens, Criteria criteria) throws HumanTaskServiceException {
        TaskDAO taskDao = DAOFactory.getFactory().buildTaskDAO();
        List<HTSTask> tasks = null;
        if (currentUser == null) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_USER_DATA, new Object[]{currentUser});
        }
        if (additionalUserTokens == null) {
            additionalUserTokens = new HashSet<String>();
        }
        additionalUserTokens.add(currentUser.getUserToken());
        if (type == null) {
            type = TaskQuery.ALL;
        }
        if (!type.equals((Object)TaskQuery.ALL)) {
            criteria.getWhereClause().addWhereClause("Task.Type", "=", TaskUtil.mapType(type).name());
        }
        tasks = taskDao.findByCriteriaForUsers(criteria, additionalUserTokens, currentUser);
        return tasks;
    }

    public static Calendar convertToCalendar(Number number) {
        GregorianCalendar cal = null;
        if (number != null) {
            cal = new GregorianCalendar();
            long longValue = number.longValue();
            Date date = new Date(longValue);
            cal.setTime(date);
        }
        return cal;
    }

    private static HTSTask.TYPE mapType(TaskQuery type) {
        Object taskType = null;
        taskType = type.equals((Object)TaskQuery.TASKS) ? HTSTask.TYPE.TASK : (type.equals((Object)TaskQuery.ALL) ? null : HTSTask.TYPE.NOTIFICATION);
        return taskType;
    }

    static String[] appendArray(String[] array, String[] newArray) {
        if (array == null) {
            array = new String[]{};
        }
        if (newArray == null) {
            return array;
        }
        String[] appendedArray = new String[newArray.length + array.length];
        System.arraycopy(array, 0, appendedArray, 0, array.length);
        System.arraycopy(newArray, 0, appendedArray, array.length, newArray.length);
        return appendedArray;
    }

    public static int getMyInboxListSize() {
        int intMyInboxListSize = -1;
        try {
            CRNProperties crnProperties = CRNProperties.getInstance();
            String intVal = crnProperties.getProperty("htsMyinboxListSize");
            if (intVal != null && intVal.length() > 0) {
                Integer myInboxListSize = Integer.valueOf(intVal);
                if (myInboxListSize != null && myInboxListSize > 0) {
                    intMyInboxListSize = myInboxListSize;
                } else {
                    Utils.debug("Invalid property set for [htsMyinboxListSize]. Value must be greater than 0.");
                }
            }
        }
        catch (PropertiesException e) {
            Utils.debug("Error retrieving property [htsMyinboxListSize]: " + e.getMessage());
        }
        catch (NumberFormatException e) {
            Utils.debug("Invalid property set for [htsMyinboxListSize]: " + e.getMessage());
        }
        catch (Exception ex) {
            Utils.debug("Invalid property set for [htsMyinboxListSize]: " + ex.getMessage());
        }
        return intMyInboxListSize;
    }

    public static int getMyInboxListSize(IAbstractContext context) {
        int myInboxListSize = -1;
        try {
            myInboxListSize = TaskUtil.isCallFromInboxFeed(context) ? TaskUtil.getMyInboxListSizeForInboxFeed() : TaskUtil.getMyInboxListSize();
        }
        catch (Exception ex) {
            Utils.debug("TaskUtil : getMyInboxListSize : Error getting My Inbox List Size " + ex.getMessage());
        }
        return myInboxListSize;
    }

    public static int getMyInboxListSizeForInboxFeed() {
        int intMyInboxListSizeForInboxFeed = -1;
        try {
            CRNProperties crnProperties = CRNProperties.getInstance();
            String intVal = crnProperties.getProperty("htsMyinboxListSizeForInboxFeed");
            if (intVal != null && intVal.length() > 0) {
                Integer myInboxListSizeForInboxFeed = Integer.valueOf(intVal);
                if (myInboxListSizeForInboxFeed != null && myInboxListSizeForInboxFeed > 0) {
                    intMyInboxListSizeForInboxFeed = myInboxListSizeForInboxFeed;
                } else {
                    Utils.debug("Invalid property set for [htsMyinboxListSizeForInboxFeed]. Value must be greater than 0.");
                }
            }
        }
        catch (PropertiesException e) {
            Utils.debug("Error retrieving property [htsMyinboxListSizeForInboxFeed]: " + e.getMessage());
        }
        catch (NumberFormatException e) {
            Utils.debug("Invalid property set for [htsMyinboxListSizeForInboxFeed]: " + e.getMessage());
        }
        catch (Exception ex) {
            Utils.debug("Invalid property set for [htsMyinboxListSizeForInboxFeed]: " + ex.getMessage());
        }
        return intMyInboxListSizeForInboxFeed;
    }

    public static int getUpdateInboxFetchSize() {
        return TaskUtil.getMyInboxListSize() * 2;
    }

    public static int getUpdateInboxFetchSize(IAbstractContext context) {
        int updateInboxFetchSize = -1;
        try {
            updateInboxFetchSize = TaskUtil.getMyInboxListSize(context) * 2;
        }
        catch (Exception ex) {
            Utils.debug("TaskUtil : getUpdateInboxFetchSize : Error getting updateInboxFetchSize " + ex.getMessage());
        }
        return updateInboxFetchSize;
    }

    public static boolean isCallFromInboxFeed(IAbstractContext context) {
        boolean isCallFromInboxFeed;
        block3: {
            isCallFromInboxFeed = false;
            try {
                EnvironmentVar[] envVars;
                HdrSession hdrSession;
                BiBusHeader biBusHeader;
                if (context == null || (biBusHeader = context.getHeader().getBiBusHeader()) == null || (hdrSession = biBusHeader.getHdrSession()) == null) break block3;
                for (EnvironmentVar envVar : envVars = hdrSession.getEnvironmentVars()) {
                    if (!"PATH_INFO".equalsIgnoreCase(envVar.getName()) || !"/rds/inboxfeed".equalsIgnoreCase(envVar.getValue())) continue;
                    isCallFromInboxFeed = true;
                    break;
                }
            }
            catch (Exception ex) {
                Utils.debug("TaskUtil : isCallFromInboxFeed : Error " + ex.getMessage());
            }
        }
        return isCallFromInboxFeed;
    }
}

