/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao;

import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.ITransactionHandler;
import com.ibm.cognos.internal.hts.persist.dao.TaskDAO;
import com.ibm.cognos.internal.hts.persist.dao.TaskclassDAO;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskclass;
import com.ibm.cognos.internal.hts.persist.dao.pojo.PojoCache;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.service.ws_ht.HandlerMapFactory;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.dao.TaskUtil;
import java.util.ArrayList;
import java.util.List;

public class TaskclassUtil {
    public static final String OPERATION = "operation";
    public static final String PORT_TYPE = "portType";

    public static List<HTSTaskclass> getTaskClass(String portType, String operation) {
        TaskclassDAO dao = DAOFactory.getFactory().buildTaskclassDAO();
        return dao.findLatestByCriteria(portType, operation);
    }

    public static List<HTSTaskclass> getTaskClass(String uniqueName) {
        TaskclassDAO dao = DAOFactory.getFactory().buildTaskclassDAO();
        return dao.findLatestByName(uniqueName);
    }

    public static List<HTSTaskclass> getTaskClassOfVersion(String uniqueName, String version) {
        TaskclassDAO dao = DAOFactory.getFactory().buildTaskclassDAO();
        return dao.findByName(uniqueName, version);
    }

    public static List<HTSTaskclass> getTaskClasses() {
        TaskclassDAO dao = DAOFactory.getFactory().buildTaskclassDAO();
        return dao.findAll();
    }

    public static void storeTaskClass(HTSTaskclass taskclass) throws HumanTaskServiceException {
        TaskclassDAO dao = DAOFactory.getFactory().buildTaskclassDAO();
        try {
            dao.save(taskclass);
            HandlerMapFactory.getHandlerMap().registerTaskClass(taskclass);
        }
        catch (RuntimeException ex) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_SERVICE_PERSIST_ERROR, new Object[]{ex});
        }
    }

    public static void deleteAllTaskClasses() throws HumanTaskServiceException {
        TaskclassDAO taskClassDAO = DAOFactory.getFactory().buildTaskclassDAO();
        TaskDAO taskDAO = DAOFactory.getFactory().buildTaskDAO();
        List allTaskClasses = taskClassDAO.findAll();
        if (!allTaskClasses.isEmpty()) {
            ITransactionHandler tx = AbstractContext.getCurrentTransactionHandler();
            try {
                tx.beginTransaction();
                for (HTSTaskclass taskclass : allTaskClasses) {
                    List<HTSTask> tasks = taskDAO.findByTaskClass(taskclass);
                    ArrayList<HTSTask> deletedChildren = new ArrayList<HTSTask>();
                    for (HTSTask task : tasks) {
                        if (deletedChildren.contains(task)) continue;
                        deletedChildren.addAll(TaskUtil.deleteAllChildTasks(task));
                        taskDAO.delete(task);
                    }
                    taskClassDAO.delete(taskclass);
                }
                tx.commitTransaction();
            }
            catch (RuntimeException ex) {
                tx.rollbackTransaction();
                Utils.throwHumanTaskServiceException(ex);
            }
        }
        PojoCache.clear();
    }
}

