/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao.builder;

import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSPost;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSThread;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.GuidUtils;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.CommentType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class AbstractCommentBuilder {
    private HTSPost m_parentPost;
    private HTSPost builtPost;

    public abstract HTSTaskUser getTaskUser() throws HumanTaskServiceException;

    public abstract HTSTask getUsTask();

    public abstract CommentType.Enum getThreadType();

    public HTSThread getThread() {
        List<HTSThread> threads = this.getUsTask().getHtsThreads();
        HTSThread thread = null;
        for (HTSThread hTSThread : threads) {
            if (!hTSThread.getType().equals(this.getThreadType().toString())) continue;
            thread = hTSThread;
            break;
        }
        if (thread == null) {
            thread = this.makeThread();
        }
        return thread;
    }

    public void setParentPost(HTSPost parent) {
        this.m_parentPost = parent;
    }

    public HTSPost getParentPost() {
        return this.m_parentPost;
    }

    protected HTSThread makeThread() {
        HTSThread thread = new HTSThread();
        thread.setCreateDate(new Date().getTime());
        thread.setId(GuidUtils.create());
        thread.setVisible(Boolean.TRUE);
        thread.setHtsPosts(new ArrayList<HTSPost>());
        thread.setOpen(Boolean.TRUE);
        thread.setReplycount(0);
        this.getUsTask().addHTSThread(thread);
        return thread;
    }

    public HTSPost getPost() throws HumanTaskServiceException {
        this.builtPost = new HTSPost();
        this.builtPost.setHtsPostTasks(new ArrayList<HTSTask>());
        this.builtPost.setCreateDate(new Date().getTime());
        this.builtPost.setId(GuidUtils.create());
        this.builtPost.setParentHtsPost(this.m_parentPost);
        this.builtPost.setSticky(Boolean.FALSE);
        this.builtPost.setVisible(Boolean.TRUE);
        this.builtPost.setHtsTaskUser(this.getTaskUser());
        return this.builtPost;
    }

    public HTSPost getBuiltPost() {
        return this.builtPost;
    }

    public HTSPost getParentPost(List<HTSPost> arrayList) {
        if (this.getParentPost() != null) {
            return this.getParentPost();
        }
        HTSPost result = null;
        if (arrayList != null) {
            for (HTSPost post : arrayList) {
                if (post.getParentHtsPost() != null) continue;
                result = post;
            }
        }
        return result;
    }
}

