/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao.builder;

import com.ibm.cognos.internal.hts.apiHandlers.context.AbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSDeadlineInstance;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSFolder;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSHumanRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSMessage;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSPresentationElements;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskclass;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.GuidUtils;
import com.ibm.cognos.internal.hts.util.HTMLContentValidator;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.dao.builder.DeadlineInstanceBuilder;
import com.ibm.cognos.internal.hts.util.dao.builder.PresentationElementsBuilder;
import com.ibm.cognos.internal.hts.util.perf.HtsPerfData;
import com.ibm.cognos.internal.hts.util.pojo.MESSAGE_TYPE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public abstract class AbstractTaskBuilder {
    protected HTSTask task = null;
    protected ArrayList<HTSHumanRole> roles = new ArrayList();
    protected ArrayList<HTSPresentationElements> presentationElements = new ArrayList();
    private HTSMessage message = null;
    protected String instanceOperation;
    protected HtsPerfData perfData;

    protected AbstractTaskBuilder() {
        this.task = new HTSTask();
        this.task.setId(GuidUtils.create());
    }

    public HTSTask getUsTask() {
        return this.task;
    }

    public void setPerfData(HtsPerfData perfData) {
        this.perfData = perfData;
    }

    public HTSTaskclass findClass(String interfaceOperation) {
        return AbstractContext.getPojoCache().getLatestTaskClass(interfaceOperation);
    }

    public void setActualOwner(HTSTaskUser user) {
        this.task.setActualOwner(user);
    }

    public void setCreatedBy(HTSTaskUser user) {
        this.task.setCreatedBy(user);
    }

    public void setCreatedOn(long time) {
        this.task.setCreatedOn(time);
    }

    public void setName(String name) {
        this.task.setName(name);
    }

    public void setPriority(int priority) {
        this.task.setPriority(priority);
    }

    public void setRoles(List<HTSHumanRole> roles) {
        for (HTSHumanRole hTSHumanRole : roles) {
            hTSHumanRole.setHtsTask(this.task);
            hTSHumanRole.setId(GuidUtils.create());
            this.roles.add(hTSHumanRole);
        }
    }

    public void setFolders(List<HTSFolder> folders) {
        this.task.setFolders(folders);
    }

    public void setPresentationElements(Collection<HTSPresentationElements> presentationElements) {
        if (presentationElements == null) {
            return;
        }
        for (HTSPresentationElements pe : presentationElements) {
            this.task.addHTSPresentationElements(pe);
            if (pe.getId() == null) {
                pe.setId(GuidUtils.create());
            }
            this.presentationElements.add(pe);
        }
    }

    public void setMessage(String inputXML) {
        this.message = new HTSMessage();
        this.message.setMessage(inputXML);
        this.message.setMessageType(MESSAGE_TYPE.INPUT.name());
        this.message.setId(GuidUtils.create());
        this.message.setTask(this.task);
        ArrayList<HTSMessage> msgList = new ArrayList<HTSMessage>();
        msgList.add(this.message);
        this.task.setHtsMessages(msgList);
    }

    public void setTaskClass(String instanceOperation) throws HumanTaskServiceException {
        this.instanceOperation = instanceOperation;
        HTSTaskclass tc = this.findClass(instanceOperation);
        if (tc == null) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_INVALID_OPERATION_NAME, new Object[]{instanceOperation});
        }
        this.task.setOperation(tc.getOperation());
        this.task.setTaskClassVersion(tc.getVersionId());
        this.task.setTaskType(tc.getTaskType());
        this.task.getHtsTaskclass();
    }

    public HTSTask buildTask() throws HumanTaskServiceException {
        if (this.task.getId() == null) {
            this.task.setId(GuidUtils.create());
        }
        if (this.task.getTimezone() == null) {
            this.task.setTimezone(TimeZone.getDefault().getID());
        }
        this.validateRoles();
        for (HTSHumanRole role : this.roles) {
            role.setHtsTask(this.task);
        }
        this.task.setHtsHumanRoles(this.roles);
        DeadlineInstanceBuilder builder = new DeadlineInstanceBuilder(this.task);
        List<HTSDeadlineInstance> deadlineInstances = builder.getDeadlineInstances();
        this.task.setHtsDeadlineInstances(deadlineInstances);
        this.setStatus();
        PresentationElementsBuilder presBuilder = new PresentationElementsBuilder(this.task);
        HTMLContentValidator validator = new HTMLContentValidator();
        String validationError = validator.getValidationError(presBuilder.getDescription("text/html", Locale.getDefault().getLanguage()));
        String subjectValidationError = validator.getValidationError(presBuilder.getSubject(Locale.getDefault().getLanguage()));
        if (validationError == null) {
            validationError = subjectValidationError;
        } else if (subjectValidationError != null) {
            validationError = validationError + subjectValidationError;
        }
        if (validationError != null) {
            Utils.throwHumanTaskServiceException(UsI18NCode.MSG_US_SERVICE_VALIDATION_ERROR, new Object[]{"", validationError});
        }
        return this.task;
    }

    protected void validateRoles() throws HumanTaskServiceException {
        HTSHumanRole minRole = null;
        for (HTSHumanRole role : this.roles) {
            if (HTSRole.Roles.TASK_STAKEHOLDERS.getRole().equals(role.getHtsRole().getRole())) {
                minRole = role;
                break;
            }
            if (HTSRole.Roles.POTENTIAL_OWNERS.getRole().equals(role.getHtsRole().getRole())) {
                minRole = role;
                break;
            }
            if (!HTSRole.Roles.NOTIFICATION_RECIPIENTS.getRole().equals(role.getHtsRole().getRole())) continue;
            minRole = role;
            break;
        }
        if (minRole == null) {
            Utils.throwHumanTaskServiceException(UsI18NCode.MSG_US_MINIMUM_ROLES, new Object[0]);
        }
    }

    public void setDefaultLocale(String defaultLocale) {
        this.task.setDefaultLocale(defaultLocale);
    }

    public abstract void setStatus();
}

