/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao.builder;

import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSDeadline;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSEscalation;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSEscalationHumanRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSEscalationToPart;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSImport;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSLocalNotification;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSPresentationElementsDesc;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSPresentationElementsName;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSPresentationElementsParams;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSPresentationElementsSubj;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRendering;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskPurgeConstraint;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskSubscription;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskclass;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.GuidUtils;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.util.dao.humanrole.EscalationHumanRoleOrganizationalEntityConverter;
import com.ibm.cognos.internal.hts.ws_ht.TDeadline;
import com.ibm.cognos.internal.hts.ws_ht.TDeadlines;
import com.ibm.cognos.internal.hts.ws_ht.TDescription;
import com.ibm.cognos.internal.hts.ws_ht.TEscalation;
import com.ibm.cognos.internal.hts.ws_ht.TImport;
import com.ibm.cognos.internal.hts.ws_ht.TLocalNotification;
import com.ibm.cognos.internal.hts.ws_ht.TPeopleAssignments;
import com.ibm.cognos.internal.hts.ws_ht.TPresentationElements;
import com.ibm.cognos.internal.hts.ws_ht.TPresentationParameter;
import com.ibm.cognos.internal.hts.ws_ht.TPresentationParameters;
import com.ibm.cognos.internal.hts.ws_ht.TRendering;
import com.ibm.cognos.internal.hts.ws_ht.TRenderings;
import com.ibm.cognos.internal.hts.ws_ht.TTask;
import com.ibm.cognos.internal.hts.ws_ht.TText;
import com.ibm.cognos.internal.hts.ws_ht.TToPart;
import com.ibm.cognos.internal.hts.ws_ht.TToParts;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.PurgeConstraintImpl;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.PurgeConstraintsDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.StateChangeImpl;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.StateChangesDocument;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlObject;

public class AbstractTaskclassBuilder {
    protected List<HTSRendering> addRenderings(TRenderings renderings, HTSTaskclass taskclass) throws HumanTaskServiceException {
        ArrayList<HTSRendering> list = new ArrayList<HTSRendering>();
        if (renderings != null && renderings.getRenderingArray() != null) {
            TRendering[] renderingArr = renderings.getRenderingArray();
            for (int i = 0; i < renderingArr.length; ++i) {
                TRendering tRendering = renderingArr[i];
                HTSRendering rendering = this.makeRendering(tRendering, taskclass);
                list.add(rendering);
            }
        }
        taskclass.setHtsRenderings(list);
        return list;
    }

    protected void addImports(HTSTaskclass taskclass, TImport[] imports) {
        for (int i = 0; imports != null && i < imports.length; ++i) {
            TImport anImport = imports[i];
            HTSImport importPojo = new HTSImport();
            importPojo.setId(GuidUtils.create());
            importPojo.setImportType(anImport.getImportType());
            importPojo.setLocation(anImport.getLocation());
            importPojo.setNamespace(anImport.getNamespace());
            taskclass.addImport(importPojo);
        }
    }

    protected void setPresentationElements(HTSTaskclass taskclass, TPresentationElements tPresElems) {
        taskclass.setParamsExpressionLanguage("xpath_1.0");
        this.setPENames(taskclass, tPresElems);
        this.setPESubjects(taskclass, tPresElems);
        this.setPEDescriptions(taskclass, tPresElems);
        this.setPEParams(taskclass, tPresElems);
    }

    protected void setPEParams(HTSTaskclass taskclass, TPresentationElements tPresElems) {
        TPresentationParameter[] paramsArray;
        TPresentationParameters presParams = tPresElems.getPresentationParameters();
        if (presParams != null && (paramsArray = presParams.getPresentationParameterArray()) != null && paramsArray.length > 0) {
            ArrayList<HTSPresentationElementsParams> paramsList = new ArrayList<HTSPresentationElementsParams>();
            for (int i = 0; i < paramsArray.length; ++i) {
                HTSPresentationElementsParams param = new HTSPresentationElementsParams();
                param.setId(GuidUtils.create());
                param.setName(paramsArray[i].getName());
                param.setType(paramsArray[i].getType().getLocalPart());
                param.setExpression(HTSSDKUtils.getText((XmlObject)paramsArray[i]));
                paramsList.add(param);
            }
            taskclass.setHtsPresentationElementsParams(paramsList);
        }
    }

    protected void setPEDescriptions(HTSTaskclass taskclass, TPresentationElements tPresElems) {
        TDescription[] descArray = tPresElems.getDescriptionArray();
        if (descArray != null && descArray.length > 0) {
            ArrayList<HTSPresentationElementsDesc> descList = new ArrayList<HTSPresentationElementsDesc>();
            for (int i = 0; i < descArray.length; ++i) {
                HTSPresentationElementsDesc desc = new HTSPresentationElementsDesc();
                desc.setId(GuidUtils.create());
                desc.setLang(descArray[i].getLang());
                String content = descArray[i].getContentType();
                content = content == null || content.length() == 0 ? "text/plain" : content;
                desc.setContentType(descArray[i].getContentType());
                desc.setDescription(HTSSDKUtils.getText((XmlObject)descArray[i]));
                descList.add(desc);
            }
            taskclass.setHtsPresentationElementsDescs(descList);
        }
    }

    protected void setPESubjects(HTSTaskclass taskclass, TPresentationElements tPresElems) {
        TText[] subjArray = tPresElems.getSubjectArray();
        if (subjArray != null && subjArray.length > 0) {
            ArrayList<HTSPresentationElementsSubj> subjList = new ArrayList<HTSPresentationElementsSubj>();
            for (int i = 0; i < subjArray.length; ++i) {
                HTSPresentationElementsSubj subj = new HTSPresentationElementsSubj();
                subj.setId(GuidUtils.create());
                subj.setLang(subjArray[i].getLang());
                subj.setSubject(HTSSDKUtils.getText((XmlObject)subjArray[i]));
                subjList.add(subj);
            }
            taskclass.setHtsPresentationElementsSubjs(subjList);
        }
    }

    protected void setPENames(HTSTaskclass taskclass, TPresentationElements tPresElems) {
        TText[] nameArray = tPresElems.getNameArray();
        if (nameArray != null && nameArray.length > 0) {
            ArrayList<HTSPresentationElementsName> namesList = new ArrayList<HTSPresentationElementsName>();
            for (int i = 0; i < nameArray.length; ++i) {
                HTSPresentationElementsName name = new HTSPresentationElementsName();
                name.setId(GuidUtils.create());
                name.setLang(nameArray[i].getLang());
                name.setName(HTSSDKUtils.getText((XmlObject)nameArray[i]));
                namesList.add(name);
            }
            taskclass.setHtsPresentationElementsNames(namesList);
        }
    }

    protected HTSRendering makeRendering(TRendering tRendering, HTSTaskclass taskclass) throws HumanTaskServiceException {
        HTSRendering rendering = new HTSRendering();
        rendering.setId(GuidUtils.create());
        try {
            String uri = HTSSDKUtils.getRenderingUri((XmlObject)tRendering);
            if (uri == null) {
                String value = HTSSDKUtils.getRenderingValue((XmlObject)tRendering);
                if (value != null) {
                    rendering.setRenderValue(value);
                }
            } else {
                rendering.setRenderUri(uri.trim());
            }
            rendering.setTypeQName(tRendering.getType());
            rendering.setTypeNamespace(tRendering.getType().getNamespaceURI());
            rendering.setTypePrefix(tRendering.getType().getPrefix());
        }
        catch (Exception ex) {
            throw new HumanTaskServiceException(UsI18NCode.MSG_US_MISSING_URI, new Object[]{taskclass.getName()}, ex);
        }
        return rendering;
    }

    protected void addDeadlines(HTSTaskclass taskClass, TDeadlines deadlines) throws HumanTaskServiceException {
        if (deadlines == null) {
            return;
        }
        TDeadline[] completionDeadlines = deadlines.getCompletionDeadlineArray();
        this.addDeadlines(taskClass, completionDeadlines, HTSDeadline.DEADLINE_TYPE.COMPLETE);
        TDeadline[] startDeadlines = deadlines.getStartDeadlineArray();
        this.addDeadlines(taskClass, startDeadlines, HTSDeadline.DEADLINE_TYPE.START);
    }

    protected void addDeadlines(HTSTaskclass taskClass, TDeadline[] deadlines, HTSDeadline.DEADLINE_TYPE deadlineType) throws HumanTaskServiceException {
        for (int i = 0; deadlines != null && i < deadlines.length; ++i) {
            HTSDeadline deadline = new HTSDeadline();
            deadline.setId(GuidUtils.create());
            deadline.setHtsDeadlinetype(deadlineType.name());
            if (deadlines[i].getFor() != null) {
                deadline.setTimeForExpression(HTSSDKUtils.getText((XmlObject)deadlines[i].getFor()));
            } else if (deadlines[i].getUntil() != null) {
                deadline.setTimeUntilExpression(HTSSDKUtils.getText((XmlObject)deadlines[i].getUntil()));
            }
            List<HTSEscalation> deadlineEscalations = this.makeEscalations(deadlines[i].getEscalationArray(), deadline);
            deadline.setEscalations(deadlineEscalations);
            taskClass.addHTSDeadline(deadline);
        }
    }

    protected List<HTSEscalation> makeEscalations(TEscalation[] escalations, HTSDeadline deadLine) throws HumanTaskServiceException {
        ArrayList<HTSEscalation> escalationPojos = new ArrayList<HTSEscalation>();
        for (int i = 0; i < escalations.length; ++i) {
            String conditionExpression = HTSSDKUtils.getText((XmlObject)escalations[i].getCondition());
            TLocalNotification notification = escalations[i].getLocalNotification();
            HTSEscalation escalationPojo = this.makeEscalation(conditionExpression, notification);
            escalationPojos.add(escalationPojo);
        }
        return escalationPojos;
    }

    protected HTSEscalation makeEscalation(String conditionExpression, TLocalNotification notification) throws HumanTaskServiceException {
        HTSEscalation escalationPojo = new HTSEscalation();
        escalationPojo.setId(GuidUtils.create());
        escalationPojo.setConditionExpression(conditionExpression.trim());
        if (notification != null) {
            String localNotificationQNameReference = notification.getReference().toString();
            HTSLocalNotification localNotification = new HTSLocalNotification();
            localNotification.setLocalNotification(localNotificationQNameReference);
            localNotification.setId(GuidUtils.create());
            escalationPojo.setHtsLocalNotification(localNotification);
            this.addEscalationHumanRoles(escalationPojo, notification.getPeopleAssignments());
        }
        return escalationPojo;
    }

    protected void addEscalationHumanRoles(HTSEscalation escalationPojo, TPeopleAssignments peopleAssignments) throws HumanTaskServiceException {
        EscalationHumanRoleOrganizationalEntityConverter humanRoleConverter = new EscalationHumanRoleOrganizationalEntityConverter(null);
        List stateChangeHumanRoles = humanRoleConverter.processPeopleAssignments(new TPeopleAssignments[]{peopleAssignments});
        for (HTSEscalationHumanRole hTSEscalationHumanRole : stateChangeHumanRoles) {
            hTSEscalationHumanRole.setId(GuidUtils.create());
            escalationPojo.getHtsLocalNotification().addHTSEscalationHumanRole(hTSEscalationHumanRole);
        }
    }

    protected void addEscalationToParts(HTSEscalation escalationPojo, TToParts stateChangeToParts) {
        for (int i = 0; i < stateChangeToParts.sizeOfToPartArray(); ++i) {
            TToPart toPart = stateChangeToParts.getToPartArray(i);
            String name = toPart.getName();
            String toPartExpression = HTSSDKUtils.getText((XmlObject)toPart);
            HTSEscalationToPart toPartPojo = new HTSEscalationToPart();
            toPartPojo.setId(GuidUtils.create());
            toPartPojo.setExpression(toPartExpression);
            toPartPojo.setName(name);
            escalationPojo.getHtsLocalNotification().addHTSEscalationToPart(toPartPojo);
        }
    }

    protected void addTaskSubscriptions(XmlObject task, HTSTaskclass taskclass) throws HumanTaskServiceException {
        HTSTaskSubscription.TASK_SUBSCRIPTIONS[] types = HTSTaskSubscription.TASK_SUBSCRIPTIONS.values();
        ArrayList<HTSTaskSubscription> taskSubscriptions = new ArrayList<HTSTaskSubscription>();
        for (int i = 0; i < types.length; ++i) {
            String type = types[i].getSubscription();
            String subscriptionExpression = HTSSDKUtils.getTaskSubscriptions(task, type);
            if (subscriptionExpression == null) continue;
            HTSTaskSubscription htsSubscription = new HTSTaskSubscription();
            htsSubscription.setId(GuidUtils.create());
            htsSubscription.setSubscriptionExpression(subscriptionExpression);
            htsSubscription.setType(types[i].toString());
            taskSubscriptions.add(htsSubscription);
        }
        taskclass.setTaskSubscriptions(taskSubscriptions);
    }

    protected void addTaskIcon(TTask task, HTSTaskclass taskclass) throws HumanTaskServiceException {
        String taskIConXPath = HTSSDKUtils.getTaskIconPath((XmlObject)task);
        if (taskIConXPath != null) {
            taskclass.setTaskIconPath(taskIConXPath);
        }
    }

    protected void addTaskclassVersion(XmlObject task, HTSTaskclass taskclass) throws HumanTaskServiceException {
        String versionId = HTSSDKUtils.getTaskclassVersionId(task);
        if (versionId != null) {
            taskclass.setVersionId(versionId);
        }
    }

    protected void addEscalations(HTSTaskclass taskClass, StateChangesDocument stateChanges) throws HumanTaskServiceException {
        if (stateChanges == null || stateChanges.getStateChanges() == null) {
            return;
        }
        StateChangeImpl[] stateChangeArray = stateChanges.getStateChanges().getStateChangeArray();
        String expressionLanguage = null;
        for (int i = 0; i < stateChangeArray.length; ++i) {
            TLocalNotification notification;
            String conditionExpression = HTSSDKUtils.getText((XmlObject)stateChangeArray[i].getCondition());
            HTSEscalation escalationPojo = this.makeEscalation(conditionExpression, notification = stateChangeArray[i].getLocalNotification());
            if (escalationPojo != null) {
                taskClass.addHTSEscalation(escalationPojo);
            }
            if (expressionLanguage != null) continue;
            expressionLanguage = stateChangeArray[i].getCondition().getExpressionLanguage();
        }
        if (expressionLanguage != null && taskClass.getParamsExpressionLanguage() == null) {
            taskClass.setParamsExpressionLanguage(expressionLanguage);
        }
    }

    protected void addPurgeConstraint(HTSTaskclass htsTaskclass, PurgeConstraintsDocument purgeConstraints) throws HumanTaskServiceException {
        if (purgeConstraints == null || purgeConstraints.getPurgeConstraints() == null) {
            return;
        }
        PurgeConstraintImpl[] purgeConstraintArray = purgeConstraints.getPurgeConstraints().getPurgeConstraintArray();
        for (int i = 0; i < purgeConstraintArray.length; ++i) {
            HTSTaskPurgeConstraint htsTaskPurgeConstraint = new HTSTaskPurgeConstraint();
            htsTaskPurgeConstraint.setId(GuidUtils.create());
            htsTaskPurgeConstraint.setPurgeConstraintClass(purgeConstraintArray[i].getPurgeConstraintClass());
            htsTaskPurgeConstraint.setPurgeConstraintValue(purgeConstraintArray[i].getPurgeConstraintValue().xmlText());
            htsTaskclass.addHTSTaskPurgeConstraints(htsTaskPurgeConstraint);
        }
    }

    protected void addFolders(TTask task, HTSTaskclass taskclass) throws HumanTaskServiceException {
        String folders;
        XmlObject xmlObj = HTSSDKUtils.getXmlObjectChild((XmlObject)task, "folderAction");
        if (xmlObj != null && (folders = HTSSDKUtils.getXML(xmlObj)) != null) {
            taskclass.setFolders(folders);
        }
    }

    protected void addExpirationTime(TTask task, HTSTaskclass taskclass) throws HumanTaskServiceException {
        String expirationTime = HTSSDKUtils.getTextOfChild((XmlObject)task, "expirationTime");
        if (expirationTime != null) {
            taskclass.setExpirationTime(expirationTime);
        }
    }

    protected void addActivationTime(TTask task, HTSTaskclass taskclass) throws HumanTaskServiceException {
        String activationTime = HTSSDKUtils.getTextOfChild((XmlObject)task, "activationTime");
        if (activationTime != null) {
            taskclass.setActivationTime(activationTime);
        }
    }

    protected void addPriority(TTask task, HTSTaskclass taskclass) throws HumanTaskServiceException {
        String priority = HTSSDKUtils.getTextOfChild((XmlObject)task, "priority");
        if (priority != null) {
            taskclass.setPriority(priority);
        }
    }

    protected void addPeopleAssignments(TTask task, HTSTaskclass taskclass) throws HumanTaskServiceException {
        String peopleAssignments;
        XmlObject xmlObj = HTSSDKUtils.getXmlObjectChild((XmlObject)task, "peopleAssignments");
        if (xmlObj != null && (peopleAssignments = HTSSDKUtils.getXML(xmlObj)) != null) {
            taskclass.setPeopleAssignments(peopleAssignments);
        }
    }
}

