/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao.builder;

import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.persist.dao.DAOFactory;
import com.ibm.cognos.internal.hts.persist.dao.TaskReadByDAO;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSDeadline;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSHumanRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSMessage;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRendering;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskReadBy;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskclass;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.util.cam.UserUtils;
import com.ibm.cognos.internal.hts.util.dao.HumanroleUtils;
import com.ibm.cognos.internal.hts.util.dao.MessageUtils;
import com.ibm.cognos.internal.hts.util.dao.TaskUtil;
import com.ibm.cognos.internal.hts.util.dao.builder.PresentationElementsBuilder;
import com.ibm.cognos.internal.hts.util.dao.humanrole.HumanRoleOrganizationalEntityConverter;
import com.ibm.cognos.internal.hts.util.dao.humanrole.OrganizationalEntityConverter;
import com.ibm.cognos.internal.hts.ws_ht.TOrganizationalEntity;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import com.ibm.cognos.internal.hts.ws_ht.api.TTask;
import com.ibm.cognos.internal.hts.ws_ht.api.TTaskAbstract;
import com.ibm.cognos.internal.hts.xpath.XPathEvaluator;
import com.ibm.cognos.internal.hts.xpath.XPathVariableContext;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlObject;
import org.dom4j.Node;

public class BeplTaskBuilder {
    private HTSTask m_task;
    private TTaskAbstract m_taskAbstract = TTaskAbstract.Factory.newInstance();
    private TTask m_ttask = TTask.Factory.newInstance();
    private IAbstractContext context;

    public BeplTaskBuilder(IAbstractContext context) {
        this.context = context;
    }

    public void setUsTask(HTSTask task) {
        this.m_task = task;
    }

    public TTaskAbstract createTaskAbstract() throws HumanTaskServiceException {
        if (this.m_task == null) {
            return null;
        }
        List<HTSMessage> messages = this.m_task.getHtsMessages();
        this.setDeadlines(this.m_task.getHtsTaskclass().getHtsDeadlines());
        Long activationTime = this.m_task.getActivationTime();
        if (activationTime != null) {
            Calendar cal = TaskUtil.convertToCalendar(activationTime);
            this.m_taskAbstract.setActivationTime(cal);
            this.m_ttask.setActivationTime(cal);
        }
        String type = this.m_task.getHtsTaskclass().getTaskType();
        this.m_taskAbstract.setTaskType(type);
        this.m_ttask.setTaskType(type);
        Long createdOn = this.m_task.getCreatedOn();
        Calendar createdOnCal = TaskUtil.convertToCalendar(createdOn);
        this.m_taskAbstract.setCreatedOn(createdOnCal);
        this.m_ttask.setCreatedOn(createdOnCal);
        this.m_taskAbstract.setEscalated(false);
        this.m_ttask.setEscalated(false);
        Long expirationTime = this.m_task.getExpirationTime();
        if (expirationTime != null) {
            Calendar exp = TaskUtil.convertToCalendar(expirationTime);
            this.m_taskAbstract.setExpirationTime(exp);
            this.m_ttask.setExpirationTime(exp);
        }
        boolean hasComments = !this.isEmpty(this.m_task.getHtsThreads());
        this.m_taskAbstract.setHasComments(hasComments);
        this.m_ttask.setHasComments(hasComments);
        HTSMessage faultMsg = MessageUtils.getFaultMessage(this.m_task);
        boolean hasFault = faultMsg != null && faultMsg.getName() != null;
        this.m_taskAbstract.setHasFault(hasFault);
        this.m_ttask.setHasFault(hasFault);
        HTSMessage outputMsg = MessageUtils.getOutputMessage(this.m_task, null);
        boolean hasOutput = messages != null && outputMsg != null && outputMsg.getMessage().length() > 0;
        this.m_taskAbstract.setHasOutput(hasOutput);
        this.m_ttask.setHasOutput(hasOutput);
        List<HTSHumanRole> potOwners = this.m_task.getHumanroles(HTSRole.Roles.POTENTIAL_OWNERS);
        this.m_taskAbstract.setHasPotentialOwners(!potOwners.isEmpty());
        this.m_ttask.setHasPotentialOwners(!potOwners.isEmpty());
        String id = this.m_task.getId();
        this.m_taskAbstract.setId(id);
        this.m_ttask.setId(id);
        this.m_taskAbstract.setIsSkipable(this.m_task.isSkipable());
        this.m_ttask.setIsSkipable(this.m_task.isSkipable());
        String name = this.m_task.getName();
        this.m_taskAbstract.setName(new QName(name));
        this.m_ttask.setName(new QName(name));
        this.buildPresentationElements();
        HTSTaskclass taskClass = this.m_task.getHtsTaskclass();
        List<HTSRendering> renderings = taskClass.getHtsRenderings();
        boolean renderingMethodExists = renderings != null && renderings.size() > 0;
        this.m_taskAbstract.setRenderingMethodExists(renderingMethodExists);
        this.m_ttask.setRenderingMethodExists(renderingMethodExists);
        if (this.m_task.getPriority() != null) {
            Integer priorityInt = this.m_task.getPriority();
            this.m_taskAbstract.setPriority(new BigInteger(priorityInt.toString()));
            this.m_ttask.setPriority(new BigInteger(priorityInt.toString()));
        }
        String status = this.m_task.getStatus();
        TStatus.Enum tStatus = TStatus.Enum.forString((String)status);
        this.m_taskAbstract.setStatus(tStatus);
        this.m_ttask.setStatus(tStatus);
        HTSSDKUtils.setTaskRead((XmlObject)this.m_taskAbstract, this.getTaskRead());
        HTSSDKUtils.setTaskReadLevelForCurrentUser((XmlObject)this.m_taskAbstract, UserUtils.instance().getTaskReadLevelForUser(this.m_task, this.context.getUsTaskUser()));
        HTSSDKUtils.setTaskIconPath((XmlObject)this.m_taskAbstract, this.getImageIconPath());
        return this.m_taskAbstract;
    }

    private String getImageIconPath() throws HumanTaskServiceException {
        String taskIconPath = this.m_task.getHtsTaskclass().getTaskIconPath();
        if (taskIconPath == null) {
            return null;
        }
        String imageIcon = null;
        XPathVariableContext vc = new XPathVariableContext();
        vc.setVariableValue(XPathVariableContext.XPathVariable.TASK, this.m_task);
        XPathEvaluator evaluator = new XPathEvaluator(vc);
        Object resultObject = null;
        resultObject = evaluator.selectNode(taskIconPath);
        if (resultObject instanceof Node) {
            imageIcon = ((Node)resultObject).getText();
        }
        return imageIcon;
    }

    private boolean getTaskRead() throws HumanTaskServiceException {
        TaskReadByDAO readByDao = DAOFactory.getFactory().buildTaskReadByDAO();
        return readByDao.isTaskReadBy(this.context.getUsTaskUser(), this.m_task, HTSTaskReadBy.READ_LEVEL.LOOKED_AT);
    }

    public TTask createTask() throws HumanTaskServiceException {
        TOrganizationalEntity po;
        if (this.m_task == null) {
            return null;
        }
        this.createTaskAbstract();
        if (this.m_task.getActualOwner() != null) {
            this.m_ttask.setActualOwner(this.m_task.getActualOwner().getUserToken());
        }
        HumanRoleOrganizationalEntityConverter hrConverter = new HumanRoleOrganizationalEntityConverter(this.context);
        TOrganizationalEntity businessAdministrators = ((OrganizationalEntityConverter)hrConverter).getOrganizationalEntity(this.m_task.getHumanroles(HTSRole.Roles.BUSINESS_ADMINISTRATORS)).getOrganizationalEntity();
        this.m_ttask.setBusinessAdministrators(businessAdministrators);
        if (this.m_task.getCreatedBy() != null) {
            this.m_ttask.setCreatedBy(this.m_task.getCreatedBy().getUserToken());
        }
        boolean hasPotOwners = (po = ((OrganizationalEntityConverter)hrConverter).getOrganizationalEntity(this.m_task.getHumanroles(HTSRole.Roles.POTENTIAL_OWNERS)).getOrganizationalEntity()).sizeOfUsersArray() != 0 && po.getUsersArray(0).sizeOfUserArray() != 0;
        hasPotOwners = hasPotOwners || po.sizeOfGroupsArray() != 0 && po.getGroupsArray(0).sizeOfGroupArray() != 0;
        this.m_ttask.setHasPotentialOwners(hasPotOwners);
        this.m_ttask.setPotentialOwners(po);
        TOrganizationalEntity nr = ((OrganizationalEntityConverter)hrConverter).getOrganizationalEntity(this.m_task.getHumanroles(HTSRole.Roles.NOTIFICATION_RECIPIENTS)).getOrganizationalEntity();
        this.m_ttask.setNotificationRecipients(nr);
        if (this.m_task.getTaskInitiator() != null) {
            this.m_ttask.setTaskInitiator(this.m_task.getTaskInitiator().getUserToken());
        }
        TOrganizationalEntity ts = ((OrganizationalEntityConverter)hrConverter).getOrganizationalEntity(this.m_task.getHumanroles(HTSRole.Roles.TASK_STAKEHOLDERS)).getOrganizationalEntity();
        this.m_ttask.setTaskStakeholders(ts);
        this.m_ttask.setTaskType(this.m_task.getHtsTaskclass().getTaskType());
        HTSSDKUtils.setTaskRead((XmlObject)this.m_ttask, this.getTaskRead());
        HTSSDKUtils.setTaskReadLevelForCurrentUser((XmlObject)this.m_taskAbstract, UserUtils.instance().getTaskReadLevelForUser(this.m_task, this.context.getUsTaskUser()));
        HTSSDKUtils.setTaskIconPath((XmlObject)this.m_ttask, this.getImageIconPath());
        HTSSDKUtils.setRolesForTask((XmlObject)this.m_ttask, HumanroleUtils.getRoles(this.m_task, this.context));
        return this.m_ttask;
    }

    private void setDeadlines(List<HTSDeadline> listOfDeadlines) {
        boolean hasStart = false;
        boolean hasCompletion = false;
        if (listOfDeadlines != null) {
            Iterator<HTSDeadline> iterator = listOfDeadlines.iterator();
            while (iterator.hasNext() || hasStart && hasCompletion) {
                HTSDeadline deadlines = iterator.next();
                HTSDeadline.DEADLINE_TYPE type = HTSDeadline.DEADLINE_TYPE.valueOf(deadlines.getHtsDeadlinetype());
                hasStart = !hasStart && type != null && type.equals((Object)HTSDeadline.DEADLINE_TYPE.START);
                hasCompletion = !hasCompletion && type != null && type.equals((Object)HTSDeadline.DEADLINE_TYPE.COMPLETE);
            }
        }
        this.m_taskAbstract.setCompleteByExists(hasCompletion);
        this.m_ttask.setCompleteByExists(hasCompletion);
        this.m_taskAbstract.setStartByExists(hasStart);
        this.m_ttask.setStartByExists(hasStart);
    }

    private boolean isEmpty(List<?> items) {
        boolean isEmpty = true;
        isEmpty = items == null || items != null && items.isEmpty();
        return isEmpty;
    }

    private void buildPresentationElements() throws HumanTaskServiceException {
        PresentationElementsBuilder presElemBuilder = new PresentationElementsBuilder(this.m_task, this.context);
        String lang = this.context.getHeader().getProductLanguage();
        String name = presElemBuilder.getName();
        String subject = presElemBuilder.getSubject(lang);
        String description = presElemBuilder.getDescription(lang);
        if (name != null) {
            this.m_taskAbstract.setPresentationName(name);
            this.m_ttask.setPresentationName(name);
        }
        if (description != null) {
            // empty if block
        }
        if (subject != null) {
            this.m_taskAbstract.setPresentationSubject(subject);
            this.m_ttask.setPresentationSubject(subject);
        }
    }
}

