/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao.builder;

import com.ibm.cognos.internal.hts.apiHandlers.context.AddCommentContext;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSPost;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSThread;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.dao.builder.AbstractCommentBuilder;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.CommentType;

public class CommentBuilder
extends AbstractCommentBuilder {
    private String text;
    private HTSTaskUser user;
    private HTSTask m_task;
    private HTSTask m_childTask;

    public CommentBuilder(String text, HTSTask childTask, HTSTaskUser user, HTSTask task) {
        this.m_task = task;
        this.text = text;
        this.user = user;
        this.m_childTask = childTask;
    }

    public CommentBuilder(String text, HTSTaskUser user, HTSTask task) {
        this(text, null, user, task);
    }

    public CommentBuilder(AddCommentContext context, HTSTask task) throws HumanTaskServiceException {
        this(context.getText(), context.getUsTaskUser(), task);
    }

    @Override
    public CommentType.Enum getThreadType() {
        return CommentType.USER;
    }

    @Override
    public HTSThread makeThread() {
        HTSThread thread = super.makeThread();
        thread.setType(this.getThreadType().toString());
        thread.setTitle(this.m_task.getName());
        return thread;
    }

    @Override
    public HTSPost getPost() throws HumanTaskServiceException {
        HTSPost post = super.getPost();
        post.setTitle(this.m_task.getName());
        post.setPagetext(this.text);
        post.setHtsTaskUser(this.user);
        if (this.m_childTask != null) {
            post.addHTSPostTask(this.m_childTask);
        }
        return post;
    }

    @Override
    public HTSTask getUsTask() {
        return this.m_task;
    }

    @Override
    public HTSTaskUser getTaskUser() throws HumanTaskServiceException {
        return this.user;
    }
}

