/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao.builder;

import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSDeadline;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSDeadlineInstance;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.GuidUtils;
import com.ibm.cognos.internal.hts.util.TimeUtils;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.xpath.XPathEvaluator;
import com.ibm.cognos.internal.hts.xpath.XPathVariableContext;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.Duration;
import org.dom4j.Node;

public class DeadlineInstanceBuilder {
    private HTSTask task;
    private List<HTSDeadlineInstance> deadlineInstances = new ArrayList<HTSDeadlineInstance>();
    private boolean wasDurationDeadline;

    public boolean wasDurationDeadline() {
        return this.wasDurationDeadline;
    }

    public void setWasDurationDeadline(boolean wasDurationDeadline) {
        this.wasDurationDeadline = wasDurationDeadline;
    }

    public DeadlineInstanceBuilder(HTSTask task) throws HumanTaskServiceException {
        this.task = task;
        this.processDeadlines();
    }

    public List<HTSDeadlineInstance> getDeadlineInstances() {
        return this.deadlineInstances;
    }

    private Date evaluateDateExpression(HTSDeadline deadline, HTSTask task) throws HumanTaskServiceException {
        XPathVariableContext vc = new XPathVariableContext();
        vc.setVariableValue(XPathVariableContext.XPathVariable.TASK, task);
        XPathEvaluator evaluator = new XPathEvaluator(vc);
        Date deadlineDate = null;
        if (deadline.getTimeForExpression() != null) {
            deadlineDate = this.makeTimeForDate(evaluator, deadline.getTimeForExpression());
            this.wasDurationDeadline = true;
        } else if (deadline.getTimeUntilExpression() != null) {
            deadlineDate = this.makeTimeUntilDate(evaluator, deadline.getTimeUntilExpression());
        }
        return deadlineDate;
    }

    private Date getTimeUntilDate(String date) {
        Date untilDate = null;
        try {
            untilDate = TimeUtils.getDate(date);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return untilDate;
    }

    private Date getTimeForDate(String durationString) throws HumanTaskServiceException {
        Date date = null;
        try {
            Duration duration = Utils.getDataTypeFactory().newDuration(durationString);
            Calendar cal = Calendar.getInstance();
            duration.addTo(cal);
            if (duration.getHours() == 0 && duration.getMinutes() == 0 && duration.getSeconds() == 0) {
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
            }
            date = cal.getTime();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return date;
    }

    private void processDeadlines() throws HumanTaskServiceException {
        List<HTSDeadline> deadlines = this.task.getHtsTaskclass().getHtsDeadlines();
        if (deadlines == null || deadlines.size() == 0) {
            return;
        }
        this.deadlineInstances.clear();
        for (HTSDeadline hTSDeadline : deadlines) {
            if (hTSDeadline == null) continue;
            Date deadlineDate = null;
            deadlineDate = this.evaluateDateExpression(hTSDeadline, this.task);
            HTSDeadlineInstance deadlineInstance = this.makeDeadlineInstance(deadlineDate, hTSDeadline);
            if (deadlineInstance == null) continue;
            this.deadlineInstances.add(deadlineInstance);
        }
    }

    private HTSDeadlineInstance makeDeadlineInstance(Date deadlineDate, HTSDeadline deadline) throws HumanTaskServiceException {
        HTSDeadlineInstance deadlineInstance = null;
        if (deadlineDate != null) {
            deadlineInstance = new HTSDeadlineInstance();
            deadlineInstance.setTimeout(deadlineDate.getTime());
            deadlineInstance.setId(GuidUtils.create());
            deadlineInstance.setDeadlineSignature(deadline.getDeadlineSignature());
            deadlineInstance.setHtsTask(this.task);
            this.task.getHtsDeadlineInstance().add(deadlineInstance);
        }
        return deadlineInstance;
    }

    private Date makeTimeUntilDate(XPathEvaluator evaluator, String durationExpression) throws HumanTaskServiceException {
        Date date = this.getTimeUntilDate(durationExpression);
        if (date == null) {
            String timeUntil;
            Node nodeUntil = (Node)evaluator.selectNode(durationExpression);
            String string = timeUntil = nodeUntil != null ? nodeUntil.getText() : null;
            if (timeUntil != null) {
                date = this.getTimeUntilDate(timeUntil);
            }
        }
        return date;
    }

    private Date makeTimeForDate(XPathEvaluator evaluator, String durationExpression) throws HumanTaskServiceException {
        Date date = this.getTimeForDate(durationExpression);
        if (date == null) {
            String timeFor;
            Node nodeFor = (Node)evaluator.selectNode(durationExpression);
            String string = timeFor = nodeFor != null ? nodeFor.getText() : null;
            if (timeFor != null) {
                date = this.getTimeForDate(timeFor);
            }
        }
        return date;
    }
}

