/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao.builder;

import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.i18n.UsI18NCode;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSMessage;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSPresentationDescription;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSPresentationElements;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSPresentationElementsDesc;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSPresentationElementsName;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSPresentationElementsParams;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSPresentationElementsSubj;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskclass;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.xpath.XPathEvaluator;
import com.ibm.cognos.internal.hts.xpath.XPathVariableContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PresentationElementsBuilder {
    public static boolean useTaskPresentationElements = false;
    private static Pattern m_pattern = Pattern.compile("(\\$.*?\\$)");
    private HTSTask m_task;
    private HTSTaskclass m_taskClass;
    private HTSMessage m_input;
    private Map<String, String> m_paramsMap = new HashMap<String, String>();
    private HTSPresentationElements m_presentationElement = null;

    public PresentationElementsBuilder(HTSTask task, HTSTaskclass taskClass) throws HumanTaskServiceException {
        this(task, taskClass, null);
    }

    public PresentationElementsBuilder(HTSMessage message, HTSTask task, HTSTaskclass taskClass, IAbstractContext context) throws HumanTaskServiceException {
        this.m_input = message;
        this.m_task = task;
        this.m_taskClass = taskClass;
        this.populateParametersMap(this.m_taskClass.getHtsPresentationElementsParams(), context);
        if (useTaskPresentationElements) {
            this.m_presentationElement = this.buildPresentationElementForTask();
        }
    }

    public PresentationElementsBuilder(HTSTask task, HTSTaskclass taskClass, IAbstractContext context) throws HumanTaskServiceException {
        this(null, task, taskClass, context);
    }

    public PresentationElementsBuilder(HTSTask task) throws HumanTaskServiceException {
        this(task, task.getHtsTaskclass());
    }

    public PresentationElementsBuilder(HTSTask task, IAbstractContext context) throws HumanTaskServiceException {
        this(task, task.getHtsTaskclass(), context);
    }

    public String getName() {
        String name = "";
        if (this.m_presentationElement != null) {
            name = this.m_presentationElement.getName();
        } else {
            List<HTSPresentationElementsName> names = this.m_taskClass.getHtsPresentationElementsNames();
            if (names != null && names.size() > 0) {
                HTSPresentationElementsName usPresElemName = names.get(0);
                name = usPresElemName.getName();
            }
        }
        return name;
    }

    public String getSubject(String lang) {
        String subject = "";
        if (this.m_presentationElement != null) {
            subject = this.m_presentationElement.getSubject();
        } else {
            List<HTSPresentationElementsSubj> subjects = this.m_taskClass.getHtsPresentationElementsSubjs();
            if (subjects == null || subjects.size() == 0) {
                subject = "";
            } else if (subjects.size() == 1) {
                HTSPresentationElementsSubj usPresElemSubj = subjects.get(0);
                subject = usPresElemSubj.getSubject();
            } else {
                int pos;
                subject = this.getSubjectByLang(subjects, lang);
                if ("".equals(subject) && "".equals(subject = this.getSubjectByLang(subjects, lang = (pos = Math.max(lang.indexOf("-"), lang.indexOf("_"))) == -1 ? lang : lang.substring(0, pos)))) {
                    subject = this.getSubjectByLang(subjects, "en");
                }
            }
        }
        subject = this.replaceParams(subject, lang);
        return subject;
    }

    private String getSubjectByLang(List<HTSPresentationElementsSubj> subjects, String lang) {
        String subject = "";
        for (HTSPresentationElementsSubj usPresElemSubj : subjects) {
            if (!usPresElemSubj.getLang().equalsIgnoreCase(lang)) continue;
            subject = usPresElemSubj.getSubject();
            break;
        }
        return subject;
    }

    public String getDescription(String lang) {
        return this.getDescription("text/plain", lang);
    }

    public String getDescription(String contentType, String lang) {
        String description = "";
        if (this.m_presentationElement != null) {
            HTSPresentationDescription htsDescription = this.m_presentationElement.getDescription(contentType);
            if (htsDescription != null) {
                description = htsDescription.getDescription();
            }
        } else {
            List<HTSPresentationElementsDesc> descriptions = this.m_taskClass.getHtsPresentationElementsDescs();
            ArrayList<HTSPresentationElementsDesc> correctType = new ArrayList<HTSPresentationElementsDesc>();
            for (HTSPresentationElementsDesc usPresElemDesc : descriptions) {
                if (!usPresElemDesc.getContentType().equalsIgnoreCase(contentType)) continue;
                correctType.add(usPresElemDesc);
            }
            if (correctType.size() == 0) {
                description = !"text/plain".equals(contentType) ? this.getDescription(lang) : "";
            } else if (correctType.size() == 1) {
                description = ((HTSPresentationElementsDesc)correctType.get(0)).getDescription();
            } else {
                int pos;
                description = this.getDescriptionByLang(correctType, lang);
                if ("".equals(description) && "".equals(description = this.getDescriptionByLang(correctType, lang = (pos = Math.max(lang.indexOf("-"), lang.indexOf("_"))) == -1 ? lang : lang.substring(0, pos)))) {
                    description = this.getDescriptionByLang(correctType, "en");
                }
            }
        }
        description = this.replaceParams(description, lang);
        return description;
    }

    private String getDescriptionByLang(List<HTSPresentationElementsDesc> correctType, String lang) {
        String description = "";
        for (HTSPresentationElementsDesc corrPresElemDesc : correctType) {
            if (!corrPresElemDesc.getLang().equalsIgnoreCase(lang)) continue;
            description = corrPresElemDesc.getDescription();
            break;
        }
        return description;
    }

    private String replaceParams(String varString, String lang) {
        if (varString == null) {
            return varString;
        }
        Matcher matcher = m_pattern.matcher(varString);
        while (matcher.find()) {
            String var = matcher.group();
            if (!this.m_paramsMap.containsKey(var)) continue;
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            String paramValue = this.m_paramsMap.get(var);
            if (paramValue.startsWith("MSG_HTS_INTERACTION")) {
                paramValue = I18NUtil.getMessage((I18NCode)new UsI18NCode(paramValue, "Client"), (Locale)new Locale(lang));
                paramValue = this.replaceParams(paramValue, lang);
            }
            varString = varString.substring(0, startIndex) + paramValue + varString.substring(endIndex);
            matcher.reset(varString);
        }
        return varString;
    }

    private void populateParametersMap(List<HTSPresentationElementsParams> params, IAbstractContext context) throws HumanTaskServiceException {
        if (params != null) {
            for (HTSPresentationElementsParams param : params) {
                String expression = param.getExpression().trim();
                XPathVariableContext variableContext = new XPathVariableContext();
                variableContext.setVariableValue(XPathVariableContext.XPathVariable.TASK, this.m_task);
                if (this.m_input != null) {
                    variableContext.setVariableValue(XPathVariableContext.XPathVariable.INPUT, this.m_input);
                }
                variableContext.setVariableValue(XPathVariableContext.XPathVariable.CONTEXT, context);
                XPathEvaluator evaluator = new XPathEvaluator(variableContext);
                try {
                    String value = evaluator.selectNodeValue(expression);
                    this.m_paramsMap.put("$" + param.getName() + "$", value);
                }
                catch (HumanTaskServiceException e) {
                    Utils.logException((Throwable)((Object)e));
                }
            }
        }
    }

    private HTSPresentationElements buildPresentationElementForTask() {
        Iterator<HTSPresentationElements> elements;
        HTSPresentationElements presentationelements = null;
        List<HTSPresentationElements> items = this.m_task.getHtsPresentationElements();
        if (items != null && !items.isEmpty() && (elements = items.iterator()).hasNext()) {
            presentationelements = elements.next();
        }
        return presentationelements;
    }
}

