/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao.builder;

import com.cognos.jsmcommon.util.Headers;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSCallback;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSCallbackParam;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSHumanRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.status.StateManagement;
import com.ibm.cognos.internal.hts.util.Utils;
import com.ibm.cognos.internal.hts.util.dao.CallbackUtilities;
import com.ibm.cognos.internal.hts.util.dao.builder.AbstractTaskBuilder;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import java.util.ArrayList;
import java.util.Date;

public class TaskBuilder
extends AbstractTaskBuilder {
    private static final String TASK_ID_CALL_BACK = "{http://www.ibm.com/xmlns/prod/cognos/WS-HT/ext}taskId";
    private StateManagement stateManagement = null;

    public TaskBuilder() {
        try {
            this.stateManagement = new StateManagement("createAnyUserTask");
        }
        catch (HumanTaskServiceException e) {
            Utils.logException((Throwable)((Object)e));
        }
    }

    public void setActivationTime(long activationTime) {
        this.task.setActivationTime(activationTime);
    }

    public void setExpirationTime(long time) {
        this.task.setExpirationTime(time);
    }

    public void setCallBack(Headers header, String taskId) throws HumanTaskServiceException {
        HTSCallback cb = CallbackUtilities.makeCallBack(CallbackUtilities.makeReplyToDocument(header.getReplyToElement()));
        if (cb == null) {
            return;
        }
        if (header.getBiBusHeader().getCAM() != null && header.getBiBusHeader().getCAM().getCAMCredentialPath() != null) {
            cb.setCredential(header.getBiBusHeader().getCAM().getCAMCredentialPath());
        }
        cb.addCallBackParam(new HTSCallbackParam(TASK_ID_CALL_BACK, taskId));
        cb.setHtsTask(this.task);
        this.task.setHtsCallback(cb);
    }

    @Override
    public void setStatus() {
        this.task.setStatus(TStatus.CREATED.toString());
        if (this.task.getActivationTime() != null && new Date().after(new Date(this.task.getActivationTime()))) {
            TStatus.Enum statusEnum = this.stateManagement.getFinalStatus(this.task);
            this.task.setStatus(statusEnum.toString());
            if (statusEnum.equals(TStatus.RESERVED)) {
                this.setActualOwnerToSingleHumanRoleUser();
            }
        }
    }

    private void setActualOwnerToSingleHumanRoleUser() {
        ArrayList<HTSHumanRole> oneRole = new ArrayList<HTSHumanRole>();
        if (this.roles != null) {
            for (HTSHumanRole humanrole : this.roles) {
                if (!humanrole.getHtsRole().getRole().equals(HTSRole.Roles.POTENTIAL_OWNERS.getRole())) continue;
                oneRole.add(humanrole);
            }
        }
        if (oneRole.size() == 1 && oneRole.get(0) != null && !((HTSHumanRole)oneRole.get(0)).getHtsTaskUser().isGroup()) {
            this.task.setActualOwner(((HTSHumanRole)oneRole.get(0)).getHtsTaskUser());
        }
    }
}

