/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao.builder;

import com.cognos.jsmcommon.util.LocaleUtil;
import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSDeadline;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSDeadlineInstance;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSMessage;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskReadBy;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskclass;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.util.TimeUtils;
import com.ibm.cognos.internal.hts.util.cam.UserUtils;
import com.ibm.cognos.internal.hts.util.dao.FolderUtils;
import com.ibm.cognos.internal.hts.util.dao.HumanroleUtils;
import com.ibm.cognos.internal.hts.util.dao.MessageUtils;
import com.ibm.cognos.internal.hts.util.dao.builder.PresentationElementsBuilder;
import com.ibm.cognos.internal.hts.util.dao.humanrole.HumanRoleOrganizationalEntityConverter;
import com.ibm.cognos.internal.hts.util.dao.humanrole.OrganizationalEntityConverter;
import com.ibm.cognos.internal.hts.ws_ht.TOrganizationalEntity;
import com.ibm.cognos.internal.hts.ws_ht.api.TStatus;
import com.ibm.cognos.internal.hts.ws_ht.api.TTaskQueryResultRow;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.FolderAction;
import com.ibm.cognos.internal.hts.xpath.XPathEvaluator;
import com.ibm.cognos.internal.hts.xpath.XPathVariableContext;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlObject;
import org.dom4j.Node;

public class TaskQueryResultRowBuilder {
    public TTaskQueryResultRow populateRow(TTaskQueryResultRow row, IAbstractContext context, HTSTask task) throws HumanTaskServiceException {
        row.addId(task.getId());
        row.addTaskType(task.getTaskType().name());
        if (task.getName() != null) {
            row.addName(new QName(task.getName()));
        } else {
            row.addName(new QName(""));
        }
        row.addStatus(TStatus.Enum.forString((String)task.getStatus()));
        row.addPriority(task.getPriority() != null ? new BigInteger(task.getPriority().toString()) : null);
        row.addActualOwner(task.getActualOwner() != null ? task.getActualOwner().getUserToken() : "");
        HumanRoleOrganizationalEntityConverter hroec = new HumanRoleOrganizationalEntityConverter(context);
        TOrganizationalEntity ti = ((OrganizationalEntityConverter)hroec).getOrganizationalEntity(task.getHumanroles(HTSRole.Roles.TASK_INITIATORS)).getOrganizationalEntity();
        TOrganizationalEntity ba = ((OrganizationalEntityConverter)hroec).getOrganizationalEntity(task.getHumanroles(HTSRole.Roles.BUSINESS_ADMINISTRATORS)).getOrganizationalEntity();
        TOrganizationalEntity po = ((OrganizationalEntityConverter)hroec).getOrganizationalEntity(task.getHumanroles(HTSRole.Roles.POTENTIAL_OWNERS)).getOrganizationalEntity();
        TOrganizationalEntity nr = ((OrganizationalEntityConverter)hroec).getOrganizationalEntity(task.getHumanroles(HTSRole.Roles.NOTIFICATION_RECIPIENTS)).getOrganizationalEntity();
        TOrganizationalEntity ts = ((OrganizationalEntityConverter)hroec).getOrganizationalEntity(task.getHumanroles(HTSRole.Roles.TASK_STAKEHOLDERS)).getOrganizationalEntity();
        row.setTaskInitiatorArray(new TOrganizationalEntity[]{ti});
        row.setTaskStakeholdersArray(new TOrganizationalEntity[]{ts});
        row.setPotentialOwnersArray(new TOrganizationalEntity[]{po});
        row.setBusinessAdministratorsArray(new TOrganizationalEntity[]{ba});
        row.setNotificationRecipientsArray(new TOrganizationalEntity[]{nr});
        row.addCreatedOn(TimeUtils.toUTCCalendar(task.getCreatedOn()));
        row.addCreatedBy(task.getCreatedBy().getUserToken());
        HumanroleUtils.setFormattedHumanRoles((XmlObject)row, task, context);
        row.addActivationTime(TimeUtils.toUTCCalendar(task.getActivationTime()));
        row.addExpirationTime(TimeUtils.toUTCCalendar(task.getExpirationTime()));
        boolean hasPotentialOwners = this.hasContent(task.getHumanroles(HTSRole.Roles.POTENTIAL_OWNERS));
        row.addHasPotentialOwners(hasPotentialOwners);
        this.setHasDeadlines(row, task.getHtsTaskclass());
        this.buildPresentationElements(row, context, task);
        boolean hasRenderings = false;
        if (task.getHtsTaskclass() != null) {
            hasRenderings = this.hasContent(task.getHtsTaskclass().getHtsRenderings());
        }
        row.addRenderingMethodExists(hasRenderings);
        HTSMessage outputMsg = MessageUtils.getOutputMessage(task, null);
        List<HTSMessage> messages = task.getHtsMessages();
        boolean hasOutput = messages != null && outputMsg != null && outputMsg.getMessage().length() > 0;
        row.addHasOutput(hasOutput);
        HTSMessage faultMsg = MessageUtils.getFaultMessage(task);
        boolean hasFault = faultMsg != null && faultMsg.getName() != null;
        row.addHasFault(hasFault);
        boolean hasComments = this.hasContent(task.getHtsThreads());
        row.addHasComments(hasComments);
        HTSSDKUtils.setRolesForTask((XmlObject)row, HumanroleUtils.getRoles(task, context));
        FolderAction fa = FolderUtils.getFolderAction(task.getFolders());
        if (fa != null) {
            HTSSDKUtils.appendXMLBean((XmlObject)row, (XmlObject)fa);
        }
        Calendar utcDueDate = this.getUTCDueDate(task);
        HTSSDKUtils.setDueDate((XmlObject)row, this.getXsDate(utcDueDate));
        HTSSDKUtils.setTaskRead((XmlObject)row, this.getTaskRead(task, context.getUsTaskUser()));
        HTSSDKUtils.setTaskReadLevelForCurrentUser((XmlObject)row, UserUtils.instance().getTaskReadLevelForUser(task, context.getUsTaskUser()));
        HTSSDKUtils.setTaskIconPath((XmlObject)row, TaskQueryResultRowBuilder.getImageIconPath(task));
        Locale locale = this.getDefaultTaskLocale(task);
        HTSSDKUtils.setCustomXML((XmlObject)row, "locale", locale.toString());
        return row;
    }

    public static String getImageIconPath(HTSTask task) throws HumanTaskServiceException {
        if (task.getHtsTaskclass() == null) {
            return null;
        }
        String taskIconPath = task.getHtsTaskclass().getTaskIconPath();
        if (taskIconPath == null) {
            return null;
        }
        String imageIcon = null;
        XPathVariableContext vc = new XPathVariableContext();
        vc.setVariableValue(XPathVariableContext.XPathVariable.TASK, task);
        XPathEvaluator evaluator = new XPathEvaluator(vc);
        Object resultObject = null;
        resultObject = evaluator.selectNode(taskIconPath);
        if (resultObject instanceof Node) {
            imageIcon = ((Node)resultObject).getText();
        }
        if (imageIcon == null || "".equals(imageIcon)) {
            imageIcon = HTSTask.TYPE.TASK == task.getTaskType() ? "fragments/myinbox/images/icon_task.gif" : "fragments/myinbox/images/icon_notification.gif";
        }
        return imageIcon;
    }

    private Locale getDefaultTaskLocale(HTSTask task) {
        Locale defaultLocale = null;
        defaultLocale = task.getDefaultLocale() != null ? LocaleUtil.getLocale((String)task.getDefaultLocale()) : Locale.getDefault();
        return defaultLocale;
    }

    private String getXsDate(Calendar cal) throws HumanTaskServiceException {
        String strDate = null;
        if (cal != null) {
            strDate = TimeUtils.getXsDate((GregorianCalendar)cal);
        }
        return strDate;
    }

    private Calendar getUTCDueDate(HTSTask task) throws HumanTaskServiceException {
        List<HTSDeadlineInstance> deadlines = task.getHtsDeadlineInstance();
        Date due = null;
        for (HTSDeadlineInstance deadline : deadlines) {
            Date deadlineDate = new Date(deadline.getTimeout());
            if (due != null && !due.after(deadlineDate)) continue;
            due = deadlineDate;
        }
        return due == null ? null : TimeUtils.toUTCCalendar(due.getTime());
    }

    private void setHasDeadlines(TTaskQueryResultRow row, HTSTaskclass taskclass) {
        boolean hasStart = false;
        boolean hasCompletion = false;
        if (taskclass != null && taskclass.getHtsDeadlines() != null) {
            List<HTSDeadline> deadlines = taskclass.getHtsDeadlines();
            for (HTSDeadline deadline : deadlines) {
                HTSDeadline.DEADLINE_TYPE type = HTSDeadline.DEADLINE_TYPE.valueOf(deadline.getHtsDeadlinetype());
                boolean bl = hasStart ? hasStart : (hasStart = type != null && type.equals((Object)HTSDeadline.DEADLINE_TYPE.START));
                hasCompletion = hasCompletion ? hasCompletion : type != null && type.equals((Object)HTSDeadline.DEADLINE_TYPE.COMPLETE);
            }
        }
        row.addStartByExists(hasStart);
        row.addCompleteByExists(hasCompletion);
    }

    private boolean hasContent(List<?> items) {
        boolean hasContent = true;
        hasContent = items != null && items.size() > 0;
        return hasContent;
    }

    private boolean getTaskRead(HTSTask task, HTSTaskUser currentUser) throws HumanTaskServiceException {
        boolean taskRead = false;
        String userId = currentUser.getUserToken();
        List<HTSTaskReadBy> readBys = task.getTaskReadBys();
        for (HTSTaskReadBy readBy : readBys) {
            if (!(taskRead = taskRead || readBy.getUser().getUserToken().equals(userId))) continue;
            break;
        }
        return taskRead;
    }

    private void buildPresentationElements(TTaskQueryResultRow row, IAbstractContext context, HTSTask task) throws HumanTaskServiceException {
        String lang = context.getHeader().getProductLanguage();
        PresentationElementsBuilder presElemBuilder = new PresentationElementsBuilder(task, context);
        this.buildElementForTask(lang, presElemBuilder, row);
    }

    private void buildElementForTask(String lang, PresentationElementsBuilder presElemBuilder, TTaskQueryResultRow row) {
        String name = presElemBuilder.getName();
        String subject = presElemBuilder.getSubject(lang);
        String description = presElemBuilder.getDescription(lang);
        if (name != null) {
            row.addPresentationName(name);
        }
        if (description != null) {
            row.addPresentationDescription(description);
        }
        if (subject != null) {
            row.addPresentationSubject(subject);
        }
    }
}

