/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao.builder;

import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTask;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskclass;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.GuidUtils;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.util.dao.TaskClassPropertyUtil;
import com.ibm.cognos.internal.hts.util.dao.builder.AbstractTaskclassBuilder;
import com.ibm.cognos.internal.hts.ws_ht.TDelegation;
import com.ibm.cognos.internal.hts.ws_ht.TImport;
import com.ibm.cognos.internal.hts.ws_ht.TPresentationElements;
import com.ibm.cognos.internal.hts.ws_ht.TTask;
import com.ibm.cognos.internal.hts.ws_ht.TTaskInterface;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlObject;

public class TaskclassBuilder
extends AbstractTaskclassBuilder {
    public HTSTaskclass makeTaskclass(TTask task, TImport[] imports, QName uniqueName) throws HumanTaskServiceException {
        HTSTaskclass taskclass = new HTSTaskclass();
        TTaskInterface taskInterface = task.getInterface();
        TDelegation delegationType = task.getDelegation();
        String responseOperation = taskInterface.getResponseOperation() == null ? null : taskInterface.getResponseOperation();
        String responsePortType = taskInterface.getResponsePortType() == null ? null : taskInterface.getResponsePortType().toString();
        taskclass.setId(GuidUtils.create());
        taskclass.setName(uniqueName.toString());
        if (delegationType != null) {
            taskclass.setDelegationType(delegationType.toString());
        } else {
            taskclass.setDelegationType(HTSTaskclass.DELEGATION_TYPE.ANYBODY.getType());
        }
        String portType = taskInterface.getPortType().toString();
        String operation = taskInterface.getOperation();
        taskclass.setPortType(portType);
        taskclass.setOperation(operation);
        taskclass.setResponsePortType(responsePortType);
        taskclass.setResponseOperation(responseOperation);
        this.addRenderings(task.getRenderings(), taskclass);
        this.addImports(taskclass, imports);
        TPresentationElements tPresElems = task.getPresentationElements();
        this.setPresentationElements(taskclass, tPresElems);
        taskclass.setTaskType(HTSTask.TYPE.TASK.getType());
        this.addEscalations(taskclass, HTSSDKUtils.getStateChanges((XmlObject)task));
        this.addPurgeConstraint(taskclass, HTSSDKUtils.getPurgeConstraint((XmlObject)task));
        this.addDeadlines(taskclass, task.getDeadlines());
        this.addTaskIcon(task, taskclass);
        this.addTaskSubscriptions((XmlObject)task, taskclass);
        TaskClassPropertyUtil util = new TaskClassPropertyUtil(HTSSDKUtils.getTaskClassProperties((XmlObject)task));
        util.setTaskClass(taskclass);
        taskclass.setHtsTaskClassProperties(util.getProperties());
        this.addTaskclassVersion((XmlObject)task, taskclass);
        this.addPeopleAssignments(task, taskclass);
        this.addPriority(task, taskclass);
        this.addActivationTime(task, taskclass);
        this.addExpirationTime(task, taskclass);
        this.addFolders(task, taskclass);
        return taskclass;
    }
}

