/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao.humanrole;

import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSHumanRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.GuidUtils;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.util.cam.UserUtils;
import com.ibm.cognos.internal.hts.util.dao.humanrole.OrganizationalEntityConverter;
import com.ibm.cognos.internal.hts.ws_ht.OrganizationalEntityDocument;
import com.ibm.cognos.internal.hts.ws_ht.TFrom;
import com.ibm.cognos.internal.hts.ws_ht.TGenericHumanRole;
import com.ibm.cognos.internal.hts.ws_ht.TOrganizationalEntity;
import java.util.ArrayList;
import java.util.List;

public class HumanRoleOrganizationalEntityConverter
extends OrganizationalEntityConverter<HTSHumanRole> {
    public HumanRoleOrganizationalEntityConverter(IAbstractContext context) {
        super(context);
    }

    public List<HTSHumanRole> getHumanRolePojo(List<HTSTaskUser> taskUserPojos, HTSRole role) throws HumanTaskServiceException {
        ArrayList<HTSHumanRole> pojoList = new ArrayList<HTSHumanRole>();
        for (HTSTaskUser taskUser : taskUserPojos) {
            HTSHumanRole humanrole = new HTSHumanRole(taskUser, role);
            humanrole.setId(GuidUtils.create());
            pojoList.add(humanrole);
        }
        return pojoList;
    }

    @Override
    public void addHumanRolePojos(List<HTSHumanRole> roles, HTSRole rolePojo, TGenericHumanRole organizationalEntity, HTSRole.Roles roleEnum) throws HumanTaskServiceException {
        TFrom from = organizationalEntity.getFrom();
        if (from == null || from.getLiteral() == null) {
            return;
        }
        String lpgString = from.getLogicalPeopleGroup().getLocalPart();
        OrganizationalEntityDocument oed = HTSSDKUtils.getOrganizationalEntity(from.getLiteral());
        if (oed != null) {
            List<HTSTaskUser> taskUserPojos = UserUtils.instance().getUsers(oed.getOrganizationalEntity(), lpgString.toUpperCase());
            roles.addAll(this.getHumanRolePojo(taskUserPojos, rolePojo));
        }
    }

    @Override
    public OrganizationalEntityDocument getFormattedOrganizationalEntity(HTSHumanRole humanRolePojo) throws HumanTaskServiceException {
        OrganizationalEntityDocument orgDoc = OrganizationalEntityDocument.Factory.newInstance();
        TOrganizationalEntity org = orgDoc.addNewOrganizationalEntity();
        HTSTaskUser user = humanRolePojo.getHtsTaskUser();
        this.addFormattedUser(org, user);
        return orgDoc;
    }

    @Override
    public OrganizationalEntityDocument getOrganizationalEntity(HTSHumanRole humanRolePojo) {
        OrganizationalEntityDocument orgDoc = OrganizationalEntityDocument.Factory.newInstance();
        TOrganizationalEntity org = orgDoc.addNewOrganizationalEntity();
        HTSTaskUser user = humanRolePojo.getHtsTaskUser();
        this.addUser(org, user);
        return orgDoc;
    }

    @Override
    public HTSRole getRole(HTSHumanRole humanrolePojo) {
        return humanrolePojo.getHtsRole();
    }
}

