/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.dao.humanrole;

import com.ibm.cognos.internal.hts.apiHandlers.context.IAbstractContext;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSRole;
import com.ibm.cognos.internal.hts.persist.dao.pojo.HTSTaskUser;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.cam.UserUtils;
import com.ibm.cognos.internal.hts.util.dao.HumanroleUtils;
import com.ibm.cognos.internal.hts.ws_ht.OrganizationalEntityDocument;
import com.ibm.cognos.internal.hts.ws_ht.PeopleAssignmentsDocument;
import com.ibm.cognos.internal.hts.ws_ht.TGenericHumanRole;
import com.ibm.cognos.internal.hts.ws_ht.TGroup;
import com.ibm.cognos.internal.hts.ws_ht.TGrouplist;
import com.ibm.cognos.internal.hts.ws_ht.TLiteral;
import com.ibm.cognos.internal.hts.ws_ht.TOrganizationalEntity;
import com.ibm.cognos.internal.hts.ws_ht.TPeopleAssignments;
import com.ibm.cognos.internal.hts.ws_ht.TUser;
import com.ibm.cognos.internal.hts.ws_ht.TUserlist;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.TFormattedOrganizationalEntity;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlObject;

public abstract class OrganizationalEntityConverter<T> {
    protected IAbstractContext context;

    protected OrganizationalEntityConverter(IAbstractContext context) {
        this.context = context;
    }

    public List<T> processPeopleAssignments(TPeopleAssignments[] peopleAssignments) throws HumanTaskServiceException {
        ArrayList roles = new ArrayList();
        if (peopleAssignments == null) {
            return roles;
        }
        for (int i = 0; i < peopleAssignments.length; ++i) {
            this.getHumanRolePojos(roles, peopleAssignments[i].getBusinessAdministratorsArray(), HTSRole.Roles.BUSINESS_ADMINISTRATORS);
            this.getHumanRolePojos(roles, peopleAssignments[i].getExcludedOwnersArray(), HTSRole.Roles.EXLUDED_OWNERS);
            this.getHumanRolePojos(roles, peopleAssignments[i].getPotentialOwnersArray(), HTSRole.Roles.POTENTIAL_OWNERS);
            this.getHumanRolePojos(roles, peopleAssignments[i].getRecipientsArray(), HTSRole.Roles.NOTIFICATION_RECIPIENTS);
            this.getHumanRolePojos(roles, peopleAssignments[i].getTaskStakeholdersArray(), HTSRole.Roles.TASK_STAKEHOLDERS);
            this.getHumanRolePojos(roles, peopleAssignments[i].getTaskInitiatorArray(), HTSRole.Roles.TASK_INITIATORS);
        }
        return roles;
    }

    public void getHumanRolePojos(List<T> roles, TGenericHumanRole[] organizationalEntities, HTSRole.Roles roleEnum) throws HumanTaskServiceException {
        HTSRole rolePojo = null;
        if (organizationalEntities.length > 0) {
            rolePojo = HumanroleUtils.getRole(roleEnum);
        }
        for (int i = 0; i < organizationalEntities.length; ++i) {
            this.addHumanRolePojos(roles, rolePojo, organizationalEntities[i], roleEnum);
        }
    }

    public OrganizationalEntityDocument getOrganizationalEntity(List<T> humanRolePojos) throws HumanTaskServiceException {
        OrganizationalEntityDocument orgDoc = OrganizationalEntityDocument.Factory.newInstance();
        TOrganizationalEntity org = orgDoc.addNewOrganizationalEntity();
        for (T humanRolePojo : humanRolePojos) {
            int i;
            OrganizationalEntityDocument roleOrg = this.getOrganizationalEntity(humanRolePojo);
            if (roleOrg.getOrganizationalEntity().sizeOfGroupsArray() != 0) {
                TGrouplist groupList = roleOrg.getOrganizationalEntity().getGroupsArray(0);
                if (org.sizeOfGroupsArray() == 0) {
                    org.addNewGroups();
                }
                for (i = 0; groupList != null && i < groupList.sizeOfGroupArray(); ++i) {
                    org.getGroupsArray(0).addGroup(groupList.getGroupArray(i));
                }
            }
            if (roleOrg.getOrganizationalEntity().sizeOfUsersArray() == 0) continue;
            TUserlist userList = roleOrg.getOrganizationalEntity().getUsersArray(0);
            if (org.sizeOfUsersArray() == 0) {
                org.addNewUsers();
            }
            for (i = 0; userList != null && i < userList.sizeOfUserArray(); ++i) {
                org.getUsersArray(0).addUser(userList.getUserArray(i));
            }
        }
        return orgDoc;
    }

    public TFormattedOrganizationalEntity getFormattedOrganizationalEntity(List<T> humanRolePojos) throws HumanTaskServiceException {
        TFormattedOrganizationalEntity org = TFormattedOrganizationalEntity.Factory.newInstance();
        for (T humanRolePojo : humanRolePojos) {
            int i;
            OrganizationalEntityDocument roleOrg = this.getFormattedOrganizationalEntity(humanRolePojo);
            if (roleOrg.getOrganizationalEntity().sizeOfGroupsArray() != 0) {
                TGrouplist groupList = roleOrg.getOrganizationalEntity().getGroupsArray(0);
                if (!org.isSetGroups()) {
                    org.addNewGroups();
                }
                for (i = 0; groupList != null && i < groupList.sizeOfGroupArray(); ++i) {
                    org.getGroups().addGroup(groupList.getGroupArray(i));
                }
            }
            if (roleOrg.getOrganizationalEntity().sizeOfUsersArray() == 0) continue;
            TUserlist userList = roleOrg.getOrganizationalEntity().getUsersArray(0);
            if (!org.isSetUsers()) {
                org.addNewUsers();
            }
            for (i = 0; userList != null && i < userList.sizeOfUserArray(); ++i) {
                org.getUsers().addUser(userList.getUserArray(i));
            }
        }
        return org;
    }

    public PeopleAssignmentsDocument getPeopleAssignments(List<T> humanRolePojos) throws HumanTaskServiceException {
        PeopleAssignmentsDocument peopleAssignmentsDoc = PeopleAssignmentsDocument.Factory.newInstance();
        TPeopleAssignments peopleAssignments = peopleAssignmentsDoc.addNewPeopleAssignments();
        for (T humanRolePojo : humanRolePojos) {
            HTSRole.Roles role = HTSRole.Roles.findRole(this.getRole(humanRolePojo).getRole());
            TGenericHumanRole genericHumanRole = null;
            if (HTSRole.Roles.BUSINESS_ADMINISTRATORS.equals((Object)role)) {
                genericHumanRole = peopleAssignments.addNewBusinessAdministrators();
            } else if (HTSRole.Roles.EXLUDED_OWNERS.equals((Object)role)) {
                genericHumanRole = peopleAssignments.addNewExcludedOwners();
            } else if (HTSRole.Roles.NOTIFICATION_RECIPIENTS.equals((Object)role)) {
                genericHumanRole = peopleAssignments.addNewRecipients();
            } else if (HTSRole.Roles.POTENTIAL_OWNERS.equals((Object)role)) {
                genericHumanRole = peopleAssignments.addNewPotentialOwners();
            } else if (HTSRole.Roles.TASK_INITIATORS.equals((Object)role)) {
                genericHumanRole = peopleAssignments.addNewTaskInitiator();
            } else if (HTSRole.Roles.TASK_STAKEHOLDERS.equals((Object)role)) {
                genericHumanRole = peopleAssignments.addNewTaskStakeholders();
            }
            if (genericHumanRole == null) continue;
            TLiteral literal = genericHumanRole.addNewFrom().addNewLiteral();
            literal.set((XmlObject)this.getOrganizationalEntity(humanRolePojo));
        }
        return peopleAssignmentsDoc;
    }

    protected void addUser(TOrganizationalEntity org, HTSTaskUser user) {
        this.addUserOrGroup(org, user.getUserToken(), user.isGroup());
    }

    protected void addFormattedUser(TOrganizationalEntity org, HTSTaskUser user) throws HumanTaskServiceException {
        String userName = UserUtils.instance().getUserName(this.context, user);
        this.addUserOrGroup(org, userName, user.isGroup());
    }

    protected void addUserOrGroup(TOrganizationalEntity org, String token, boolean isGroup) {
        if (isGroup) {
            TGrouplist gList = this.getGroupList(org);
            TGroup tGroup = gList.addNewGroup();
            tGroup.setStringValue(token);
        } else {
            TUserlist uList = this.getUserList(org);
            TUser tUser = uList.addNewUser();
            tUser.setStringValue(token);
        }
    }

    protected TGrouplist getGroupList(TOrganizationalEntity org) {
        return org.sizeOfGroupsArray() == 0 ? org.addNewGroups() : org.getGroupsArray(0);
    }

    protected TUserlist getUserList(TOrganizationalEntity org) {
        return org.sizeOfUsersArray() == 0 ? org.addNewUsers() : org.getUsersArray(0);
    }

    public abstract void addHumanRolePojos(List<T> var1, HTSRole var2, TGenericHumanRole var3, HTSRole.Roles var4) throws HumanTaskServiceException;

    public abstract OrganizationalEntityDocument getOrganizationalEntity(T var1) throws HumanTaskServiceException;

    public abstract OrganizationalEntityDocument getFormattedOrganizationalEntity(T var1) throws HumanTaskServiceException;

    public abstract HTSRole getRole(T var1);
}

