/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.perf;

import com.ibm.cognos.internal.hts.util.perf.HtsPerfData;
import com.ibm.cognos.internal.hts.util.perf.Timing;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.GetPerfDataResponseDocument;
import java.util.Collection;
import java.util.Stack;

public class OperationTimings {
    private Timing operationTiming;
    private Stack<Timing> timings = new Stack();

    public OperationTimings(String id) {
        this.operationTiming = new Timing(id);
        this.timings.push(this.getOperationTiming());
    }

    public void stopChildTiming(String id) {
        if (!this.timings.isEmpty()) {
            if (!this.timings.peek().getName().equals(id) && HtsPerfData.verbose) {
                System.out.println("WARNING: stop child timing with wrong id " + id + " should be + " + this.timings.peek().getName());
            }
            Timing timing = this.timings.pop();
            timing.finish();
        }
        if (HtsPerfData.verbose) {
            System.out.println("stop child timing with id " + id);
        }
    }

    public Timing startChildTiming(String id) {
        Timing currentTiming = this.timings.peek();
        Timing child = currentTiming.startChildTiming(id);
        this.timings.push(child);
        if (HtsPerfData.verbose) {
            System.out.println("start child timing with id " + id);
        }
        return child;
    }

    public void startChildStackTiming(String id) {
        if (!this.timings.isEmpty() && this.timings.peek() != null) {
            if (HtsPerfData.verbose) {
                System.out.println("stop child timing with id " + this.timings.peek().getName());
            }
            Timing timing = this.timings.pop();
            timing.finish();
        }
        this.startChildTiming(id);
    }

    public void stopTiming() {
        this.operationTiming.finish();
    }

    public void stopTimingChildren() {
        this.operationTiming.finishChildren();
    }

    public void restart() {
        this.operationTiming.restart();
    }

    public void getChildSummaries(GetPerfDataResponseDocument.GetPerfDataResponse perfDataresponse) {
        this.operationTiming.getSummary(perfDataresponse, 0.0f);
    }

    void removeChildren(Collection<Timing> orphans, Timing parent) {
        orphans.remove(parent);
        Collection<Timing> children = parent.getChildren();
        for (Timing timing : children) {
            this.removeChildren(orphans, timing);
        }
    }

    public Timing getOperationTiming() {
        return this.operationTiming;
    }

    public void setOperationTiming(Timing operationTiming) {
        this.operationTiming = operationTiming;
    }
}

