/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.perf;

import com.ibm.cognos.internal.hts.util.perf.TimingDurationComparator;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.GetPerfDataResponseDocument;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.TPerfData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Timing {
    private Map<String, Timing> children = new HashMap<String, Timing>();
    private String name;
    private Date start = new Date();
    private int count = this.count <= 0 ? 1 : this.count;
    private float duration;
    private boolean finished = false;

    public Timing(String name) {
        this.name = name;
    }

    public void finish() {
        if (this.isFinished()) {
            return;
        }
        Date finish = new Date();
        this.duration += (float)(finish.getTime() - this.start.getTime());
        this.finished = true;
        this.finishChildren();
    }

    public void finishChildren() {
        for (Timing child : this.getChildren()) {
            child.finish();
        }
    }

    public String stripThreadName() {
        int colonIndex = this.name.indexOf(":");
        return colonIndex == -1 ? this.name : this.name.substring(colonIndex);
    }

    public void merge(Timing timing) {
        if (!this.name.equals(timing.name)) {
            return;
        }
        this.count += timing.count;
        this.duration += timing.duration;
        for (Timing child : timing.getChildren()) {
            if (this.children.containsKey(child.getName())) {
                this.children.get(child.getName()).merge(child);
                continue;
            }
            this.children.put(child.getName(), child);
        }
    }

    public void parentOnlyMerge(Timing timing) {
        if (!this.name.equals(timing.name)) {
            return;
        }
        this.count += timing.count;
        this.duration += timing.duration;
    }

    public void restart() {
        this.start = new Date();
        ++this.count;
        this.finished = false;
    }

    public float getAverage() {
        return this.duration / (float)this.count / 1000.0f;
    }

    void getSummary(GetPerfDataResponseDocument.GetPerfDataResponse perfDataresponse, float totalDuration) {
        TPerfData perfData = perfDataresponse.addNewPerfData();
        this.populateSummary(perfData, totalDuration);
    }

    void populateSummary(TPerfData perfData, float totalDuration) {
        if (totalDuration != 0.0f) {
            perfData.setPercentage(this.getPercentage(totalDuration));
        }
        perfData.setDuration(this.getDuration());
        perfData.setAverage(this.getAverage());
        perfData.setName(this.getName());
        perfData.setCount(this.getCount());
        ArrayList<Timing> sortedTimings = new ArrayList<Timing>(this.getChildren());
        Collections.sort(sortedTimings, new TimingDurationComparator());
        for (Timing child : sortedTimings) {
            child.getSummary(perfData, totalDuration);
        }
    }

    public void populateFlatSummary(TPerfData perfData, float totalDuration) {
        if (totalDuration != 0.0f) {
            perfData.setPercentage(this.getPercentage(totalDuration));
        }
        perfData.setDuration(this.getDuration());
        perfData.setAverage(this.getAverage());
        perfData.setName(this.getName());
        perfData.setCount(this.getCount());
    }

    void getSummary(TPerfData perfDataresponse, float totalDuration) {
        TPerfData perfData = perfDataresponse.addNewChildData();
        this.populateSummary(perfData, totalDuration);
    }

    String summarize(float totalDuration) {
        float time = this.duration / 1000.0f;
        float avTime = this.getAverage() / 1000.0f;
        StringBuffer buf = new StringBuffer();
        buf.append("Duration: " + time + " s, ");
        buf.append("Average: " + avTime + " s ");
        if (totalDuration > 0.0f) {
            buf.append("percentage duration: " + this.duration / totalDuration * 100.0f + "%");
        }
        return buf.toString();
    }

    private float getPercentage(float totalDuration) {
        return this.getDuration() / totalDuration * 100.0f;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public float getDuration() {
        return this.duration / 1000.0f;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Collection<Timing> getChildren() {
        return this.children.values();
    }

    public void addChild(Timing timing) {
        this.children.put(timing.getName(), timing);
    }

    public Timing startChildTiming(String id) {
        Timing timing = this.children.get(id);
        if (timing == null) {
            timing = new Timing(id);
            this.children.put(timing.getName(), timing);
        } else {
            timing.restart();
        }
        return timing;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public boolean equals(Object obj) {
        boolean equals = obj instanceof Timing;
        if (equals) {
            equals = ((Timing)obj).getName().equals(this.getName());
        }
        return equals;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

