/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.internal.hts.util.xbeans;

import com.ibm.cognos.internal.hts._1.BeplNotificationDocument;
import com.ibm.cognos.internal.hts._1.CogBeplNotification;
import com.ibm.cognos.internal.hts._1.ManualTaskDocument;
import com.ibm.cognos.internal.hts.service.HumanTaskServiceException;
import com.ibm.cognos.internal.hts.util.HTSSDKUtils;
import com.ibm.cognos.internal.hts.util.TimeUtils;
import com.ibm.cognos.internal.hts.util.xbeans.BeplRequestFactory;
import com.ibm.cognos.internal.hts.ws_ht.TGenericHumanRole;
import com.ibm.cognos.internal.hts.ws_ht.api.ext.SubscriptionEventState;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Calendar;
import org.apache.xmlbeans.XmlObject;

public class BeplNotificationRequestFactory
extends BeplRequestFactory {
    private CogBeplNotification cogBeplNotification = CogBeplNotification.Factory.newInstance();

    public BeplNotificationRequestFactory(String subject, int priority) throws IOException {
        super(subject);
        this.cogBeplNotification.setPriority(new BigInteger(String.valueOf(priority)));
        this.peopleAssignments = this.cogBeplNotification.addNewPeopleAssignments();
    }

    public XmlObject getNotification() throws HumanTaskServiceException {
        if (this.linksList.getLinkArray().length > 0) {
            this.manualTask.setLinksList(this.linksList);
        }
        ManualTaskDocument manualDocument = ManualTaskDocument.Factory.newInstance();
        manualDocument.setManualTask(this.manualTask);
        BeplNotificationDocument beplNoteDocument = BeplNotificationDocument.Factory.newInstance();
        beplNoteDocument.setBeplNotification(this.cogBeplNotification);
        return HTSSDKUtils.createNotificationTask(beplNoteDocument, manualDocument);
    }

    public void setRecordAcknowledge(boolean acknowledge) {
        this.manualTask.setRecordReadReceipt(acknowledge);
    }

    public void setAcknowledgeSubscription() {
        this.manualTask.setNotifyNotStarted(SubscriptionEventState.INDIVIDUAL_SUBSCRIBE);
    }

    public void setCreateSubscription() {
        this.manualTask.setNotifyOnCreation(SubscriptionEventState.INDIVIDUAL_SUBSCRIBE);
    }

    public void setAcknowledgeBy(String startBy) throws HumanTaskServiceException {
        if (startBy != null && startBy.length() > 0) {
            Calendar cal = TimeUtils.getCalendar(startBy);
            TimeUtils.resetHours(cal);
            this.manualTask.setStartUntil(cal);
            this.manualTask.setRecordReadReceipt(true);
        }
    }

    public void setRecipients(String lpg, String[] recipients, String[] recipientGroups) throws IOException {
        TGenericHumanRole genericHumanRole = TGenericHumanRole.Factory.newInstance();
        genericHumanRole.setFrom(this.createOrganizationalEntity(lpg, recipients, recipientGroups));
        this.peopleAssignments.setRecipientsArray(new TGenericHumanRole[]{genericHumanRole});
    }
}

